/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlObjectParser;

public class ServerSidePreferences
extends Preferences {
    private static final Logger logger = Logger.getLogger(ServerSidePreferences.class.getName());
    private final Connection connection;

    public ServerSidePreferences(URL uRL) {
        Connection connection = null;
        try {
            connection = new Connection(new URL(uRL + "user/preferences"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not load preferences from server."), I18n.tr("Error"), 0);
        }
        this.connection = connection;
    }

    public String getPreferencesDir() {
        return this.connection.serverUrl.toString();
    }

    public void load() {
    }

    public void save() {
    }

    public void download(String string, String string2) {
        if (!this.properties.containsKey("osm-server.username") && string != null) {
            this.properties.put("osm-server.username", string);
        }
        if (!this.properties.containsKey("osm-server.password") && string2 != null) {
            this.properties.put("osm-server.password", string2);
        }
        this.download();
    }

    public boolean download() {
        this.resetToDefault();
        String string = this.connection.download();
        if (string == null) {
            return false;
        }
        StringReader stringReader = new StringReader(string);
        boolean bl = false;
        try {
            XmlObjectParser.Uniform<Prop> uniform = new XmlObjectParser.Uniform<Prop>(stringReader, "tag", Prop.class);
            for (Prop prop : uniform) {
                bl = true;
                this.properties.put(prop.key, prop.value);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        return bl;
    }

    public void upload() {
        StringBuilder stringBuilder = new StringBuilder("<preferences>\n");
        for (Map.Entry entry : this.properties.entrySet()) {
            if (((String)entry.getKey()).equals("osm-server.password")) continue;
            stringBuilder.append("<tag key='");
            stringBuilder.append(XmlWriter.encode((String)entry.getKey()));
            stringBuilder.append("' value='");
            stringBuilder.append(XmlWriter.encode((String)entry.getValue()));
            stringBuilder.append("' />\n");
        }
        stringBuilder.append("</preferences>");
        this.connection.upload(stringBuilder.toString());
    }

    public static class Prop {
        public String key;
        public String value;
    }

    private class Connection
    extends OsmConnection {
        URL serverUrl;

        public Connection(URL uRL) {
            this.serverUrl = uRL;
        }

        public String download() {
            try {
                System.out.println("reading preferences from " + this.serverUrl);
                URLConnection uRLConnection = this.serverUrl.openConnection();
                if (uRLConnection instanceof HttpURLConnection) {
                    this.addAuth((HttpURLConnection)uRLConnection);
                }
                uRLConnection.connect();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                String string = bufferedReader.readLine();
                while (string != null) {
                    stringBuilder.append(string);
                    stringBuilder.append("\n");
                    string = bufferedReader.readLine();
                }
                if (uRLConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)uRLConnection).disconnect();
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (OsmTransferException osmTransferException) {
                osmTransferException.printStackTrace();
            }
            return null;
        }

        public void upload(String string) {
            try {
                URL uRL = new URL(ServerSidePreferences.this.getPreferencesDir());
                System.out.println("uploading preferences to " + uRL);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.addRequestProperty("Authorization", "Basic " + Base64.encode(ServerSidePreferences.this.get("osm-server.username") + ":" + ServerSidePreferences.this.get("osm-server.password")));
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.connect();
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(httpURLConnection.getOutputStream()));
                printWriter.println(string);
                printWriter.close();
                httpURLConnection.getInputStream().close();
                httpURLConnection.disconnect();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Preferences stored on {0}", uRL.getHost()), I18n.tr("Information"), 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not upload preferences. Reason: {0}", exception.getMessage()), I18n.tr("Error"), 0);
            }
        }
    }
}

