/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Epsg2176;
import org.openstreetmap.josm.data.projection.Epsg2177;
import org.openstreetmap.josm.data.projection.Epsg2178;
import org.openstreetmap.josm.data.projection.Epsg2179;
import org.openstreetmap.josm.data.projection.Epsg2180;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.PuwgData;
import org.openstreetmap.josm.data.projection.UTM;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Puwg
extends UTM
implements Projection,
ProjectionSubPrefs {
    public static final int DEFAULT_ZONE = 0;
    private int zone = 0;
    static PuwgData[] Zones = new PuwgData[]{new Epsg2180(), new Epsg2176(), new Epsg2177(), new Epsg2178(), new Epsg2179()};
    private static DecimalFormat decFormatter = new DecimalFormat("###0");

    @Override
    public EastNorth latlon2eastNorth(LatLon latLon) {
        PuwgData puwgData = Zones[this.zone];
        double d = puwgData.getPuwgFalseEasting();
        double d2 = puwgData.getPuwgFalseNorthing();
        double d3 = puwgData.getPuwgScaleFactor();
        double d4 = puwgData.getPuwgCentralMeridian();
        EastNorth eastNorth = this.mapLatLonToXY(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon()), d4);
        return new EastNorth(eastNorth.east() * d3 + d, eastNorth.north() * d3 + d2);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        PuwgData puwgData = Zones[this.zone];
        double d = puwgData.getPuwgFalseEasting();
        double d2 = puwgData.getPuwgFalseNorthing();
        double d3 = puwgData.getPuwgScaleFactor();
        double d4 = puwgData.getPuwgCentralMeridian();
        return this.mapXYToLatLon((eastNorth.east() - d) / d3, (eastNorth.north() - d2) / d3, d4);
    }

    @Override
    public String toString() {
        return I18n.tr("PUWG (Poland)");
    }

    @Override
    public String toCode() {
        return Zones[this.zone].toCode();
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode() + this.zone;
    }

    @Override
    public String getCacheDirectoryName() {
        return Zones[this.zone].getCacheDirectoryName();
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return Zones[this.zone].getWorldBoundsLatLon();
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 0.009;
    }

    public String eastToString(EastNorth eastNorth) {
        return decFormatter.format(eastNorth.east());
    }

    public String northToString(EastNorth eastNorth) {
        return decFormatter.format(eastNorth.north());
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel) {
        JComboBox<PuwgData> jComboBox = new JComboBox<PuwgData>(Zones);
        jComboBox.setSelectedIndex(this.zone);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("PUWG Zone")), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        int n = ((JComboBox)component).getSelectedIndex();
        return Collections.singleton(Zones[n].toCode());
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        for (PuwgData puwgData : Zones) {
            if (!string.equals(puwgData.toCode())) continue;
            return Collections.singleton(string);
        }
        return null;
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        this.zone = 0;
        if (collection != null) {
            try {
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext()) {
                    String string = iterator.next();
                    for (int i = 0; i < Zones.length; ++i) {
                        if (!string.equals(Zones[i].toCode())) continue;
                        this.zone = i;
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

