/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class Coastlines
extends Test {
    protected static int UNORDERED_COASTLINE = 901;
    protected static int REVERSED_COASTLINE = 902;
    protected static int UNCONNECTED_COASTLINE = 903;
    private List<Way> coastlines;
    private Area downloadedArea = null;

    public Coastlines() {
        super(I18n.tr("Coastlines."), I18n.tr("This test checks that coastlines are correct."));
    }

    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        OsmDataLayer osmDataLayer = Main.map.mapView.getEditLayer();
        if (osmDataLayer != null) {
            this.downloadedArea = osmDataLayer.data.getDataSourceArea();
        }
        this.coastlines = new LinkedList<Way>();
    }

    /*
     * WARNING - void declaration
     */
    public void endTest() {
        for (Way way : this.coastlines) {
            void bl5;
            Node node;
            Node node2 = way.firstNode();
            if (node2.equals(node = way.lastNode())) continue;
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            Way way2 = null;
            Way object = null;
            for (Way object2 : this.coastlines) {
                if (way == object2) continue;
                if (object2.containsNode(node2)) {
                    ++n;
                    way2 = object2;
                    if (node2.equals(object2.firstNode())) {
                        bl = true;
                    } else if (!node2.equals(object2.lastNode())) {
                        bl3 = true;
                    }
                }
                if (!object2.containsNode(node)) continue;
                ++n2;
                object = object2;
                if (node.equals(object2.lastNode())) {
                    bl2 = true;
                    continue;
                }
                if (node.equals(object2.firstNode())) continue;
                bl4 = true;
            }
            ArrayList arrayList = new ArrayList();
            arrayList.add(way);
            if (n == 0 || n2 == 0) {
                ArrayList<Node> arrayList2 = new ArrayList<Node>();
                System.out.println("Unconnected coastline: " + way.getId());
                if (n == 0 && (this.downloadedArea == null || this.downloadedArea.contains(node2.getCoor()))) {
                    System.out.println("headways: " + n + " node: " + node2.toString());
                    arrayList2.add(node2);
                }
                if (n2 == 0 && (this.downloadedArea == null || this.downloadedArea.contains(node.getCoor()))) {
                    System.out.println("tailways: " + n2 + " tail: " + node.toString());
                    arrayList2.add(node);
                }
                if (arrayList2.size() > 0) {
                    this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Unconnected coastline"), UNCONNECTED_COASTLINE, arrayList, arrayList2));
                }
            }
            boolean bl6 = false;
            boolean bl7 = false;
            if (n == 1 && bl && n2 == 1 && bl2) {
                bl7 = true;
            }
            if (n > 1 || n2 > 1) {
                boolean bl8 = true;
            } else if (bl3 || bl4) {
                boolean bl9 = true;
            } else if (bl7 && way2 == object) {
                boolean bl10 = true;
            }
            if (bl5 != false) {
                ArrayList<Node> arrayList3 = new ArrayList<Node>();
                System.out.println("Unordered coastline: " + way.toString());
                if (n > 1 || bl3 || bl7) {
                    System.out.println("head: " + node2.toString());
                    arrayList3.add(node2);
                }
                if (n2 > 1 || bl4 || bl7) {
                    System.out.println("tail: " + node.toString());
                    arrayList3.add(node);
                }
                this.errors.add(new TestError(this, Severity.ERROR, I18n.tr("Unordered coastline"), UNORDERED_COASTLINE, arrayList, arrayList3));
                continue;
            }
            if (!bl7) continue;
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Reversed coastline"), REVERSED_COASTLINE, arrayList));
        }
        this.coastlines = null;
        this.downloadedArea = null;
        super.endTest();
    }

    public void visit(Way way) {
        if (!way.isUsable()) {
            return;
        }
        String string = way.get("natural");
        if (string == null || !string.equals("coastline")) {
            return;
        }
        this.coastlines.add(way);
    }

    public Command fixError(TestError testError) {
        if (this.isFixable(testError)) {
            Way way = (Way)testError.getPrimitives().iterator().next();
            Way way2 = new Way(way);
            List<Node> list = way2.getNodes();
            Collections.reverse(list);
            way2.setNodes(list);
            return new ChangeCommand(way, way2);
        }
        return null;
    }

    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof Coastlines) {
            return testError.getCode() == REVERSED_COASTLINE;
        }
        return false;
    }
}

