/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconnectedWays
extends Test {
    protected static int UNCONNECTED_WAYS = 1301;
    protected static final String PREFIX = "validator." + UnconnectedWays.class.getSimpleName();
    Set<MyWaySegment> ways;
    Set<Node> endnodes;
    Set<Node> endnodes_highway;
    Set<Node> middlenodes;
    Set<Node> othernodes;
    QuadBuckets<Node> nodecache;
    Area ds_area;
    DataSet ds;
    double mindist;
    double minmiddledist;

    public UnconnectedWays() {
        super(I18n.tr("Unconnected ways."), I18n.tr("This test checks if a way has an endpoint very near to another way."));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.ways = new HashSet<MyWaySegment>();
        this.endnodes = new HashSet<Node>();
        this.endnodes_highway = new HashSet<Node>();
        this.middlenodes = new HashSet<Node>();
        this.othernodes = new HashSet<Node>();
        this.mindist = Main.pref.getDouble(PREFIX + ".node_way_distance", 10.0) / 6378135.0;
        this.minmiddledist = Main.pref.getDouble(PREFIX + ".way_way_distance", 0.0) / 6378135.0;
        this.ds = Main.main.getCurrentDataSet();
        this.ds_area = this.ds.getDataSourceArea();
    }

    @Override
    public void endTest() {
        HashMap<Node, Way> hashMap = new HashMap<Node, Way>();
        for (int i = 0; i < 1; ++i) {
            long l = -1L;
            int n = 0;
            Set<MyWaySegment> set = this.ways;
            for (MyWaySegment myWaySegment : set) {
                ++n;
                long l2 = System.currentTimeMillis();
                if (l2 - l > 200L) {
                    l = l2;
                }
                for (Node node : myWaySegment.nearbyNodes(this.mindist)) {
                    if (node == null || !myWaySegment.highway || !this.endnodes_highway.contains(node) || "turning_circle".equals(node.get("highway")) || "bus_stop".equals(node.get("highway")) || OsmUtils.isTrue(node.get("noexit")) || node.hasKey("barrier")) continue;
                    hashMap.put(node, myWaySegment.w);
                }
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Way end node near other highway"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
        }
        hashMap.clear();
        for (MyWaySegment myWaySegment : this.ways) {
            for (Node node : myWaySegment.nearbyNodes(this.mindist)) {
                if (this.endnodes_highway.contains(node) && !myWaySegment.highway && !myWaySegment.isArea()) {
                    hashMap.put(node, myWaySegment.w);
                    continue;
                }
                if (!this.endnodes.contains(node) || myWaySegment.isArea()) continue;
                hashMap.put(node, myWaySegment.w);
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Way end node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
        }
        if (this.minmiddledist > 0.0) {
            hashMap.clear();
            for (MyWaySegment myWaySegment : this.ways) {
                for (Node node : myWaySegment.nearbyNodes(this.minmiddledist)) {
                    if (!this.middlenodes.contains(node)) continue;
                    hashMap.put(node, myWaySegment.w);
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Way node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
            }
            hashMap.clear();
            for (MyWaySegment myWaySegment : this.ways) {
                for (Node node : myWaySegment.nearbyNodes(this.minmiddledist)) {
                    if (!this.othernodes.contains(node)) continue;
                    hashMap.put(node, myWaySegment.w);
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Connected way end node near other way"), UNCONNECTED_WAYS, Arrays.asList((OsmPrimitive)entry.getKey(), (OsmPrimitive)entry.getValue())));
            }
        }
        this.ways = null;
        this.endnodes = null;
        super.endTest();
    }

    List<MyWaySegment> getWaySegments(Way way) {
        ArrayList<MyWaySegment> arrayList = new ArrayList<MyWaySegment>();
        if (!way.isUsable() || way.hasKey("barrier") || "cliff".equals(way.get("natural"))) {
            return arrayList;
        }
        int n = way.getNodesCount();
        if (n < 2) {
            return arrayList;
        }
        for (int i = 1; i < n; ++i) {
            if (i < n - 1) {
                this.addNode(way.getNode(i), this.middlenodes);
            }
            MyWaySegment myWaySegment = new MyWaySegment(way, way.getNode(i - 1), way.getNode(i));
            if (myWaySegment.isBoundary || myWaySegment.isAbandoned) continue;
            arrayList.add(myWaySegment);
        }
        return arrayList;
    }

    @Override
    public void visit(Way way) {
        this.ways.addAll(this.getWaySegments(way));
        Set<Node> set = this.endnodes;
        if (way.hasKey("highway") || way.hasKey("railway")) {
            set = this.endnodes_highway;
        }
        this.addNode(way.firstNode(), set);
        this.addNode(way.lastNode(), set);
    }

    @Override
    public void visit(Node node) {
    }

    private void addNode(Node node, Set<Node> set) {
        boolean bl = this.middlenodes.contains(node);
        boolean bl2 = this.endnodes.contains(node);
        boolean bl3 = this.endnodes_highway.contains(node);
        boolean bl4 = this.othernodes.contains(node);
        if (!(bl || bl2 || bl4 || bl3)) {
            set.add(node);
        } else if (!bl4) {
            this.othernodes.add(node);
            if (bl2) {
                this.endnodes.remove(node);
            } else if (bl3) {
                this.endnodes_highway.remove(node);
            } else {
                this.middlenodes.remove(node);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyWaySegment {
        private final Line2D line;
        public final Way w;
        public final boolean isAbandoned;
        public final boolean isBoundary;
        public final boolean highway;
        private final double len;
        private Set<Node> nearbyNodeCache;
        double nearbyNodeCacheDist = -1.0;
        final Node n1;
        final Node n2;

        public MyWaySegment(Way way, Node node, Node node2) {
            this.w = way;
            String string = way.get("railway");
            String string2 = way.get("highway");
            this.isAbandoned = "abandoned".equals(string) || OsmUtils.isTrue(way.get("disused"));
            this.highway = (string2 != null || string != null) && !this.isAbandoned;
            this.isBoundary = !this.highway && "administrative".equals(way.get("boundary"));
            this.line = new Line2D.Double(node.getEastNorth().east(), node.getEastNorth().north(), node2.getEastNorth().east(), node2.getEastNorth().north());
            this.len = this.line.getP1().distance(this.line.getP2());
            this.n1 = node;
            this.n2 = node2;
        }

        public boolean nearby(Node node, double d) {
            if (this.w == null) {
                Main.debug("way null");
                return false;
            }
            if (this.w.containsNode(node)) {
                return false;
            }
            EastNorth eastNorth = node.getEastNorth();
            if (eastNorth == null) {
                return false;
            }
            Point2D.Double double_ = new Point2D.Double(eastNorth.east(), eastNorth.north());
            if (this.line.getP1().distance(double_) > this.len + d) {
                return false;
            }
            if (this.line.getP2().distance(double_) > this.len + d) {
                return false;
            }
            return this.line.ptSegDist(double_) < d;
        }

        public List<LatLon> getBounds(double d) {
            double d2;
            double d3;
            double d4;
            double d5 = this.n1.getCoor().lon();
            if (d5 > (d4 = this.n2.getCoor().lon())) {
                d3 = d5;
                d5 = d4;
                d4 = d3;
            }
            if ((d3 = this.n1.getCoor().lat()) > (d2 = this.n2.getCoor().lat())) {
                double d6 = d3;
                d3 = d2;
                d2 = d6;
            }
            LatLon latLon = new LatLon(d2 + d, d5 - d);
            LatLon latLon2 = new LatLon(d3 - d, d4 + d);
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(latLon);
            arrayList.add(latLon2);
            return arrayList;
        }

        public Collection<Node> nearbyNodes(double d) {
            if (d > this.nearbyNodeCacheDist) {
                this.nearbyNodeCache = null;
            }
            if (this.nearbyNodeCache != null) {
                if (this.nearbyNodeCacheDist > d) {
                    HashSet<Node> hashSet = new HashSet<Node>(this.nearbyNodeCache);
                    for (Node node : new HashSet<Node>(this.nearbyNodeCache)) {
                        if (this.nearby(node, d)) continue;
                        hashSet.remove(node);
                    }
                    return hashSet;
                }
                return this.nearbyNodeCache;
            }
            this.nearbyNodeCache = null;
            List<LatLon> list = this.getBounds(d);
            List<Node> list2 = UnconnectedWays.this.ds.searchNodes(new BBox(list.get(0), list.get(1)));
            if (list2 == null) {
                return Collections.emptySet();
            }
            for (Node node : list2) {
                if (!this.nearby(node, d) || UnconnectedWays.this.ds_area != null && !UnconnectedWays.this.ds_area.contains(node.getCoor())) continue;
                if (this.nearbyNodeCache == null) {
                    this.nearbyNodeCache = new HashSet<Node>();
                }
                this.nearbyNodeCache.add(node);
            }
            this.nearbyNodeCacheDist = d;
            if (this.nearbyNodeCache == null) {
                this.nearbyNodeCache = Collections.emptySet();
            }
            return this.nearbyNodeCache;
        }

        public boolean isArea() {
            return this.w.hasKey("landuse") || this.w.hasKey("leisure") || this.w.hasKey("amenity") || this.w.hasKey("building");
        }
    }
}

