/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.WindowGeometry;

public class HistoryBrowserDialogManager
implements MapView.LayerChangeListener {
    private static HistoryBrowserDialogManager instance;
    private Map<Long, HistoryBrowserDialog> dialogs = new HashMap<Long, HistoryBrowserDialog>();

    public static HistoryBrowserDialogManager getInstance() {
        if (instance == null) {
            instance = new HistoryBrowserDialogManager();
        }
        return instance;
    }

    protected HistoryBrowserDialogManager() {
        MapView.addLayerChangeListener(this);
    }

    public boolean existsDialog(long l) {
        return this.dialogs.containsKey(l);
    }

    public void show(long l, HistoryBrowserDialog historyBrowserDialog) {
        if (this.dialogs.values().contains(historyBrowserDialog)) {
            this.show(l);
        } else {
            this.placeOnScreen(historyBrowserDialog);
            historyBrowserDialog.setVisible(true);
            this.dialogs.put(l, historyBrowserDialog);
        }
    }

    public void show(long l) {
        if (this.dialogs.keySet().contains(l)) {
            this.dialogs.get(l).toFront();
        }
    }

    protected boolean hasDialogWithCloseUpperLeftCorner(Point point) {
        for (HistoryBrowserDialog historyBrowserDialog : this.dialogs.values()) {
            Point point2 = historyBrowserDialog.getLocation();
            if (point.x < point2.x - 5 || point2.x + 5 < point.x || point.y < point2.y - 5 || point2.y + 5 < point.y) continue;
            return true;
        }
        return false;
    }

    public void placeOnScreen(HistoryBrowserDialog historyBrowserDialog) {
        WindowGeometry windowGeometry = WindowGeometry.centerOnScreen(new Dimension(800, 500));
        windowGeometry.apply(historyBrowserDialog);
        Point point = historyBrowserDialog.getLocation();
        while (this.hasDialogWithCloseUpperLeftCorner(point)) {
            point.x += 20;
            point.y += 20;
        }
        historyBrowserDialog.setLocation(point);
    }

    public void hide(HistoryBrowserDialog historyBrowserDialog) {
        long l = 0L;
        for (long l2 : this.dialogs.keySet()) {
            if (this.dialogs.get(l2) != historyBrowserDialog) continue;
            l = l2;
            break;
        }
        if (l > 0L) {
            this.dialogs.remove(l);
        }
        historyBrowserDialog.setVisible(false);
        historyBrowserDialog.dispose();
    }

    public void hideAll() {
        ArrayList<HistoryBrowserDialog> arrayList = new ArrayList<HistoryBrowserDialog>();
        arrayList.addAll(this.dialogs.values());
        for (HistoryBrowserDialog historyBrowserDialog : arrayList) {
            historyBrowserDialog.unlinkAsListener();
            this.hide(historyBrowserDialog);
        }
    }

    public void show(History history) {
        if (history == null) {
            return;
        }
        if (this.existsDialog(history.getId())) {
            this.show(history.getId());
        } else {
            HistoryBrowserDialog historyBrowserDialog = new HistoryBrowserDialog(history);
            this.show(history.getId(), historyBrowserDialog);
        }
    }

    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    public void layerAdded(Layer layer) {
    }

    public void layerRemoved(Layer layer) {
        if (Main.map.mapView.getNumLayers() == 0) {
            this.hideAll();
        }
    }
}

