/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.io.CacheFiles;

public class ThumbsLoader
implements Runnable {
    public static final int maxSize = 120;
    public static final int minSize = 22;
    volatile boolean stop = false;
    List<ImageEntry> data;
    GeoImageLayer layer;
    MediaTracker tracker;
    CacheFiles cache;
    boolean cacheOff = Main.pref.getBoolean("geoimage.noThumbnailCache", false);

    public ThumbsLoader(GeoImageLayer geoImageLayer) {
        this.layer = geoImageLayer;
        this.data = new ArrayList<ImageEntry>(geoImageLayer.data);
        if (!this.cacheOff) {
            this.cache = new CacheFiles("geoimage-thumbnails", false);
            this.cache.setExpire(-1, false);
            this.cache.setMaxSize(120, false);
        }
    }

    public void run() {
        System.err.println("Load Thumbnails");
        this.tracker = new MediaTracker(Main.map.mapView);
        for (int i = 0; i < this.data.size(); ++i) {
            if (this.stop) {
                return;
            }
            System.err.print("fetching image " + i);
            this.data.get((int)i).thumbnail = this.loadThumb(this.data.get(i));
            if (Main.map == null || Main.map.mapView == null) continue;
            this.layer.updateOffscreenBuffer = true;
            Main.map.mapView.repaint();
        }
        this.layer.updateOffscreenBuffer = true;
        Main.map.mapView.repaint();
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.gc();
            }
        }.start();
    }

    private BufferedImage loadThumb(ImageEntry imageEntry) {
        Image image;
        String string = imageEntry.getFile().toString() + ":" + 120;
        if (!this.cacheOff && (image = this.cache.getImg(string)) != null) {
            System.err.println(" from cache");
            return image;
        }
        image = Toolkit.getDefaultToolkit().createImage(imageEntry.getFile().getPath());
        this.tracker.addImage(image, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.err.println(" InterruptedException");
            return null;
        }
        if (this.tracker.isErrorID(1) || image.getWidth(null) <= 0 || image.getHeight(null) <= 0) {
            System.err.println(" Invalid image");
            return null;
        }
        Rectangle rectangle = ImageDisplay.calculateDrawImageRectangle(new Rectangle(0, 0, image.getWidth(null), image.getHeight(null)), new Rectangle(0, 0, 120, 120));
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        while (!graphics2D.drawImage(image, 0, 0, rectangle.width, rectangle.height, null)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        graphics2D.dispose();
        this.tracker.removeImage(image);
        if (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0) {
            System.err.println(" Invalid image");
            return null;
        }
        if (!this.cacheOff) {
            this.cache.saveImg(string, bufferedImage);
        }
        System.err.println("");
        return bufferedImage;
    }
}

