/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmWriter
extends XmlWriter
implements Visitor {
    public static final String DEFAULT_API_VERSION = "0.6";
    private boolean osmConform;
    private boolean withBody = true;
    private String version;
    private Changeset changeset;
    private static final Comparator<OsmPrimitive> byIdComparator = new Comparator<OsmPrimitive>(){

        @Override
        public int compare(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
            return osmPrimitive.getUniqueId() < osmPrimitive2.getUniqueId() ? -1 : (osmPrimitive.getUniqueId() == osmPrimitive2.getUniqueId() ? 0 : 1);
        }
    };
    private static final Comparator<Map.Entry<String, String>> byKeyComparator = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> entry, Map.Entry<String, String> entry2) {
            return entry.getKey().compareTo(entry2.getKey());
        }
    };

    public OsmWriter(PrintWriter printWriter, boolean bl, String string) {
        super(printWriter);
        this.osmConform = bl;
        this.version = string == null ? DEFAULT_API_VERSION : string;
    }

    public void setWithBody(boolean bl) {
        this.withBody = bl;
    }

    public void setChangeset(Changeset changeset) {
        this.changeset = changeset;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void header() {
        this.out.println("<?xml version='1.0' encoding='UTF-8'?>");
        this.out.print("<osm version='");
        this.out.print(this.version);
        this.out.println("' generator='JOSM'>");
    }

    public void footer() {
        this.out.println("</osm>");
    }

    private Collection<OsmPrimitive> sortById(Collection<? extends OsmPrimitive> collection) {
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection.size());
        arrayList.addAll(collection);
        Collections.sort(arrayList, byIdComparator);
        return arrayList;
    }

    public void writeContent(DataSet dataSet) {
        for (OsmPrimitive osmPrimitive : this.sortById(dataSet.getNodes())) {
            if (!this.shouldWrite(osmPrimitive)) continue;
            this.visit((Node)osmPrimitive);
        }
        for (OsmPrimitive osmPrimitive : this.sortById(dataSet.getWays())) {
            if (!this.shouldWrite(osmPrimitive)) continue;
            this.visit((Way)osmPrimitive);
        }
        for (OsmPrimitive osmPrimitive : this.sortById(dataSet.getRelations())) {
            if (!this.shouldWrite(osmPrimitive)) continue;
            this.visit((Relation)osmPrimitive);
        }
    }

    private boolean shouldWrite(OsmPrimitive osmPrimitive) {
        return !osmPrimitive.isNewOrUndeleted() || !osmPrimitive.isDeleted();
    }

    public void writeDataSources(DataSet dataSet) {
        for (DataSource dataSource : dataSet.dataSources) {
            this.out.println("  <bounds minlat='" + dataSource.bounds.getMin().lat() + "' minlon='" + dataSource.bounds.getMin().lon() + "' maxlat='" + dataSource.bounds.getMax().lat() + "' maxlon='" + dataSource.bounds.getMax().lon() + "' origin='" + XmlWriter.encode(dataSource.origin) + "' />");
        }
    }

    @Override
    public void visit(Node node) {
        if (node.isIncomplete()) {
            return;
        }
        this.addCommon(node, "node");
        this.out.print(" lat='" + node.getCoor().lat() + "' lon='" + node.getCoor().lon() + "'");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.addTags(node, "node", true);
        }
    }

    @Override
    public void visit(Way way) {
        if (way.isIncomplete()) {
            return;
        }
        this.addCommon(way, "way");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (Node node : way.getNodes()) {
                this.out.println("    <nd ref='" + node.getUniqueId() + "' />");
            }
            this.addTags(way, "way", false);
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isIncomplete()) {
            return;
        }
        this.addCommon(relation, "relation");
        if (!this.withBody) {
            this.out.println("/>");
        } else {
            this.out.println(">");
            for (RelationMember relationMember : relation.getMembers()) {
                this.out.print("    <member type='");
                this.out.print(OsmPrimitiveType.from(relationMember.getMember()).getAPIName());
                this.out.println("' ref='" + relationMember.getMember().getUniqueId() + "' role='" + XmlWriter.encode(relationMember.getRole()) + "' />");
            }
            this.addTags(relation, "relation", false);
        }
    }

    @Override
    public void visit(Changeset changeset) {
        this.out.print("  <changeset ");
        this.out.print(" id='" + changeset.getId() + "'");
        if (changeset.getUser() != null) {
            this.out.print(" user='" + changeset.getUser().getName() + "'");
            this.out.print(" uid='" + changeset.getUser().getId() + "'");
        }
        if (changeset.getCreatedAt() != null) {
            this.out.print(" created_at='" + DateUtils.fromDate(changeset.getCreatedAt()) + "'");
        }
        if (changeset.getClosedAt() != null) {
            this.out.print(" closed_at='" + DateUtils.fromDate(changeset.getClosedAt()) + "'");
        }
        this.out.print(" open='" + (changeset.isOpen() ? "true" : "false") + "'");
        if (changeset.getMin() != null) {
            this.out.print(" min_lon='" + changeset.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" min_lat='" + changeset.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        if (changeset.getMax() != null) {
            this.out.print(" max_lon='" + changeset.getMin().lonToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
            this.out.print(" max_lat='" + changeset.getMin().latToString(CoordinateFormat.DECIMAL_DEGREES) + "'");
        }
        this.out.println(">");
        this.addTags(changeset, "changeset", false);
    }

    private void addTags(Tagged tagged, String string, boolean bl) {
        if (tagged.hasKeys()) {
            if (bl) {
                this.out.println(">");
            }
            ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(tagged.getKeys().entrySet());
            Collections.sort(arrayList, byKeyComparator);
            for (Map.Entry entry : arrayList) {
                if (!(tagged instanceof Changeset) && "created_by".equals(entry.getKey())) continue;
                this.out.println("    <tag k='" + XmlWriter.encode((String)entry.getKey()) + "' v='" + XmlWriter.encode((String)entry.getValue()) + "' />");
            }
            this.out.println("  </" + string + ">");
        } else if (bl) {
            this.out.println(" />");
        } else {
            this.out.println("  </" + string + ">");
        }
    }

    private void addCommon(OsmPrimitive osmPrimitive, String string) {
        this.out.print("  <" + string);
        if (osmPrimitive.getUniqueId() == 0L) {
            throw new IllegalStateException(I18n.tr("Unexpected id 0 for osm primitive found"));
        }
        this.out.print(" id='" + osmPrimitive.getUniqueId() + "'");
        if (!this.osmConform) {
            String string2 = null;
            if (osmPrimitive.isDeleted()) {
                string2 = "delete";
            } else if (osmPrimitive.isModified()) {
                string2 = "modify";
            }
            if (string2 != null) {
                this.out.print(" action='" + string2 + "'");
            }
        }
        if (!osmPrimitive.isTimestampEmpty()) {
            this.out.print(" timestamp='" + DateUtils.fromDate(osmPrimitive.getTimestamp()) + "'");
        }
        if (osmPrimitive.getUser() != null) {
            if (osmPrimitive.getUser().isLocalUser()) {
                this.out.print(" user='" + XmlWriter.encode(osmPrimitive.getUser().getName()) + "'");
            } else if (osmPrimitive.getUser().isOsmUser()) {
                this.out.print(" uid='" + osmPrimitive.getUser().getId() + "'");
                this.out.print(" user='" + XmlWriter.encode(osmPrimitive.getUser().getName()) + "'");
            }
        }
        this.out.print(" visible='" + osmPrimitive.isVisible() + "'");
        if (osmPrimitive.getVersion() != 0L) {
            this.out.print(" version='" + osmPrimitive.getVersion() + "'");
        }
        if (this.changeset != null && this.changeset.getId() != 0) {
            this.out.print(" changeset='" + this.changeset.getId() + "'");
        } else if (osmPrimitive.getChangesetId() > 0 && !osmPrimitive.isNew()) {
            this.out.print(" changeset='" + osmPrimitive.getChangesetId() + "'");
        }
    }

    public void close() {
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }
}

