/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class CheckParameterUtil {
    private CheckParameterUtil() {
    }

    public static void ensureValidPrimitiveId(PrimitiveId primitiveId, String string) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(primitiveId, string);
        if (primitiveId.getUniqueId() <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected unique id > 0 for primitive ''{1}'', got {0}", primitiveId.getUniqueId(), string));
        }
    }

    public static void ensureValidVersion(long l, String string) throws IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value of type long > 0 for parameter ''{0}'', got {1}", string, l));
        }
    }

    public static void ensureParameterNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' must not be null", string));
        }
    }

    public static void ensureValidNodeId(PrimitiveId primitiveId, String string) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(primitiveId, string);
        if (!primitiveId.getType().equals((Object)OsmPrimitiveType.NODE)) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' of type node expected, got ''{1}''", string, primitiveId.getType().getAPIName()));
        }
    }
}

