/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Property;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchAction
extends JosmAction
implements ParameterizedAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 10;
    private static final String SEARCH_EXPRESSION = "searchExpression";
    private static LinkedList<SearchSetting> searchHistory = null;
    private static SearchSetting lastSearch = null;

    public static Collection<SearchSetting> getSearchHistory() {
        if (searchHistory == null) {
            searchHistory = new LinkedList();
            for (String string : Main.pref.getCollection("search.history", Collections.<String>emptyList())) {
                SearchSetting searchSetting = SearchSetting.readFromString(string);
                if (searchSetting == null) continue;
                searchHistory.add(searchSetting);
            }
        }
        return searchHistory;
    }

    public static void saveToHistory(SearchSetting searchSetting) {
        if (searchHistory.isEmpty() || !searchSetting.equals(searchHistory.getFirst())) {
            searchHistory.addFirst(new SearchSetting(searchSetting));
        }
        int n = Main.pref.getInteger("search.history-size", 10);
        while (searchHistory.size() > n) {
            searchHistory.removeLast();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SearchSetting searchSetting2 : searchHistory) {
            arrayList.add(searchSetting2.writeToString());
        }
        Main.pref.putCollection("search.history", arrayList);
    }

    public static List<String> getSearchExpressionHistory() {
        ArrayList<String> arrayList = new ArrayList<String>(SearchAction.getSearchHistory().size());
        for (SearchSetting searchSetting : SearchAction.getSearchHistory()) {
            arrayList.add(searchSetting.text);
        }
        return arrayList;
    }

    public SearchAction() {
        super(I18n.tr("Search..."), "dialogs/search", I18n.tr("Search for objects."), Shortcut.registerShortcut("system:find", I18n.tr("Search..."), 70, 1), true);
        this.putValue("help", HelpUtil.ht("/Action/Search"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        SearchAction.search();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent, Map<String, Object> map) {
        if (map.get(SEARCH_EXPRESSION) == null) {
            this.actionPerformed(actionEvent);
        } else {
            SearchAction.searchWithoutHistory((SearchSetting)map.get(SEARCH_EXPRESSION));
        }
    }

    public static SearchSetting showSearchDialog(SearchSetting searchSetting) {
        if (searchSetting == null) {
            searchSetting = new SearchSetting();
        }
        JLabel jLabel = new JLabel(searchSetting instanceof Filter ? I18n.tr("Please enter a filter string.") : I18n.tr("Please enter a search string."));
        final HistoryComboBox historyComboBox = new HistoryComboBox();
        historyComboBox.setText(searchSetting.text);
        historyComboBox.getEditor().selectAll();
        historyComboBox.getEditor().getEditorComponent().requestFocusInWindow();
        historyComboBox.setToolTipText(I18n.tr("Enter the search expression"));
        List<String> list = SearchAction.getSearchExpressionHistory();
        Collections.reverse(list);
        historyComboBox.setPossibleItems(list);
        historyComboBox.setPreferredSize(new Dimension(40, historyComboBox.getPreferredSize().height));
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("replace selection"), searchSetting.mode == SearchMode.replace);
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("add to selection"), searchSetting.mode == SearchMode.add);
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("remove from selection"), searchSetting.mode == SearchMode.remove);
        JRadioButton jRadioButton4 = new JRadioButton(I18n.tr("find in selection"), searchSetting.mode == SearchMode.in_selection);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        final JCheckBox jCheckBox = new JCheckBox(I18n.tr("case sensitive"), searchSetting.caseSensitive);
        JCheckBox jCheckBox2 = new JCheckBox(I18n.tr("all objects"), searchSetting.allElements);
        jCheckBox2.setToolTipText(I18n.tr("Also include incomplete and deleted objects in search."));
        final JCheckBox jCheckBox3 = new JCheckBox(I18n.tr("regular expression"), searchSetting.regexSearch);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, GBC.eop());
        jPanel.add((Component)historyComboBox, GBC.eop().fill(2));
        jPanel.add((Component)jRadioButton, GBC.eol());
        jPanel.add((Component)jRadioButton2, GBC.eol());
        jPanel.add((Component)jRadioButton3, GBC.eol());
        jPanel.add((Component)jRadioButton4, GBC.eop());
        jPanel.add((Component)jCheckBox, GBC.eol());
        jPanel.add((Component)jCheckBox2, GBC.eol());
        jPanel.add((Component)jCheckBox3, GBC.eol());
        JPanel jPanel2 = new JPanel();
        JLabel jLabel2 = new JLabel("<html><ul><li>" + I18n.tr("<b>Baker Street</b> - ''Baker'' and ''Street'' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>\"Baker Street\"</b> - ''Baker Street'' in any key or name.") + "</li>" + "<li>" + I18n.tr("<b>name:Bak</b> - ''Bak'' anywhere in the name.") + "</li>" + "<li>" + I18n.tr("<b>type=route</b> - key ''type'' with value exactly ''route''.") + "</li>" + "<li>" + I18n.tr("<b>type=*</b> - key ''type'' with any value. Try also <b>*=value</b>, <b>type=</b>, <b>*=*</b>, <b>*=</b>") + "</li>" + "<li>" + I18n.tr("<b>-name:Bak</b> - not ''Bak'' in the name.") + "</li>" + "<li>" + I18n.tr("<b>oneway?</b> - oneway=yes, true, 1 or on") + "</li>" + "<li>" + I18n.tr("<b>foot:</b> - key=foot set to any value.") + "</li>" + "<li>" + I18n.tr("<u>Special targets:</u>") + "</li>" + "<li>" + I18n.tr("<b>type:</b> - type of the object (<b>node</b>, <b>way</b>, <b>relation</b>)") + "</li>" + "<li>" + I18n.tr("<b>user:</b>... - all objects changed by user") + "</li>" + "<li>" + I18n.tr("<b>user:anonymous</b> - all objects changed by anonymous users") + "</li>" + "<li>" + I18n.tr("<b>id:</b>... - object with given ID (0 for new objects)") + "</li>" + "<li>" + I18n.tr("<b>version:</b>... - object with given version (0 objects without an assigned version)") + "</li>" + "<li>" + I18n.tr("<b>changeset:</b>... - object with given changeset id (0 objects without assigned changeset)") + "</li>" + "<li>" + I18n.tr("<b>nodes:</b>... - object with given number of nodes (nodes:count or nodes:min-max)") + "</li>" + "<li>" + I18n.tr("<b>tags:</b>... - object with given number of tags (tags:count or tags:min-max)") + "</li>" + "<li>" + I18n.tr("<b>role:</b>... - object with given role in a relation") + "</li>" + "<li>" + I18n.tr("<b>timestamp:</b>... -  objects with this timestamp (<b>2009-11-12T14:51:09Z</b>, <b>2009-11-12</b> or <b>T14:51</b> ...)") + "</li>" + "<li>" + I18n.tr("<b>modified</b> - all changed objects") + "</li>" + "<li>" + I18n.tr("<b>selected</b> - all selected objects") + "</li>" + "<li>" + I18n.tr("<b>incomplete</b> - all incomplete objects") + "</li>" + "<li>" + I18n.tr("<b>untagged</b> - all untagged objects") + "</li>" + "<li>" + I18n.tr("<b>child <i>expr</i></b> - all children of objects matching the expression") + "</li>" + "<li>" + I18n.tr("<b>parent <i>expr</i></b> - all parents of objects matching the expression") + "</li>" + "<li>" + I18n.tr("Use <b>|</b> or <b>OR</b> to combine with logical or") + "</li>" + "<li>" + I18n.tr("Use <b>\"</b> to quote operators (e.g. if key contains <b>:</b>)") + "<br/>" + I18n.tr("Within quoted strings the <b>\"</b> and <b>\\</b> characters need to be escaped by a preceding <b>\\</b> (e.g. <b>\\\"</b> and <b>\\\\</b>).") + "</li>" + "<li>" + I18n.tr("Use <b>(</b> and <b>)</b> to group expressions") + "</li>" + "</ul></html>");
        jLabel2.setFont(jLabel2.getFont().deriveFont(0));
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, searchSetting instanceof Filter ? I18n.tr("Filter") : I18n.tr("Search"), new String[]{searchSetting instanceof Filter ? I18n.tr("Submit filter") : I18n.tr("Start Search"), I18n.tr("Cancel")}){

            protected void buttonAction(int n, ActionEvent actionEvent) {
                if (n == 0) {
                    try {
                        SearchCompiler.compile(historyComboBox.getText(), jCheckBox.isSelected(), jCheckBox3.isSelected());
                        super.buttonAction(n, actionEvent);
                    }
                    catch (SearchCompiler.ParseError parseError) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Search expression is not valid: \n\n {0}", parseError.getMessage()), I18n.tr("Invalid search expression"), 0);
                    }
                } else {
                    super.buttonAction(n, actionEvent);
                }
            }
        };
        extendedDialog.setButtonIcons(new String[]{"dialogs/search.png", "cancel.png"});
        extendedDialog.configureContextsensitiveHelp("/Action/Search", true);
        extendedDialog.setContent(jPanel3);
        extendedDialog.showDialog();
        int n = extendedDialog.getValue();
        if (n != 1) {
            return null;
        }
        SearchMode searchMode = jRadioButton.isSelected() ? SearchMode.replace : (jRadioButton2.isSelected() ? SearchMode.add : (jRadioButton3.isSelected() ? SearchMode.remove : SearchMode.in_selection));
        searchSetting.text = historyComboBox.getText();
        searchSetting.mode = searchMode;
        searchSetting.caseSensitive = jCheckBox.isSelected();
        searchSetting.allElements = jCheckBox2.isSelected();
        searchSetting.regexSearch = jCheckBox3.isSelected();
        return searchSetting;
    }

    public static void search() {
        SearchSetting searchSetting = SearchAction.showSearchDialog(lastSearch);
        if (searchSetting != null) {
            SearchAction.searchWithHistory(searchSetting);
        }
    }

    public static void searchWithHistory(SearchSetting searchSetting) {
        SearchAction.saveToHistory(searchSetting);
        lastSearch = new SearchSetting(searchSetting);
        SearchAction.search(searchSetting);
    }

    public static void searchWithoutHistory(SearchSetting searchSetting) {
        lastSearch = new SearchSetting(searchSetting);
        SearchAction.search(searchSetting);
    }

    public static int getSelection(SearchSetting searchSetting, Collection<OsmPrimitive> collection, Function function) {
        int n = 0;
        try {
            String string = searchSetting.text;
            SearchCompiler.Match match = SearchCompiler.compile(string, searchSetting.caseSensitive, searchSetting.regexSearch);
            if (searchSetting.mode == SearchMode.replace) {
                collection.clear();
            }
            Collection<OsmPrimitive> collection2 = searchSetting.allElements ? Main.main.getCurrentDataSet().allPrimitives() : Main.main.getCurrentDataSet().allNonDeletedCompletePrimitives();
            for (OsmPrimitive osmPrimitive : collection2) {
                if (searchSetting.mode == SearchMode.replace) {
                    if (!match.match(osmPrimitive)) continue;
                    collection.add(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode == SearchMode.add && !function.isSomething(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    collection.add(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode == SearchMode.remove && function.isSomething(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    collection.remove(osmPrimitive);
                    ++n;
                    continue;
                }
                if (searchSetting.mode != SearchMode.in_selection || !function.isSomething(osmPrimitive).booleanValue() || match.match(osmPrimitive)) continue;
                collection.remove(osmPrimitive);
                ++n;
            }
        }
        catch (SearchCompiler.ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error"), 0);
        }
        return n;
    }

    public static void getSelection(SearchSetting searchSetting, Collection<OsmPrimitive> collection, Property<OsmPrimitive, Boolean> property) {
        try {
            String string = searchSetting.text;
            if (searchSetting instanceof Filter && ((Filter)searchSetting).inverted) {
                string = String.format("-(%s)", string);
            }
            SearchCompiler.Match match = SearchCompiler.compile(string, searchSetting.caseSensitive, searchSetting.regexSearch);
            for (OsmPrimitive osmPrimitive : collection) {
                if (searchSetting.mode == SearchMode.replace) {
                    if (match.match(osmPrimitive)) {
                        property.set(osmPrimitive, true);
                        continue;
                    }
                    property.set(osmPrimitive, false);
                    continue;
                }
                if (searchSetting.mode == SearchMode.add && !property.get(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    property.set(osmPrimitive, true);
                    continue;
                }
                if (searchSetting.mode == SearchMode.remove && property.get(osmPrimitive).booleanValue() && match.match(osmPrimitive)) {
                    property.set(osmPrimitive, false);
                    continue;
                }
                if (searchSetting.mode != SearchMode.in_selection || !property.get(osmPrimitive).booleanValue() || match.match(osmPrimitive)) continue;
                property.set(osmPrimitive, false);
            }
        }
        catch (SearchCompiler.ParseError parseError) {
            JOptionPane.showMessageDialog(Main.parent, parseError.getMessage(), I18n.tr("Error"), 0);
        }
    }

    public static void search(String string, SearchMode searchMode) {
        SearchAction.search(new SearchSetting(string, searchMode, false, false, false));
    }

    public static void search(SearchSetting searchSetting) {
        final DataSet dataSet = Main.main.getCurrentDataSet();
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(dataSet.getSelected());
        int n = SearchAction.getSelection(searchSetting, hashSet, new Function(){

            public Boolean isSomething(OsmPrimitive osmPrimitive) {
                return dataSet.isSelected(osmPrimitive);
            }
        });
        dataSet.setSelected(hashSet);
        if (n == 0) {
            String string = null;
            if (searchSetting.mode == SearchMode.replace) {
                string = I18n.tr("No match found for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.add) {
                string = I18n.tr("Nothing added to selection by searching for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.remove) {
                string = I18n.tr("Nothing removed from selection by searching for ''{0}''", searchSetting.text);
            } else if (searchSetting.mode == SearchMode.in_selection) {
                string = I18n.tr("Nothing found in selection by searching for ''{0}''", searchSetting.text);
            }
            Main.map.statusLine.setHelpText(string);
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning"), 2);
        } else {
            Main.map.statusLine.setHelpText(I18n.tr("Found {0} matches", n));
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getEditLayer() != null);
    }

    @Override
    public List<ActionParameter<?>> getActionParameters() {
        return Collections.singletonList(new ActionParameter.SearchSettingsActionParameter(SEARCH_EXPRESSION));
    }

    public static class SearchSetting {
        public String text;
        public SearchMode mode;
        public boolean caseSensitive;
        public boolean regexSearch;
        public boolean allElements;

        public SearchSetting() {
            this("", SearchMode.replace, false, false, false);
        }

        public SearchSetting(String string, SearchMode searchMode, boolean bl, boolean bl2, boolean bl3) {
            this.caseSensitive = bl;
            this.regexSearch = bl2;
            this.allElements = bl3;
            this.mode = searchMode;
            this.text = string;
        }

        public SearchSetting(SearchSetting searchSetting) {
            this(searchSetting.text, searchSetting.mode, searchSetting.caseSensitive, searchSetting.regexSearch, searchSetting.allElements);
        }

        public String toString() {
            String string = this.caseSensitive ? I18n.trc("search", "CS") : I18n.trc("search", "CI");
            String string2 = this.regexSearch ? ", " + I18n.trc("search", "RX") : "";
            String string3 = this.allElements ? ", " + I18n.trc("search", "A") : "";
            return "\"" + this.text + "\" (" + string + string2 + string3 + ", " + (Object)((Object)this.mode) + ")";
        }

        public boolean equals(Object object) {
            if (!(object instanceof SearchSetting)) {
                return false;
            }
            SearchSetting searchSetting = (SearchSetting)object;
            return searchSetting.caseSensitive == this.caseSensitive && searchSetting.regexSearch == this.regexSearch && searchSetting.allElements == this.allElements && searchSetting.mode.equals((Object)this.mode) && searchSetting.text.equals(this.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public static SearchSetting readFromString(String string) {
            if (string.length() == 0) {
                return null;
            }
            SearchSetting searchSetting = new SearchSetting();
            int n = 1;
            searchSetting.mode = SearchMode.fromCode(string.charAt(0));
            if (searchSetting.mode == null) {
                searchSetting.mode = SearchMode.replace;
                n = 0;
            }
            while (n < string.length()) {
                if (string.charAt(n) == 'C') {
                    searchSetting.caseSensitive = true;
                } else if (string.charAt(n) == 'R') {
                    searchSetting.regexSearch = true;
                } else if (string.charAt(n) == 'A') {
                    searchSetting.allElements = true;
                } else {
                    if (string.charAt(n) == ' ') break;
                    System.out.println("Uknown char in SearchSettings: " + string);
                    break;
                }
                ++n;
            }
            if (n < string.length() && string.charAt(n) == ' ') {
                ++n;
            }
            searchSetting.text = string.substring(n);
            return searchSetting;
        }

        public String writeToString() {
            if (this.text == null || this.text.length() == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.mode.getCode());
            if (this.caseSensitive) {
                stringBuilder.append('C');
            }
            if (this.regexSearch) {
                stringBuilder.append('R');
            }
            if (this.allElements) {
                stringBuilder.append('A');
            }
            stringBuilder.append(' ');
            stringBuilder.append(this.text);
            return stringBuilder.toString();
        }
    }

    public static interface Function {
        public Boolean isSomething(OsmPrimitive var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchMode {
        replace('R'),
        add('A'),
        remove('D'),
        in_selection('S');

        private final char code;

        private SearchMode(char c) {
            this.code = c;
        }

        public char getCode() {
            return this.code;
        }

        public static SearchMode fromCode(char c) {
            for (SearchMode searchMode : SearchMode.values()) {
                if (searchMode.getCode() != c) continue;
                return searchMode;
            }
            return null;
        }
    }
}

