/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipolygonTest
extends Test {
    protected static final int WRONG_MEMBER_TYPE = 1601;
    protected static final int WRONG_MEMBER_ROLE = 1602;
    protected static final int NON_CLOSED_WAY = 1603;
    protected static final int MISSING_OUTER_WAY = 1604;
    protected static final int INNER_WAY_OUTSIDE = 1605;
    protected static final int CROSSING_WAYS = 1606;
    protected static final int OUTER_STYLE_MISMATCH = 1607;
    protected static final int INNER_STYLE_MISMATCH = 1608;
    protected static final int NOT_CLOSED = 1609;
    protected static final int NO_STYLE = 1610;
    protected static final int NO_STYLE_POLYGON = 1611;
    private static ElemStyles.StyleSet styles;
    private final List<List<Node>> nonClosedWays = new ArrayList<List<Node>>();

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon"), I18n.tr("This test checks if multipolygons are valid"));
    }

    @Override
    public void initialize() throws Exception {
        styles = MapPaintStyles.getStyles().getStyleSet();
    }

    private List<List<Node>> joinWays(Collection<Way> collection) {
        ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        for (Way object : collection) {
            if (object.isClosed()) {
                arrayList.add(object.getNodes());
                continue;
            }
            arrayList2.add(object);
        }
        for (Multipolygon.JoinedWay joinedWay : Multipolygon.joinWays(arrayList2)) {
            if (!joinedWay.isClosed()) {
                this.nonClosedWays.add(joinedWay.getNodes());
                continue;
            }
            arrayList.add(joinedWay.getNodes());
        }
        return arrayList;
    }

    private GeneralPath createPath(List<Node> list) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)list.get(0).getCoor().lat(), (float)list.get(0).getCoor().lon());
        for (int i = 1; i < list.size(); ++i) {
            Node node = list.get(i);
            generalPath.lineTo((float)node.getCoor().lat(), (float)node.getCoor().lon());
        }
        return generalPath;
    }

    private List<GeneralPath> createPolygons(List<List<Node>> list) {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        for (List<Node> list2 : list) {
            arrayList.add(this.createPath(list2));
        }
        return arrayList;
    }

    private Multipolygon.PolyData.Intersection getPolygonIntersection(GeneralPath generalPath, List<Node> list) {
        boolean bl = false;
        boolean bl2 = false;
        for (Node node : list) {
            boolean bl3 = generalPath.contains(node.getCoor().lat(), node.getCoor().lon());
            if (!((bl |= bl3) & (bl2 |= !bl3))) continue;
            return Multipolygon.PolyData.Intersection.CROSSING;
        }
        return bl ? Multipolygon.PolyData.Intersection.INSIDE : Multipolygon.PolyData.Intersection.OUTSIDE;
    }

    @Override
    public void visit(Way way) {
        ElemStyle elemStyle;
        if (styles != null && !way.isClosed() && (elemStyle = styles.getArea(way)) instanceof AreaElemStyle && !((AreaElemStyle)elemStyle).closed) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Area style way is not closed"), 1609, way));
        }
    }

    @Override
    public void visit(Relation relation) {
        this.nonClosedWays.clear();
        if ("multipolygon".equals(relation.get("type"))) {
            Iterator<Object> iterator;
            Object object;
            this.checkMembersAndRoles(relation);
            Multipolygon multipolygon = new Multipolygon(Main.map.mapView);
            multipolygon.load(relation);
            if (multipolygon.getOuterWays().isEmpty()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("No outer way for multipolygon"), 1604, relation));
            }
            for (RelationMember object32 : relation.getMembers()) {
                if (object32.getMember().isUsable()) continue;
                return;
            }
            List<List<Node>> list = this.joinWays(multipolygon.getInnerWays());
            List<List<Node>> list2 = this.joinWays(multipolygon.getOuterWays());
            if (styles != null) {
                object = styles.get(relation);
                if (!(object instanceof AreaElemStyle)) {
                    Way way;
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("No style in multipolygon relation"), 1611, relation));
                    iterator = multipolygon.getOuterWays().iterator();
                    while (iterator.hasNext() && (object = styles.getArea(way = (Way)iterator.next())) == null) {
                    }
                }
                if (object instanceof AreaElemStyle) {
                    ArrayList<OsmPrimitive> arrayList;
                    ElemStyle elemStyle;
                    for (Way way : multipolygon.getInnerWays()) {
                        elemStyle = styles.get(way);
                        if (object == null || !((ElemStyle)object).equals(elemStyle)) continue;
                        arrayList = new ArrayList<OsmPrimitive>();
                        arrayList.add(relation);
                        arrayList.add(way);
                        this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Style for inner way equals multipolygon"), 1608, arrayList, Collections.singletonList(way)));
                    }
                    for (Way way : multipolygon.getOuterWays()) {
                        elemStyle = styles.get(way);
                        if (!(elemStyle instanceof AreaElemStyle) || ((ElemStyle)object).equals(elemStyle)) continue;
                        arrayList = new ArrayList();
                        arrayList.add(relation);
                        arrayList.add(way);
                        this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Style for outer way mismatches"), 1607, arrayList, Collections.singletonList(way)));
                    }
                } else {
                    this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("No style for multipolygon"), 1610, relation));
                }
            }
            if (!this.nonClosedWays.isEmpty()) {
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Multipolygon is not closed"), 1603, Collections.singletonList(relation), this.nonClosedWays));
            }
            object = this.createPolygons(list2);
            iterator = list.iterator();
            while (iterator.hasNext()) {
                List list3 = (List)iterator.next();
                boolean bl = true;
                boolean bl2 = false;
                List<Node> list4 = null;
                for (int i = 0; i < list2.size(); ++i) {
                    GeneralPath generalPath = (GeneralPath)object.get(i);
                    Multipolygon.PolyData.Intersection intersection = this.getPolygonIntersection(generalPath, list3);
                    bl &= intersection == Multipolygon.PolyData.Intersection.OUTSIDE;
                    if (intersection != Multipolygon.PolyData.Intersection.CROSSING) continue;
                    bl2 = true;
                    list4 = list2.get(i);
                }
                if (!bl && !bl2) continue;
                ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
                arrayList.add(list3);
                if (bl) {
                    this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Multipolygon inner way is outside"), 1605, Collections.singletonList(relation), arrayList));
                    continue;
                }
                if (!bl2) continue;
                arrayList.add(list4);
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Intersection between multipolygon ways"), 1606, Collections.singletonList(relation), arrayList));
            }
        }
    }

    private void checkMembersAndRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.isWay()) {
                if ("inner".equals(relationMember.getRole()) || "outer".equals(relationMember.getRole()) || !relationMember.hasRole()) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("No useful role for multipolygon member"), 1602, relationMember.getMember()));
                continue;
            }
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Non-Way in multipolygon"), 1601, relationMember.getMember()));
        }
    }
}

