/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapStatus
extends JPanel
implements Helpful {
    final MapView mv;
    final Collector collector;
    ImageLabel lonText = new ImageLabel("lon", I18n.tr("The geographic longitude at the mouse pointer."), 11);
    ImageLabel nameText = new ImageLabel("name", I18n.tr("The name of the object at the mouse pointer."), 20);
    JTextField helpText = new JTextField();
    ImageLabel latText = new ImageLabel("lat", I18n.tr("The geographic latitude at the mouse pointer."), 11);
    ImageLabel angleText = new ImageLabel("angle", I18n.tr("The angle between the previous and the current way segment."), 6);
    ImageLabel headingText = new ImageLabel("heading", I18n.tr("The (compass) heading of the line segment being drawn."), 6);
    ImageLabel distText = new ImageLabel("dist", I18n.tr("The length of the new way segment being drawn."), 10);
    public Thread thread;
    MouseState mouseState = new MouseState();
    private AWTEventListener awtListener = new AWTEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof InputEvent && ((InputEvent)aWTEvent).getComponent() == MapStatus.this.mv) {
                Collector collector = MapStatus.this.collector;
                synchronized (collector) {
                    MapStatus.this.mouseState.modifiers = ((InputEvent)aWTEvent).getModifiersEx();
                    if (aWTEvent instanceof MouseEvent) {
                        MapStatus.this.mouseState.mousePos = ((MouseEvent)aWTEvent).getPoint();
                    }
                    MapStatus.this.collector.notify();
                }
            }
        }
    };
    private MouseMotionListener mouseMotionListener = new MouseMotionListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent mouseEvent) {
            Collector collector = MapStatus.this.collector;
            synchronized (collector) {
                MapStatus.this.mouseState.modifiers = mouseEvent.getModifiersEx();
                MapStatus.this.mouseState.mousePos = mouseEvent.getPoint();
                MapStatus.this.collector.notify();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }
    };
    private KeyAdapter keyAdapter = new KeyAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent keyEvent) {
            Collector collector = MapStatus.this.collector;
            synchronized (collector) {
                MapStatus.this.mouseState.modifiers = keyEvent.getModifiersEx();
                MapStatus.this.collector.notify();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.keyPressed(keyEvent);
        }
    };

    private void registerListeners() {
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 56L);
        }
        catch (SecurityException securityException) {
            this.mv.addMouseMotionListener(this.mouseMotionListener);
            this.mv.addKeyListener(this.keyAdapter);
        }
    }

    private void unregisterListeners() {
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.mv.removeMouseMotionListener(this.mouseMotionListener);
        this.mv.removeKeyListener(this.keyAdapter);
    }

    public MapStatus(MapFrame mapFrame) {
        this.mv = mapFrame.mapView;
        this.collector = new Collector(mapFrame);
        this.lonText.addMouseListener(Main.main.menu.jumpToAct);
        this.latText.addMouseListener(Main.main.menu.jumpToAct);
        this.mv.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (MapStatus.this.mv.center == null) {
                    return;
                }
                if ((mouseEvent.getModifiersEx() & 0x80) == 0) {
                    CoordinateFormat coordinateFormat = CoordinateFormat.getDefaultFormat();
                    LatLon latLon = MapStatus.this.mv.getLatLon(mouseEvent.getX(), mouseEvent.getY());
                    MapStatus.this.latText.setText(latLon.latToString(coordinateFormat));
                    MapStatus.this.lonText.setText(latLon.lonToString(coordinateFormat));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.latText, GBC.std());
        this.add((Component)this.lonText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.headingText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.angleText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.distText, GBC.std().insets(3, 0, 0, 0));
        this.helpText.setEditable(false);
        this.add((Component)this.nameText, GBC.std().insets(3, 0, 0, 0));
        this.add((Component)this.helpText, GBC.eol().insets(3, 0, 0, 0).fill(2));
        this.thread = new Thread((Runnable)this.collector, "Map Status Collector");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public String helpTopic() {
        return "Statusline";
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.lonText.addMouseListener(mouseListener);
        this.latText.addMouseListener(mouseListener);
    }

    public void setHelpText(String string) {
        this.helpText.setText(string);
        this.helpText.setToolTipText(string);
    }

    public void setAngle(double d) {
        this.angleText.setText(d < 0.0 ? "--" : (double)Math.round(d * 10.0) / 10.0 + " \u00b0");
    }

    public void setHeading(double d) {
        this.headingText.setText(d < 0.0 ? "--" : (double)Math.round(d * 10.0) / 10.0 + " \u00b0");
    }

    public void setDist(double d) {
        this.distText.setText(d < 0.0 ? "--" : NavigatableComponent.getDistText(d));
    }

    static class MouseState {
        Point mousePos;
        int modifiers;

        MouseState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Collector
    implements Runnable {
        private Point oldMousePos;
        private List<JLabel> popupLabels = null;
        private Popup popup;
        private MapFrame parent;

        public Collector(MapFrame mapFrame) {
            this.parent = mapFrame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            MapStatus.this.registerListeners();
            try {
                while (true) {
                    MouseState mouseState = new MouseState();
                    Object object = this;
                    synchronized (object) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        mouseState.modifiers = MapStatus.this.mouseState.modifiers;
                        mouseState.mousePos = MapStatus.this.mouseState.mousePos;
                    }
                    if (this.parent != Main.map) {
                        return;
                    }
                    if (mouseState.mousePos == null || MapStatus.this.mv.center == null) continue;
                    if ((mouseState.modifiers & 0x80) != 0) {
                        this.popupUpdateLabels();
                        continue;
                    }
                    object = null;
                    try {
                        boolean bl;
                        object = MapStatus.this.mv.getCurrentDataSet();
                        if (object != null) {
                            ((DataSet)object).getReadLock().lock();
                        }
                        this.statusBarElementUpdate(mouseState);
                        boolean bl2 = this.oldMousePos != null && this.oldMousePos.equals(mouseState.mousePos) && this.popup != null;
                        boolean bl3 = bl = (mouseState.modifiers & 0x800) != 0;
                        if (bl || bl2) {
                            List<OsmPrimitive> list = MapStatus.this.mv.getAllNearest(mouseState.mousePos, OsmPrimitive.isUsablePredicate);
                            if (list == null) continue;
                            JPanel jPanel = new JPanel(new GridBagLayout());
                            JLabel jLabel = new JLabel("<html>" + I18n.tr("Middle click again to cycle through.<br>Hold CTRL to select directly from this list with the mouse.<hr>") + "</html>", null, 0);
                            jLabel.setHorizontalAlignment(2);
                            jPanel.add((Component)jLabel, GBC.eol().insets(2, 0, 2, 0));
                            if (bl2 && bl) {
                                this.popupCycleSelection(list, mouseState.modifiers);
                            }
                            ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
                            for (OsmPrimitive osmPrimitive : list) {
                                JLabel jLabel2 = this.popupBuildPrimitiveLabels(osmPrimitive);
                                arrayList.add(jLabel2);
                                jPanel.add((Component)jLabel2, GBC.eol().fill(2).insets(2, 0, 2, 2));
                            }
                            this.popupShowPopup(this.popupCreatePopup(jPanel, mouseState), arrayList);
                        } else {
                            this.popupHidePopup();
                        }
                        this.oldMousePos = mouseState.mousePos;
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                    continue;
                    catch (NullPointerException nullPointerException) {}
                    continue;
                    finally {
                        if (object == null) continue;
                        ((DataSet)object).getReadLock().unlock();
                        continue;
                    }
                    break;
                }
            }
            finally {
                MapStatus.this.unregisterListeners();
            }
        }

        private final Popup popupCreatePopup(Component component, MouseState mouseState) {
            int n;
            Point point = MapStatus.this.mv.getLocationOnScreen();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            JScrollPane jScrollPane = new JScrollPane(component);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setBorder(BorderFactory.createRaisedBevelBorder());
            Dimension dimension2 = jScrollPane.getPreferredSize();
            int n2 = Math.min(dimension2.width, Math.min(800, dimension.width / 2 - 16));
            int n3 = Math.min(dimension2.height, dimension.height - 10);
            jScrollPane.setPreferredSize(new Dimension(n2, n3));
            int n4 = point.x + mouseState.mousePos.x + 16;
            if (n4 + n2 > dimension.width && n4 > dimension.width / 2) {
                n4 = point.x + mouseState.mousePos.x - 4 - n2;
            }
            if ((n = point.y + mouseState.mousePos.y + 16) + n3 > dimension.height - 5) {
                n = Math.max(5, dimension.height - n3 - 5);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            return popupFactory.getPopup(MapStatus.this.mv, jScrollPane, n4, n);
        }

        private final void statusBarElementUpdate(MouseState mouseState) {
            OsmPrimitive osmPrimitive = MapStatus.this.mv.getNearestNodeOrWay(mouseState.mousePos, OsmPrimitive.isUsablePredicate, false);
            if (osmPrimitive != null) {
                MapStatus.this.nameText.setText(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()));
            } else {
                MapStatus.this.nameText.setText(I18n.tr("(no object)"));
            }
        }

        private final void popupCycleSelection(Collection<OsmPrimitive> collection, int n) {
            DataSet dataSet = Main.main.getCurrentDataSet();
            OsmPrimitive osmPrimitive = null;
            OsmPrimitive osmPrimitive2 = null;
            OsmPrimitive osmPrimitive3 = null;
            for (OsmPrimitive osmPrimitive4 : collection) {
                if (osmPrimitive == null) {
                    osmPrimitive = osmPrimitive4;
                }
                if (osmPrimitive2 != null && osmPrimitive3 == null) {
                    osmPrimitive3 = osmPrimitive4;
                }
                if (osmPrimitive2 != null || !dataSet.isSelected(osmPrimitive4)) continue;
                osmPrimitive2 = osmPrimitive4;
            }
            if ((n & 0x40) == 0) {
                dataSet.clearSelection();
            }
            if (osmPrimitive2 == null) {
                dataSet.addSelected(osmPrimitive);
            } else {
                dataSet.clearSelection(osmPrimitive2);
                if (osmPrimitive3 != null) {
                    dataSet.addSelected(osmPrimitive3);
                }
            }
        }

        private final void popupHidePopup() {
            this.popupLabels = null;
            if (this.popup == null) {
                return;
            }
            final Popup popup = this.popup;
            this.popup = null;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    popup.hide();
                }
            });
        }

        private final void popupShowPopup(Popup popup, List<JLabel> list) {
            final Popup popup2 = popup;
            if (this.popup != null) {
                final Popup popup3 = this.popup;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        popup2.show();
                        popup3.hide();
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        popup2.show();
                    }
                });
            }
            this.popupLabels = list;
            this.popup = popup;
        }

        private final void popupUpdateLabels() {
            if (this.popup == null || this.popupLabels == null) {
                return;
            }
            for (JLabel jLabel : this.popupLabels) {
                jLabel.validate();
            }
        }

        private final void popupSetLabelColors(JLabel jLabel, OsmPrimitive osmPrimitive) {
            DataSet dataSet = Main.main.getCurrentDataSet();
            if (dataSet.isSelected(osmPrimitive)) {
                jLabel.setBackground(SystemColor.textHighlight);
                jLabel.setForeground(SystemColor.textHighlightText);
            } else {
                jLabel.setBackground(SystemColor.control);
                jLabel.setForeground(SystemColor.controlText);
            }
        }

        private final JLabel popupBuildPrimitiveLabels(final OsmPrimitive osmPrimitive) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance());
            if (osmPrimitive.isNewOrUndeleted() || osmPrimitive.isModified()) {
                string = "<i><b>" + string + "*</b></i>";
            }
            stringBuilder.append(string);
            if (!osmPrimitive.isNew()) {
                stringBuilder.append(" [id=" + osmPrimitive.getId() + "]");
            }
            if (osmPrimitive.getUser() != null) {
                stringBuilder.append(" [" + I18n.tr("User:") + " " + osmPrimitive.getUser().getName() + "]");
            }
            for (String string2 : osmPrimitive.keySet()) {
                stringBuilder.append("<br>" + string2 + "=" + osmPrimitive.get(string2));
            }
            final JLabel jLabel = new JLabel("<html>" + stringBuilder.toString() + "</html>", ImageProvider.get(OsmPrimitiveType.from(osmPrimitive)), 0){

                public void validate() {
                    super.validate();
                    Collector.this.popupSetLabelColors(this, osmPrimitive);
                }
            };
            jLabel.setOpaque(true);
            this.popupSetLabelColors(jLabel, osmPrimitive);
            jLabel.setFont(jLabel.getFont().deriveFont(0));
            jLabel.setVerticalTextPosition(1);
            jLabel.setHorizontalAlignment(2);
            jLabel.setCursor(Cursor.getPredefinedCursor(12));
            jLabel.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setBackground(SystemColor.info);
                    jLabel.setForeground(SystemColor.infoText);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    Collector.this.popupSetLabelColors(jLabel, osmPrimitive);
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    DataSet dataSet = Main.main.getCurrentDataSet();
                    dataSet.toggleSelected(osmPrimitive);
                    jLabel.validate();
                }
            });
            jLabel.addMouseMotionListener(new MouseMotionListener(){

                public void mouseMoved(MouseEvent mouseEvent) {
                    jLabel.setBackground(SystemColor.info);
                    jLabel.setForeground(SystemColor.infoText);
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    jLabel.setBackground(SystemColor.info);
                    jLabel.setForeground(SystemColor.infoText);
                }
            });
            return jLabel;
        }
    }

    static class ImageLabel
    extends JPanel {
        private JLabel tf;
        private int chars;

        public ImageLabel(String string, String string2, int n) {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.decode("#b8cfe5"));
            this.add((Component)new JLabel(ImageProvider.get("statusline/" + string + ".png")), GBC.std().anchor(17).insets(0, 1, 1, 0));
            this.tf = new JLabel();
            this.add((Component)this.tf, GBC.std().fill(1).anchor(17).insets(2, 1, 1, 0));
            this.setToolTipText(string2);
            this.chars = n;
        }

        public void setText(String string) {
            this.tf.setText(string);
        }

        public Dimension getPreferredSize() {
            return new Dimension(25 + this.chars * this.tf.getFontMetrics(this.tf.getFont()).charWidth('0'), super.getPreferredSize().height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(25 + this.chars * this.tf.getFontMetrics(this.tf.getFont()).charWidth('0'), super.getMinimumSize().height);
        }
    }
}

