/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.relation;

import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.RelationMemberConflictResolverCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationMemberListMergeModel
extends ListMergeModel<RelationMember> {
    private DataSet myDataset;

    @Override
    public boolean isEqualEntry(RelationMember relationMember, RelationMember relationMember2) {
        return relationMember.equals(relationMember2);
    }

    @Override
    protected void buildMergedEntriesTableModel() {
        this.mergedEntriesTableModel = new ListMergeModel.EntriesTableModel(this, ListRole.MERGED_ENTRIES){
            {
                RelationMemberListMergeModel relationMemberListMergeModel3 = relationMemberListMergeModel2;
                relationMemberListMergeModel3.getClass();
                super(relationMemberListMergeModel3, listRole);
            }

            public boolean isCellEditable(int n, int n2) {
                switch (n2) {
                    case 1: {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected void setValueAt(DefaultTableModel defaultTableModel, Object object, int n, int n2) {
        if (defaultTableModel == this.getMergedTableModel() && n2 == 1) {
            RelationMember relationMember = (RelationMember)this.getMergedEntries().get(n);
            RelationMember relationMember2 = new RelationMember((String)object, relationMember.getMember());
            this.getMergedEntries().remove(n);
            this.getMergedEntries().add(n, relationMember2);
            this.fireModelDataChanged();
        }
    }

    public void populate(Relation relation, Relation relation2) {
        this.myDataset = relation.getDataSet();
        CheckParameterUtil.ensureParameterNotNull(relation, "my");
        CheckParameterUtil.ensureParameterNotNull(relation2, "their");
        this.getMergedEntries().clear();
        this.getMyEntries().clear();
        this.getTheirEntries().clear();
        for (RelationMember relationMember : relation.getMembers()) {
            this.getMyEntries().add(relationMember);
        }
        for (RelationMember relationMember : relation2.getMembers()) {
            this.getTheirEntries().add(relationMember);
        }
        if (this.myAndTheirEntriesEqual()) {
            for (RelationMember relationMember : this.getMyEntries()) {
                this.getMergedEntries().add(this.cloneEntryForMergedList(relationMember));
            }
            this.setFrozen(true);
        } else {
            this.setFrozen(false);
        }
        this.fireModelDataChanged();
    }

    @Override
    protected RelationMember cloneEntryForMergedList(RelationMember relationMember) {
        OsmPrimitive osmPrimitive = this.getMyPrimitive(relationMember);
        return new RelationMember(relationMember.getRole(), osmPrimitive);
    }

    @Override
    protected OsmPrimitive getMyPrimitive(RelationMember relationMember) {
        return this.myDataset.getPrimitiveById(relationMember.getMember());
    }

    public RelationMemberConflictResolverCommand buildResolveCommand(Relation relation, Relation relation2) {
        CheckParameterUtil.ensureParameterNotNull(relation, "my");
        CheckParameterUtil.ensureParameterNotNull(relation2, "their");
        if (!this.isFrozen()) {
            throw new IllegalArgumentException(I18n.tr("Merged nodes not frozen yet. Cannot build resolution command"));
        }
        List<RelationMember> list = this.getMergedEntries();
        return new RelationMemberConflictResolverCommand(relation, relation2, list);
    }
}

