/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSourceEditor
extends JPanel {
    private JTable tblActiveStyles;
    private ActiveStylesModel activeStylesModel;
    private JList lstAvailableStyles;
    private AvailableStylesListModel availableStylesModel;
    private JTable tblIconPaths = null;
    private IconPathTableModel iconPathsModel;
    private String pref;
    private String iconpref;
    private boolean stylesInitiallyLoaded;
    private String availableStylesUrl;

    public StyleSourceEditor(String string, String string2, String string3) {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.activeStylesModel = new ActiveStylesModel(defaultListSelectionModel);
        this.tblActiveStyles = new JTable(this.activeStylesModel);
        this.tblActiveStyles.putClientProperty("terminateEditOnFocusLost", true);
        this.tblActiveStyles.setSelectionModel(defaultListSelectionModel);
        this.tblActiveStyles.setSelectionMode(2);
        this.tblActiveStyles.setTableHeader(null);
        this.tblActiveStyles.getColumnModel().getColumn(0).setCellEditor(new FileOrUrlCellEditor(true));
        this.tblActiveStyles.setRowHeight(20);
        this.activeStylesModel.setActiveStyles(Main.pref.getCollection(string, null));
        defaultListSelectionModel = new DefaultListSelectionModel();
        this.availableStylesModel = new AvailableStylesListModel(defaultListSelectionModel);
        this.lstAvailableStyles = new JList(this.availableStylesModel);
        this.lstAvailableStyles.setSelectionModel(defaultListSelectionModel);
        this.lstAvailableStyles.setCellRenderer(new StyleSourceCellRenderer());
        this.availableStylesUrl = string3;
        this.pref = string;
        this.iconpref = string2;
        EditActiveStyleAction editActiveStyleAction = new EditActiveStyleAction();
        this.tblActiveStyles.getSelectionModel().addListSelectionListener(editActiveStyleAction);
        RemoveActiveStylesAction removeActiveStylesAction = new RemoveActiveStylesAction();
        this.tblActiveStyles.getSelectionModel().addListSelectionListener(removeActiveStylesAction);
        this.tblActiveStyles.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblActiveStyles.getActionMap().put("delete", removeActiveStylesAction);
        ActivateStylesAction activateStylesAction = new ActivateStylesAction();
        this.lstAvailableStyles.addListSelectionListener(activateStylesAction);
        JButton jButton = new JButton(activateStylesAction);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(I18n.tr("Active styles:")), GBC.eol().insets(11, 5, 5, 0));
        JScrollPane jScrollPane = new JScrollPane(this.tblActiveStyles);
        this.add((Component)jScrollPane, GBC.std().insets(10, 0, 3, 0).fill(1));
        jScrollPane.setColumnHeaderView(null);
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(new NewActiveStyleAction());
        jToolBar.add(editActiveStyleAction);
        jToolBar.add(removeActiveStylesAction);
        this.add((Component)jToolBar, GBC.eol().insets(0, 0, 10, 0).fill(3));
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        jToolBar2.setBorderPainted(false);
        jToolBar2.setOpaque(false);
        jToolBar2.add(jButton);
        this.add((Component)jToolBar2, GBC.eol().insets(12, 4, 5, 4).fill(2));
        this.add((Component)new JLabel(I18n.tr("Available styles (from {0}):", string3)), GBC.eol().insets(11, 0, 5, 0));
        this.add((Component)new JScrollPane(this.lstAvailableStyles), GBC.std().insets(10, 0, 3, 0).fill(1));
        jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(new ReloadStylesAction(string3));
        this.add((Component)jToolBar, GBC.eol().insets(0, 0, 10, 0).fill(3));
        if (string2 != null) {
            defaultListSelectionModel = new DefaultListSelectionModel();
            this.iconPathsModel = new IconPathTableModel(defaultListSelectionModel);
            this.tblIconPaths = new JTable(this.iconPathsModel);
            this.tblIconPaths.setSelectionModel(defaultListSelectionModel);
            this.tblIconPaths.setSelectionMode(2);
            this.tblIconPaths.setTableHeader(null);
            this.tblIconPaths.getColumnModel().getColumn(0).setCellEditor(new FileOrUrlCellEditor(false));
            this.tblIconPaths.setRowHeight(20);
            this.iconPathsModel.setIconPaths(Main.pref.getCollection(string2, null));
            EditIconPathAction editIconPathAction = new EditIconPathAction();
            this.tblIconPaths.getSelectionModel().addListSelectionListener(editIconPathAction);
            RemoveIconPathAction removeIconPathAction = new RemoveIconPathAction();
            this.tblIconPaths.getSelectionModel().addListSelectionListener(removeIconPathAction);
            this.tblIconPaths.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
            this.tblIconPaths.getActionMap().put("delete", removeIconPathAction);
            this.add((Component)new JSeparator(), GBC.eol().fill(2).insets(5, 10, 5, 10));
            this.add((Component)new JLabel(I18n.tr("Icon paths:")), GBC.eol().insets(11, 0, 5, 0));
            jScrollPane = new JScrollPane(this.tblIconPaths);
            this.add((Component)jScrollPane, GBC.std().insets(10, 0, 3, 0).fill(1));
            jScrollPane.setColumnHeaderView(null);
            jToolBar = new JToolBar(1);
            jToolBar.setFloatable(false);
            jToolBar.setBorderPainted(false);
            jToolBar.setOpaque(false);
            this.add((Component)jToolBar, GBC.eol().insets(0, 0, 10, 0).fill(3));
            jToolBar.add(new NewIconPathAction());
            jToolBar.add(editIconPathAction);
            jToolBar.add(removeIconPathAction);
        }
    }

    public boolean hasActiveStylesChanged() {
        return !((Object)this.activeStylesModel.getStyles()).equals(Main.pref.getCollection(this.pref, Collections.<String>emptyList()));
    }

    public Collection<String> getActiveStyles() {
        return this.activeStylesModel.getStyles();
    }

    public void removeSource(String string) {
        this.activeStylesModel.remove(string);
    }

    public boolean finish() {
        boolean bl = false;
        List<String> list = this.activeStylesModel.getStyles();
        if (list.size() > 0) {
            if (Main.pref.putCollection(this.pref, list)) {
                bl = true;
            }
        } else if (Main.pref.putCollection(this.pref, null)) {
            bl = true;
        }
        if (this.tblIconPaths != null) {
            List<String> list2 = this.iconPathsModel.getIconPaths();
            if (!list2.isEmpty()) {
                if (Main.pref.putCollection(this.iconpref, list2)) {
                    bl = true;
                }
            } else if (Main.pref.putCollection(this.iconpref, null)) {
                bl = true;
            }
        }
        return bl;
    }

    protected void reloadAvailableStyles(String string) {
        Main.worker.submit(new StyleSourceLoader(string));
    }

    public void initiallyLoadAvailableStyles() {
        if (!this.stylesInitiallyLoaded) {
            this.reloadAvailableStyles(this.availableStylesUrl);
        }
        this.stylesInitiallyLoaded = true;
    }

    class FileOrUrlCellEditor
    extends JPanel
    implements TableCellEditor {
        private JTextField tfFileName;
        private CopyOnWriteArrayList<CellEditorListener> listeners;
        private String value;
        private JFileChooser fileChooser;
        private boolean isFile;

        protected JFileChooser getFileChooser() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                if (!this.isFile) {
                    this.fileChooser.setFileSelectionMode(1);
                }
            }
            return this.fileChooser;
        }

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.tfFileName = new JTextField();
            this.add((Component)this.tfFileName, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            this.add(new JButton(new LaunchFileChooserAction()));
            this.tfFileName.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    FileOrUrlCellEditor.this.tfFileName.selectAll();
                }
            });
        }

        public FileOrUrlCellEditor(boolean bl) {
            this.isFile = bl;
            this.listeners = new CopyOnWriteArrayList();
            this.build();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            if (cellEditorListener != null) {
                this.listeners.addIfAbsent(cellEditorListener);
            }
        }

        protected void fireEditingCanceled() {
            for (CellEditorListener cellEditorListener : this.listeners) {
                cellEditorListener.editingCanceled(new ChangeEvent(this));
            }
        }

        protected void fireEditingStopped() {
            for (CellEditorListener cellEditorListener : this.listeners) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 2;
            }
            return true;
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.value = this.tfFileName.getText();
            this.fireEditingStopped();
            return true;
        }

        public void setInitialValue(String string) {
            this.value = string;
            if (string == null) {
                this.tfFileName.setText("");
            } else {
                this.tfFileName.setText(string);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.setInitialValue((String)object);
            this.tfFileName.selectAll();
            return this;
        }

        class LaunchFileChooserAction
        extends AbstractAction {
            public LaunchFileChooserAction() {
                this.putValue("Name", "...");
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file"));
            }

            protected void prepareFileChooser(String string, JFileChooser jFileChooser) {
                if (string == null || string.trim().length() == 0) {
                    return;
                }
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(string);
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    return;
                }
                if (uRL.getProtocol().startsWith("file")) {
                    File file = new File(uRL.getPath());
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = FileOrUrlCellEditor.this.getFileChooser();
                this.prepareFileChooser(FileOrUrlCellEditor.this.tfFileName.getText(), jFileChooser);
                int n = jFileChooser.showOpenDialog(JOptionPane.getFrameForComponent(StyleSourceEditor.this));
                if (n != 0) {
                    return;
                }
                FileOrUrlCellEditor.this.tfFileName.setText(jFileChooser.getSelectedFile().toString());
            }
        }
    }

    class StyleSourceLoader
    extends PleaseWaitRunnable {
        private String url;
        private BufferedReader reader;
        private boolean canceled;

        public StyleSourceLoader(String string) {
            super(I18n.tr("Loading style sources from ''{0}''", string));
            this.url = string;
        }

        protected void cancel() {
            this.canceled = true;
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected void finish() {
        }

        protected void warn(Exception exception) {
            String string = exception.getMessage() != null ? exception.getMessage() : exception.toString();
            string = string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            String string2 = I18n.tr("<html>Failed to load the list of style sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>", this.url, string);
            HelpAwareOptionPane.showOptionDialog(Main.parent, string2, I18n.tr("Error"), 0, HelpUtil.ht("Preferences/Styles#FailedToLoadStyleSources"));
        }

        protected void realRun() throws SAXException, IOException, OsmTransferException {
            LinkedList<StyleSourceInfo> linkedList = new LinkedList<StyleSourceInfo>();
            String string = LanguageInfo.getLanguageCodeXML();
            try {
                String string2;
                InputStreamReader inputStreamReader;
                StyleSourceInfo styleSourceInfo = new StyleSourceInfo("elemstyles.xml", "resource://data/elemstyles.xml");
                styleSourceInfo.shortdescription = I18n.tr("Internal style");
                styleSourceInfo.description = I18n.tr("Internal style to be used as base for runtime switchable overlay styles");
                linkedList.add(styleSourceInfo);
                MirroredInputStream mirroredInputStream = new MirroredInputStream(this.url);
                try {
                    inputStreamReader = new InputStreamReader((InputStream)mirroredInputStream, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    inputStreamReader = new InputStreamReader(mirroredInputStream);
                }
                this.reader = new BufferedReader(inputStreamReader);
                StyleSourceInfo styleSourceInfo2 = null;
                while ((string2 = this.reader.readLine()) != null && !this.canceled) {
                    Matcher matcher;
                    if (string2.trim().equals("")) continue;
                    if (string2.startsWith("\t")) {
                        matcher = Pattern.compile("^\t([^:]+): *(.+)$").matcher(string2);
                        if (!matcher.matches()) {
                            System.err.println(I18n.tr("Warning: illegal format of entry in style list ''{0}''. Got ''{1}''", this.url, string2));
                            continue;
                        }
                        if (styleSourceInfo2 == null) continue;
                        String string3 = matcher.group(1);
                        String string4 = matcher.group(2);
                        if ("author".equals(string3) && styleSourceInfo2.author == null) {
                            styleSourceInfo2.author = string4;
                            continue;
                        }
                        if ("version".equals(string3)) {
                            styleSourceInfo2.version = string4;
                            continue;
                        }
                        if ("link".equals(string3) && styleSourceInfo2.link == null) {
                            styleSourceInfo2.link = string4;
                            continue;
                        }
                        if ("description".equals(string3) && styleSourceInfo2.description == null) {
                            styleSourceInfo2.description = string4;
                            continue;
                        }
                        if ("shortdescription".equals(string3) && styleSourceInfo2.shortdescription == null) {
                            styleSourceInfo2.shortdescription = string4;
                            continue;
                        }
                        if ((string + "author").equals(string3)) {
                            styleSourceInfo2.author = string4;
                            continue;
                        }
                        if ((string + "link").equals(string3)) {
                            styleSourceInfo2.link = string4;
                            continue;
                        }
                        if ((string + "description").equals(string3)) {
                            styleSourceInfo2.description = string4;
                            continue;
                        }
                        if (!(string + "shortdescription").equals(string3)) continue;
                        styleSourceInfo2.shortdescription = string4;
                        continue;
                    }
                    styleSourceInfo2 = null;
                    matcher = Pattern.compile("^(.+);(.+)$").matcher(string2);
                    if (matcher.matches()) {
                        styleSourceInfo2 = new StyleSourceInfo(matcher.group(1), matcher.group(2));
                        linkedList.add(styleSourceInfo2);
                        continue;
                    }
                    System.err.println(I18n.tr("Warning: illegal format of entry in style list ''{0}''. Got ''{1}''", this.url, string2));
                }
            }
            catch (Exception exception) {
                if (this.canceled) {
                    return;
                }
                OsmTransferException osmTransferException = new OsmTransferException(exception);
                osmTransferException.setUrl(this.url);
                this.warn(osmTransferException);
                return;
            }
            StyleSourceEditor.this.availableStylesModel.setStyleSources(linkedList);
        }
    }

    static class StyleSourceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        StyleSourceCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            this.setToolTipText(((StyleSourceInfo)object).getTooltip());
            return this;
        }
    }

    class EditIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditIconPathAction() {
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("ShortDescription", I18n.tr("Edit the selected icon path"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.tblIconPaths.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = StyleSourceEditor.this.tblIconPaths.getSelectedRow();
            StyleSourceEditor.this.tblIconPaths.editCellAt(n, 0);
        }
    }

    class RemoveIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveIconPathAction() {
            this.putValue("Name", I18n.tr("Remove"));
            this.putValue("ShortDescription", I18n.tr("Remove the selected icon paths"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.tblIconPaths.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StyleSourceEditor.this.iconPathsModel.removeSelected();
        }
    }

    class NewIconPathAction
    extends AbstractAction {
        public NewIconPathAction() {
            this.putValue("Name", I18n.tr("New"));
            this.putValue("ShortDescription", I18n.tr("Add a new icon path"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StyleSourceEditor.this.iconPathsModel.addPath("");
            StyleSourceEditor.this.tblIconPaths.editCellAt(StyleSourceEditor.this.iconPathsModel.getRowCount() - 1, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IconPathTableModel
    extends AbstractTableModel {
        private ArrayList<String> data;
        private DefaultListSelectionModel selectionModel;

        public IconPathTableModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.data = new ArrayList();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.updatePath(n, (String)object);
        }

        public void setIconPaths(Collection<String> collection) {
            this.data.clear();
            if (collection != null) {
                this.data.addAll(collection);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public void addPath(String string) {
            if (string == null) {
                return;
            }
            this.data.add(string);
            this.sort();
            this.fireTableDataChanged();
            int n = this.data.indexOf(string);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
        }

        public void updatePath(int n, String string) {
            if (string == null) {
                return;
            }
            if (n < 0 || n >= this.getRowCount()) {
                return;
            }
            this.data.set(n, string);
            this.sort();
            this.fireTableDataChanged();
            int n2 = this.data.indexOf(string);
            if (n2 >= 0) {
                this.selectionModel.setSelectionInterval(n2, n2);
            }
        }

        public void removeSelected() {
            Iterator<String> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string.equals("") && string2.equals("")) {
                        return 0;
                    }
                    if (string.equals("")) {
                        return 1;
                    }
                    if (string2.equals("")) {
                        return -1;
                    }
                    return string.compareTo(string2);
                }
            });
        }

        public List<String> getIconPaths() {
            return new ArrayList<String>(this.data);
        }
    }

    class ReloadStylesAction
    extends AbstractAction {
        private String url;

        public ReloadStylesAction(String string) {
            this.putValue("Name", I18n.tr("Reload"));
            this.putValue("ShortDescription", I18n.tr("Reloads the list of available styles from ''{0}''", string));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/refresh"));
            this.url = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MirroredInputStream.cleanup(this.url);
            StyleSourceEditor.this.reloadAvailableStyles(this.url);
        }
    }

    class ActivateStylesAction
    extends AbstractAction
    implements ListSelectionListener {
        public ActivateStylesAction() {
            this.putValue("Name", I18n.tr("Activate"));
            this.putValue("ShortDescription", I18n.tr("Add the selected available styles to the list of active styles"));
            this.putValue("SmallIcon", ImageProvider.get("preferences", "activatestyle"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.lstAvailableStyles.getSelectedIndices().length > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<StyleSourceInfo> list = StyleSourceEditor.this.availableStylesModel.getSelected();
            StyleSourceEditor.this.activeStylesModel.addStylesFromSources(list);
        }
    }

    class EditActiveStyleAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditActiveStyleAction() {
            this.putValue("Name", I18n.tr("Edit"));
            this.putValue("ShortDescription", I18n.tr("Edit the filename or URL for the selected active style"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.tblActiveStyles.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = StyleSourceEditor.this.tblActiveStyles.getSelectedRow();
            StyleSourceEditor.this.tblActiveStyles.editCellAt(n, 0);
        }
    }

    class RemoveActiveStylesAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveActiveStylesAction() {
            this.putValue("Name", I18n.tr("Remove"));
            this.putValue("ShortDescription", I18n.tr("Remove the selected styles from the list of active styles"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(StyleSourceEditor.this.tblActiveStyles.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StyleSourceEditor.this.activeStylesModel.removeSelected();
        }
    }

    class NewActiveStyleAction
    extends AbstractAction {
        public NewActiveStyleAction() {
            this.putValue("Name", I18n.tr("New"));
            this.putValue("ShortDescription", I18n.tr("Add a filename or an URL of an active style"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StyleSourceEditor.this.activeStylesModel.addStyle("");
            StyleSourceEditor.this.tblActiveStyles.requestFocusInWindow();
            StyleSourceEditor.this.tblActiveStyles.editCellAt(StyleSourceEditor.this.activeStylesModel.getRowCount() - 1, 0);
        }
    }

    public static class StyleSourceInfo {
        String version;
        String name;
        String url;
        String author;
        String link;
        String description;
        String shortdescription;

        public StyleSourceInfo(String string, String string2) {
            this.name = string;
            this.url = string2;
            this.shortdescription = null;
            this.description = null;
            this.link = null;
            this.author = null;
            this.version = null;
        }

        public String getName() {
            return this.shortdescription == null ? this.name : this.shortdescription;
        }

        public String getTooltip() {
            String string = I18n.tr("Short Description: {0}", this.getName()) + "<br>" + I18n.tr("URL: {0}", this.url);
            if (this.author != null) {
                string = string + "<br>" + I18n.tr("Author: {0}", this.author);
            }
            if (this.link != null) {
                string = string + "<br>" + I18n.tr("Webpage: {0}", this.link);
            }
            if (this.description != null) {
                string = string + "<br>" + I18n.tr("Description: {0}", this.description);
            }
            if (this.version != null) {
                string = string + "<br>" + I18n.tr("Version: {0}", this.version);
            }
            return "<html>" + string + "</html>";
        }

        public String toString() {
            return this.getName() + " (" + this.url + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActiveStylesModel
    extends AbstractTableModel {
        private ArrayList<String> data;
        private DefaultListSelectionModel selectionModel;

        public ActiveStylesModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.data = new ArrayList();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.updateStyle(n, (String)object);
        }

        public void setActiveStyles(Collection<String> collection) {
            this.data.clear();
            if (collection != null) {
                this.data.addAll(collection);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public void addStyle(String string) {
            if (string == null) {
                return;
            }
            this.data.add(string);
            this.sort();
            this.fireTableDataChanged();
            int n = this.data.indexOf(string);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
        }

        public void updateStyle(int n, String string) {
            if (string == null) {
                return;
            }
            if (n < 0 || n >= this.getRowCount()) {
                return;
            }
            this.data.set(n, string);
            this.sort();
            this.fireTableDataChanged();
            int n2 = this.data.indexOf(string);
            if (n2 >= 0) {
                this.selectionModel.setSelectionInterval(n2, n2);
            }
        }

        public void removeSelected() {
            Iterator<String> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireTableDataChanged();
        }

        public void remove(String string) {
            this.data.remove(string);
            this.fireTableDataChanged();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string.equals("") && string2.equals("")) {
                        return 0;
                    }
                    if (string.equals("")) {
                        return 1;
                    }
                    if (string2.equals("")) {
                        return -1;
                    }
                    return string.compareTo(string2);
                }
            });
        }

        public void addStylesFromSources(List<StyleSourceInfo> list) {
            if (list == null) {
                return;
            }
            for (StyleSourceInfo styleSourceInfo : list) {
                this.data.add(styleSourceInfo.url);
            }
            this.sort();
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (StyleSourceInfo styleSourceInfo : list) {
                int n = this.data.indexOf(styleSourceInfo.url);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        public List<String> getStyles() {
            return new ArrayList<String>(this.data);
        }

        public String getStyle(int n) {
            return this.data.get(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AvailableStylesListModel
    extends DefaultListModel {
        private ArrayList<StyleSourceInfo> data = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public AvailableStylesListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        public void setStyleSources(List<StyleSourceInfo> list) {
            this.data.clear();
            if (list != null) {
                this.data.addAll(list);
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        @Override
        public Object getElementAt(int n) {
            return this.data.get(n);
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public void deleteSelected() {
            Iterator<StyleSourceInfo> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        public List<StyleSourceInfo> getSelected() {
            ArrayList<StyleSourceInfo> arrayList = new ArrayList<StyleSourceInfo>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.data.get(i));
            }
            return arrayList;
        }
    }
}

