/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginListParser {
    protected PluginInformation createInfo(String string, String string2, String string3) throws PluginListParseException {
        try {
            return new PluginInformation(new ByteArrayInputStream(string3.getBytes("utf-8")), string.substring(0, string.length() - 4), string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", string), unsupportedEncodingException);
        }
        catch (PluginException pluginException) {
            throw new PluginListParseException(I18n.tr("Failed to create plugin information from manifest for plugin ''{0}''", string), pluginException);
        }
    }

    public List<PluginInformation> parse(InputStream inputStream) throws PluginListParseException {
        LinkedList<PluginInformation> linkedList = new LinkedList<PluginInformation>();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
            String string = null;
            Object object = null;
            StringBuilder stringBuilder = new StringBuilder();
            Object object2 = bufferedReader.readLine();
            while (object2 != null) {
                if (((String)object2).startsWith("\t")) {
                    if (((String)(object2 = ((String)object2).substring(1))).length() > 70) {
                        stringBuilder.append(((String)object2).substring(0, 70)).append("\n");
                        object2 = " " + ((String)object2).substring(70);
                    }
                    stringBuilder.append((String)object2).append("\n");
                } else {
                    Object object3;
                    if (string != null && (object3 = this.createInfo(string, (String)object, stringBuilder.toString())) != null) {
                        for (PluginProxy pluginProxy : PluginHandler.pluginList) {
                            if (!pluginProxy.getPluginInformation().name.equals(((PluginInformation)object3).getName())) continue;
                            ((PluginInformation)object3).localversion = pluginProxy.getPluginInformation().localversion;
                        }
                        linkedList.add((PluginInformation)object3);
                    }
                    object3 = ((String)object2).split(";");
                    string = object3[0];
                    object = object3[1];
                    stringBuilder = new StringBuilder();
                }
                object2 = bufferedReader.readLine();
            }
            if (string != null && (object2 = this.createInfo(string, (String)object, stringBuilder.toString())) != null) {
                for (PluginProxy pluginProxy : PluginHandler.pluginList) {
                    if (!pluginProxy.getPluginInformation().name.equals(((PluginInformation)object2).getName())) continue;
                    ((PluginInformation)object2).localversion = pluginProxy.getPluginInformation().localversion;
                }
                linkedList.add((PluginInformation)object2);
            }
            return linkedList;
        }
        catch (IOException iOException) {
            throw new PluginListParseException(iOException);
        }
    }
}

