/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryAdjustAction
extends MapMode
implements MouseListener,
MouseMotionListener,
AWTEventListener {
    static ImageryOffsetDialog offsetDialog;
    static Cursor cursor;
    double oldDx;
    double oldDy;
    boolean mouseDown;
    EastNorth prevEastNorth;
    private ImageryLayer layer;
    private MapMode oldMapMode;

    public ImageryAdjustAction(ImageryLayer imageryLayer) {
        super(I18n.tr("New offset"), "adjustimg", I18n.tr("Adjust the position of this imagery layer"), Main.map, cursor);
        this.layer = imageryLayer;
    }

    public void enterMode() {
        super.enterMode();
        if (this.layer == null) {
            return;
        }
        if (!this.layer.isVisible()) {
            this.layer.setVisible(true);
        }
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        this.oldDx = this.layer.getDx();
        this.oldDy = this.layer.getDy();
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        offsetDialog = new ImageryOffsetDialog();
        offsetDialog.setVisible(true);
    }

    public void exitMode() {
        super.exitMode();
        if (offsetDialog != null) {
            this.layer.setOffset(this.oldDx, this.oldDy);
            offsetDialog.setVisible(false);
            offsetDialog = null;
        }
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return;
        }
        if (aWTEvent.getID() != 401) {
            return;
        }
        if (this.layer == null) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        double d = 0.0;
        double d2 = 0.0;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                d2 = 1.0;
                break;
            }
            case 40: {
                d2 = -1.0;
                break;
            }
            case 37: {
                d = -1.0;
                break;
            }
            case 39: {
                d = 1.0;
            }
        }
        if (d != 0.0 || d2 != 0.0) {
            double d3 = this.layer.getPPD();
            this.layer.displace(d / d3, d2 / d3);
            if (offsetDialog != null) {
                offsetDialog.updateOffset();
            }
            keyEvent.consume();
            Main.map.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (this.layer.isVisible()) {
            this.prevEastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
            Main.map.mapView.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.layer == null || this.prevEastNorth == null) {
            return;
        }
        EastNorth eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        double d = this.layer.getDx() + eastNorth.east() - this.prevEastNorth.east();
        double d2 = this.layer.getDy() + eastNorth.north() - this.prevEastNorth.north();
        this.layer.setOffset(d, d2);
        if (offsetDialog != null) {
            offsetDialog.updateOffset();
        }
        Main.map.repaint();
        this.prevEastNorth = eastNorth;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Main.map.mapView.repaint();
        Main.map.mapView.setCursor(Cursor.getDefaultCursor());
        this.prevEastNorth = null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (offsetDialog != null || this.layer == null || Main.map == null) {
            return;
        }
        this.oldMapMode = Main.map.mapMode;
        super.actionPerformed(actionEvent);
    }

    static {
        cursor = ImageProvider.getCursor("normal", "move");
    }

    class ImageryOffsetDialog
    extends ExtendedDialog
    implements PropertyChangeListener {
        public final JFormattedTextField easting;
        public final JFormattedTextField northing;
        JTextField tBookmarkName;
        private boolean ignoreListener;

        public ImageryOffsetDialog() {
            super(Main.parent, I18n.tr("Adjust imagery offset"), new String[]{I18n.tr("OK"), I18n.tr("Cancel")}, false);
            this.easting = new JFormattedTextField(new DecimalFormat("0.00000E0"));
            this.northing = new JFormattedTextField(new DecimalFormat("0.00000E0"));
            this.tBookmarkName = new JTextField();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.contentInsets = new Insets(10, 15, 5, 15);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.add((Component)new JMultilineLabel(I18n.tr("Use arrow keys or drag the imagery layer with mouse to adjust the imagery offset.\nYou can also enter east and north offset in the {0} coordinates.\nIf you want to save the offset as bookmark, enter the bookmark name below", ((Object)Main.proj).toString())), GBC.eop());
            jPanel.add((Component)new JLabel(I18n.tr("Easting") + ": "), GBC.std());
            jPanel.add((Component)this.easting, GBC.std().fill(2).insets(0, 0, 5, 0));
            jPanel.add((Component)new JLabel(I18n.tr("Northing") + ": "), GBC.std());
            jPanel.add((Component)this.northing, GBC.eol().fill(2));
            jPanel.add((Component)new JLabel(I18n.tr("Bookmark name: ")), GBC.eol().insets(0, 5, 0, 0));
            jPanel.add((Component)this.tBookmarkName, GBC.eol().fill(2));
            this.easting.setColumns(8);
            this.northing.setColumns(8);
            this.easting.setValue(ImageryAdjustAction.this.layer.getDx());
            this.northing.setValue(ImageryAdjustAction.this.layer.getDy());
            this.easting.addPropertyChangeListener("value", this);
            this.northing.addPropertyChangeListener("value", this);
            this.setContent(jPanel);
            this.setupDialog();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.ignoreListener) {
                return;
            }
            ImageryAdjustAction.this.layer.setOffset(((Number)this.easting.getValue()).doubleValue(), ((Number)this.northing.getValue()).doubleValue());
            Main.map.repaint();
        }

        public void updateOffset() {
            this.ignoreListener = true;
            this.easting.setValue(ImageryAdjustAction.this.layer.getDx());
            this.northing.setValue(ImageryAdjustAction.this.layer.getDy());
            this.ignoreListener = false;
        }

        private boolean confirmOverwriteBookmark() {
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Overwrite"), new String[]{I18n.tr("Overwrite"), I18n.tr("Cancel")}){
                {
                    this.contentInsets = new Insets(10, 15, 10, 15);
                }
            };
            extendedDialog.setContent(I18n.tr("Offset bookmark already exists. Overwrite?"));
            extendedDialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
            extendedDialog.setupDialog();
            extendedDialog.setVisible(true);
            return extendedDialog.getValue() == 1;
        }

        protected void buttonAction(int n, ActionEvent actionEvent) {
            if (n != 1 && this.tBookmarkName.getText() != null && !"".equals(this.tBookmarkName.getText()) && OffsetBookmark.getBookmarkByName(ImageryAdjustAction.this.layer, this.tBookmarkName.getText()) != null && !this.confirmOverwriteBookmark()) {
                return;
            }
            super.buttonAction(n, actionEvent);
            offsetDialog = null;
            if (n == 1) {
                ImageryAdjustAction.this.layer.setOffset(ImageryAdjustAction.this.oldDx, ImageryAdjustAction.this.oldDy);
            } else if (this.tBookmarkName.getText() != null && !"".equals(this.tBookmarkName.getText())) {
                OffsetBookmark.bookmarkOffset(this.tBookmarkName.getText(), ImageryAdjustAction.this.layer);
            }
            Main.main.menu.imageryMenu.refreshOffsetMenu();
            if (Main.map == null) {
                return;
            }
            if (ImageryAdjustAction.this.oldMapMode != null) {
                Main.map.selectMapMode(ImageryAdjustAction.this.oldMapMode);
                ImageryAdjustAction.this.oldMapMode = null;
            } else {
                Main.map.selectSelectTool(false);
            }
        }
    }
}

