/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RotateCommand;
import org.openstreetmap.josm.command.ScaleCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.SimplePaintVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectAction
extends MapMode
implements SelectionManager.SelectionEnded {
    private Mode mode = null;
    private SelectionManager selectionManager;
    private boolean cancelDrawMode = false;
    private boolean didMouseDrag = false;
    private final MapView mv;
    private Cursor oldCursor;
    private Point startingDraggingPos;
    private Point lastMousePos;
    private long mouseDownTime = 0L;
    private int initialMoveDelay;
    private int initialMoveThreshold;
    private boolean initialMoveThresholdExceeded = false;
    private Node virtualNode = null;
    private Collection<WaySegment> virtualWays = new LinkedList<WaySegment>();
    private Collection<OsmPrimitive> cycleList = Collections.emptyList();
    private boolean cyclePrims = false;
    private OsmPrimitive cycleStart = null;

    public SelectAction(MapFrame mapFrame) {
        super(I18n.tr("Select"), "move/move", I18n.tr("Select, move, scale and rotate objects"), Shortcut.registerShortcut("mapmode:select", I18n.tr("Mode: {0}", I18n.tr("Select")), 83, 3), mapFrame, SelectAction.getCursor("normal", "selection", 0));
        this.mv = mapFrame.mapView;
        this.putValue("help", "Action/Move/Move");
        this.selectionManager = new SelectionManager(this, false, this.mv);
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Main.pref.getInteger("edit.initial-move-threshold", 5);
    }

    private static Cursor getCursor(String string, String string2, int n) {
        try {
            return ImageProvider.getCursor(string, string2);
        }
        catch (Exception exception) {
            return Cursor.getPredefinedCursor(n);
        }
    }

    private void setCursor(Cursor cursor) {
        if (this.oldCursor == null) {
            this.oldCursor = this.mv.getCursor();
            this.mv.setCursor(cursor);
        }
    }

    private void restoreCursor() {
        if (this.oldCursor != null) {
            this.mv.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(this.mv);
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(false);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        this.cancelDrawMode = true;
        if (this.mode == Mode.select) {
            return;
        }
        if (this.mode == Mode.move && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.rotate && this.mode != Mode.scale && (mouseEvent.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.move) {
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
        if (this.startingDraggingPos == null) {
            this.startingDraggingPos = new Point(mouseEvent.getX(), mouseEvent.getY());
        }
        if (!this.initialMoveThresholdExceeded) {
            int n;
            int n2 = this.lastMousePos.x - mouseEvent.getX();
            int n3 = (int)Math.sqrt(n2 * n2 + (n = this.lastMousePos.y - mouseEvent.getY()) * n);
            if (n3 < this.initialMoveThreshold) {
                return;
            }
            this.initialMoveThresholdExceeded = true;
        }
        EastNorth eastNorth = this.mv.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        EastNorth eastNorth2 = this.mv.getEastNorth(this.lastMousePos.x, this.lastMousePos.y);
        double d = eastNorth.east() - eastNorth2.east();
        double d2 = eastNorth.north() - eastNorth2.north();
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        if (this.virtualWays.size() > 0) {
            LinkedList<Command> linkedList = new LinkedList<Command>();
            linkedList.add(new AddCommand(this.virtualNode));
            for (WaySegment waySegment : this.virtualWays) {
                Way way = waySegment.way;
                Way way2 = new Way(way);
                way2.addNode(waySegment.lowerIndex + 1, this.virtualNode);
                linkedList.add(new ChangeCommand(way, way2));
            }
            linkedList.add(new MoveCommand(this.virtualNode, d, d2));
            String string = I18n.trn("Add and move a virtual new node to way", "Add and move a virtual new node to {0} ways", this.virtualWays.size(), this.virtualWays.size());
            Main.main.undoRedo.add(new SequenceCommand(string, linkedList));
            this.getCurrentDataSet().setSelected(Collections.singleton(this.virtualNode));
            this.virtualWays.clear();
            this.virtualNode = null;
        } else {
            Command command;
            Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelectedNodesAndWays();
            Collection<Node> collection2 = AllNodesVisitor.getAllNodes(collection);
            if (collection2.size() < 2 && (this.mode == Mode.rotate || this.mode == Mode.scale)) {
                return;
            }
            Command command2 = command = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
            if (command instanceof SequenceCommand) {
                command = ((SequenceCommand)command).getLastCommand();
            }
            if (this.mode == Mode.move) {
                if (command instanceof MoveCommand && ((Object)collection2).equals(((MoveCommand)command).getParticipatingPrimitives())) {
                    ((MoveCommand)command).moveAgain(d, d2);
                } else {
                    command = new MoveCommand(collection, d, d2);
                    Main.main.undoRedo.add(command);
                }
                for (Node node : collection2) {
                    if (!node.getCoor().isOutSideWorld()) continue;
                    ((MoveCommand)command).moveAgain(-d, -d2);
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world."), I18n.tr("Warning"), 2);
                    this.restoreCursor();
                    return;
                }
            } else if (this.mode == Mode.rotate) {
                if (command instanceof RotateCommand && ((Object)collection2).equals(((RotateCommand)command).getTransformedNodes())) {
                    ((RotateCommand)command).handleEvent(eastNorth);
                } else {
                    Main.main.undoRedo.add(new RotateCommand(collection, eastNorth));
                }
            } else if (this.mode == Mode.scale) {
                if (command instanceof ScaleCommand && ((Object)collection2).equals(((ScaleCommand)command).getTransformedNodes())) {
                    ((ScaleCommand)command).handleEvent(eastNorth);
                } else {
                    Main.main.undoRedo.add(new ScaleCommand(collection, eastNorth));
                }
            }
        }
        this.mv.repaint();
        if (this.mode != Mode.scale) {
            this.lastMousePos = mouseEvent.getPoint();
        }
        this.didMouseDrag = true;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (Main.platform instanceof PlatformHookOsx && (this.mode == Mode.rotate || this.mode == Mode.scale)) {
            this.mouseDragged(mouseEvent);
        }
    }

    private boolean setupVirtual(MouseEvent mouseEvent) {
        if (Main.pref.getInteger("mappaint.node.virtual-size", 8) > 0) {
            int n = Main.pref.getInteger("mappaint.node.virtual-snap-distance", 8);
            int n2 = Main.pref.getInteger("mappaint.node.virtual-space", 70);
            n *= n;
            LinkedList<WaySegment> linkedList = new LinkedList<WaySegment>();
            Pair pair = null;
            Pair<Object, Object> pair2 = new Pair<Object, Object>(null, null);
            Point point = mouseEvent.getPoint();
            Way way = null;
            for (WaySegment waySegment : this.mv.getNearestWaySegments(point, OsmPrimitive.isSelectablePredicate)) {
                Point2D.Double double_;
                Point2D point2D;
                way = waySegment.way;
                pair2.a = way.getNode(waySegment.lowerIndex);
                Point2D point2D2 = this.mv.getPoint2D((Node)pair2.a);
                if (!SimplePaintVisitor.isLargeSegment(point2D2, point2D = this.mv.getPoint2D((Node)(pair2.b = way.getNode(waySegment.lowerIndex + 1))), n2) || !(point.distanceSq(double_ = new Point2D.Double((point2D2.getX() + point2D.getX()) / 2.0, (point2D2.getY() + point2D.getY()) / 2.0)) < (double)n)) continue;
                Pair.sort(pair2);
                if (pair == null) {
                    pair = new Pair(pair2.a, pair2.b);
                    this.virtualNode = new Node(this.mv.getLatLon(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                }
                if (!pair.equals(pair2)) continue;
                (way.isSelected() ? linkedList : this.virtualWays).add(waySegment);
            }
            if (!linkedList.isEmpty()) {
                this.virtualWays = linkedList;
            }
        }
        return !this.virtualWays.isEmpty();
    }

    private Collection<OsmPrimitive> cycleSetup(Collection<OsmPrimitive> collection, MouseEvent mouseEvent) {
        OsmPrimitive osmPrimitive = null;
        if (collection != null && !collection.isEmpty()) {
            boolean bl;
            osmPrimitive = collection.iterator().next();
            Point point = mouseEvent.getPoint();
            boolean bl2 = Main.pref.getBoolean("mappaint.select.waits-for-mouse-up", false);
            boolean bl3 = (mouseEvent.getModifiers() & 2) != 0;
            boolean bl4 = bl = (mouseEvent.getModifiers() & 0x28) != 0 || Main.pref.getBoolean("selectaction.cycles.multiple.matches", false);
            if (!bl) {
                this.cycleList = MapView.asColl(osmPrimitive);
                if (bl2) {
                    osmPrimitive = this.mv.getNearestNodeOrWay(point, OsmPrimitive.isSelectablePredicate, true);
                }
            } else {
                if (osmPrimitive instanceof Node) {
                    this.cycleList = new LinkedList<Node>(this.mv.getNearestNodes(point, OsmPrimitive.isSelectablePredicate));
                } else if (osmPrimitive instanceof Way) {
                    this.cycleList = new LinkedList<Way>(this.mv.getNearestWays(point, OsmPrimitive.isSelectablePredicate));
                }
                if (this.cycleList.size() > 1) {
                    this.cyclePrims = false;
                    OsmPrimitive osmPrimitive2 = osmPrimitive;
                    for (OsmPrimitive osmPrimitive3 : this.cycleList) {
                        if (!osmPrimitive3.isSelected()) continue;
                        this.cyclePrims = true;
                        osmPrimitive = osmPrimitive3;
                        break;
                    }
                    if (!(this.cycleList.size() != 2 || bl2 || osmPrimitive.equals(osmPrimitive2) || osmPrimitive.isNew() || bl3)) {
                        this.cyclePrims = false;
                        osmPrimitive = osmPrimitive2;
                    }
                }
            }
        }
        return MapView.asColl(osmPrimitive);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        SelectAction.debug("mousePressed: e.getPoint()=" + mouseEvent.getPoint());
        if (!this.mv.isActiveLayerVisible() || !((Boolean)this.getValue("active")).booleanValue() || mouseEvent.getButton() != 1) {
            return;
        }
        this.mv.requestFocus();
        boolean bl = (mouseEvent.getModifiers() & 2) != 0;
        boolean bl2 = (mouseEvent.getModifiers() & 1) != 0;
        boolean bl3 = (mouseEvent.getModifiers() & 8) != 0;
        this.cancelDrawMode = bl2 || bl;
        this.didMouseDrag = false;
        this.initialMoveThresholdExceeded = false;
        this.mouseDownTime = System.currentTimeMillis();
        this.lastMousePos = mouseEvent.getPoint();
        Collection<OsmPrimitive> collection = MapView.asColl(this.mv.getNearestNodeOrWay(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate, false));
        if (bl2 && bl) {
            this.mode = Mode.rotate;
            if (this.getCurrentDataSet().getSelected().isEmpty()) {
                this.getCurrentDataSet().setSelected(collection);
            }
            this.setCursor(ImageProvider.getCursor("rotate", null));
            this.mv.repaint();
        } else if (bl3 && bl) {
            this.mode = Mode.scale;
            if (this.getCurrentDataSet().getSelected().isEmpty()) {
                this.getCurrentDataSet().setSelected(collection);
            }
            this.setCursor(ImageProvider.getCursor("scale", null));
            this.mv.repaint();
        } else if (!collection.isEmpty()) {
            this.mode = Mode.move;
            if (!this.cancelDrawMode && collection.iterator().next() instanceof Way) {
                this.setupVirtual(mouseEvent);
            }
            this.selectPrims(this.cycleSetup(collection, mouseEvent), mouseEvent, false, false);
        } else {
            this.mode = Mode.select;
            this.oldCursor = this.mv.getCursor();
            this.selectionManager.register(this.mv);
            this.selectionManager.mousePressed(mouseEvent);
        }
        this.updateStatusLine();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        SelectAction.debug("mouseReleased: e.getPoint()=" + mouseEvent.getPoint());
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        this.startingDraggingPos = null;
        this.restoreCursor();
        if (this.mode == Mode.select) {
            this.selectionManager.unregister(this.mv);
            if (this.getCurrentDataSet().getSelected().size() == 0 && !this.cancelDrawMode) {
                Main.map.selectDrawTool(true);
                return;
            }
        }
        if (this.mode == Mode.move) {
            if (!this.didMouseDrag) {
                this.virtualWays.clear();
                this.virtualNode = null;
                if (this.lastMousePos.distanceSq(mouseEvent.getPoint()) < 100.0) {
                    this.selectPrims(this.cyclePrims(this.cycleList, mouseEvent), mouseEvent, true, false);
                    Collection<OsmPrimitive> collection = this.getCurrentDataSet().getSelected();
                    if (mouseEvent.getClickCount() >= 2 && collection.size() == 1 && collection.iterator().next() instanceof Node) {
                        Main.worker.execute(new Runnable(){

                            public void run() {
                                Main.map.selectDrawTool(true);
                            }
                        });
                        return;
                    }
                }
            } else {
                int n;
                int n2 = n = Main.pref.getInteger("warn.move.maxelements", 20);
                for (OsmPrimitive osmPrimitive : this.getCurrentDataSet().getSelected()) {
                    if (osmPrimitive instanceof Way) {
                        n2 -= ((Way)osmPrimitive).getNodes().size();
                    }
                    if (--n2 >= 0) continue;
                    break;
                }
                if (n2 < 0) {
                    ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Move elements"), new String[]{I18n.tr("Move them"), I18n.tr("Undo move")});
                    extendedDialog.setButtonIcons(new String[]{"reorder.png", "cancel.png"});
                    extendedDialog.setContent(I18n.tr("You moved more than {0} elements. Moving a large number of elements is often an error.\nReally move them?", n));
                    extendedDialog.setCancelButton(2);
                    extendedDialog.toggleEnable("movedManyElements");
                    extendedDialog.showDialog();
                    if (extendedDialog.getValue() != 1) {
                        Main.main.undoRedo.undo();
                    }
                } else {
                    this.mergePrims(this.getCurrentDataSet().getSelectedNodes(), mouseEvent);
                }
                this.getCurrentDataSet().fireSelectionChanged();
            }
        }
        this.mode = null;
        this.updateStatusLine();
    }

    @Override
    public void selectionEnded(Rectangle rectangle, MouseEvent mouseEvent) {
        boolean bl = (mouseEvent.getModifiersEx() & 0x2200) != 0;
        this.selectPrims(this.selectionManager.getObjectsInRectangle(rectangle, bl), mouseEvent, true, true);
    }

    private Collection<OsmPrimitive> cyclePrims(Collection<OsmPrimitive> collection, MouseEvent mouseEvent) {
        OsmPrimitive osmPrimitive = null;
        SelectAction.debug("cyclePrims(): entry.....");
        for (OsmPrimitive osmPrimitive2 : collection) {
            SelectAction.debug("cyclePrims(): prims id=" + osmPrimitive2.getId());
        }
        if (collection.size() > 1) {
            boolean bl = (mouseEvent.getModifiers() & 2) != 0;
            boolean bl2 = (mouseEvent.getModifiers() & 1) != 0;
            DataSet dataSet = this.getCurrentDataSet();
            OsmPrimitive osmPrimitive3 = collection.iterator().next();
            OsmPrimitive osmPrimitive4 = null;
            osmPrimitive = osmPrimitive3;
            Iterator<OsmPrimitive> iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.cyclePrims && bl2) {
                    osmPrimitive = iterator.next();
                    if (osmPrimitive.isSelected()) continue;
                    SelectAction.debug("cyclePrims(): taking " + osmPrimitive.getId());
                    break;
                }
                osmPrimitive = iterator.next();
                if (!osmPrimitive.isSelected()) continue;
                osmPrimitive4 = osmPrimitive;
                if (this.cyclePrims || bl) {
                    dataSet.clearSelection(osmPrimitive4);
                    osmPrimitive = iterator.hasNext() ? iterator.next() : osmPrimitive3;
                }
                SelectAction.debug("selectPrims(): taking " + osmPrimitive.getId());
                break;
            }
            if (bl) {
                if (osmPrimitive4 != null) {
                    if (!collection.contains(this.cycleStart)) {
                        dataSet.clearSelection(collection);
                        this.cycleStart = osmPrimitive4;
                        SelectAction.debug("selectPrims(): cycleStart set to foundInDS=" + this.cycleStart.getId());
                    } else if (this.cycleStart.equals(osmPrimitive)) {
                        dataSet.addSelected(osmPrimitive);
                        SelectAction.debug("selectPrims(): cycleStart hit");
                    }
                } else {
                    this.cycleStart = osmPrimitive = collection.contains(this.cycleStart) ? this.cycleStart : osmPrimitive3;
                    SelectAction.debug("selectPrims(): cycleStart set to nxt=" + this.cycleStart.getId());
                }
            } else {
                this.cycleStart = null;
            }
            SelectAction.debug("cyclePrims(): truncated prims list to id=" + osmPrimitive.getId());
        }
        return osmPrimitive != null ? MapView.asColl(osmPrimitive) : collection;
    }

    private void mergePrims(Collection<Node> collection, MouseEvent mouseEvent) {
        List<Node> list;
        boolean bl;
        boolean bl2 = bl = (mouseEvent.getModifiers() & 2) != 0;
        if (bl && !collection.isEmpty() && !(list = this.mv.getNearestNodes(mouseEvent.getPoint(), collection, OsmPrimitive.isSelectablePredicate)).isEmpty()) {
            LinkedList<Node> linkedList = new LinkedList<Node>(collection);
            linkedList.add((Node)list.iterator().next());
            Command command = MergeNodesAction.mergeNodes(Main.main.getEditLayer(), linkedList, (Node)list.iterator().next());
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        }
    }

    private void selectPrims(Collection<OsmPrimitive> collection, MouseEvent mouseEvent, boolean bl, boolean bl2) {
        boolean bl3 = (mouseEvent.getModifiers() & 2) != 0;
        boolean bl4 = (mouseEvent.getModifiers() & 1) != 0;
        DataSet dataSet = this.getCurrentDataSet();
        if (bl4 && bl3 || bl3 && !bl || !this.virtualWays.isEmpty()) {
            return;
        }
        if (!bl) {
            bl4 |= this.getCurrentDataSet().getSelected().containsAll(collection);
        }
        if (bl3) {
            if (bl2) {
                dataSet.clearSelection(collection);
            } else {
                dataSet.toggleSelected(collection);
            }
        } else if (bl4) {
            dataSet.addSelected(collection);
        } else {
            dataSet.setSelected(collection);
        }
    }

    @Override
    public String getModeHelpText() {
        if (this.mode == Mode.select) {
            return I18n.tr("Release the mouse button to select the objects in the rectangle.");
        }
        if (this.mode == Mode.move) {
            return I18n.tr("Release the mouse button to stop moving. Ctrl to merge with nearest node.");
        }
        if (this.mode == Mode.rotate) {
            return I18n.tr("Release the mouse button to stop rotating.");
        }
        if (this.mode == Mode.scale) {
            return I18n.tr("Release the mouse button to stop scaling.");
        }
        return I18n.tr("Move objects by dragging; Shift to add to selection (Ctrl to toggle); Shift-Ctrl to rotate selected; Alt-Ctrl to scale selected; or change selection");
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    private static void debug(String string) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        move,
        rotate,
        scale,
        select;

    }
}

