/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffsetBookmark {
    public static List<OffsetBookmark> allBookmarks = new ArrayList<OffsetBookmark>();
    public Projection proj;
    public String layerName;
    public String name;
    public double dx;
    public double dy;

    public boolean isUsable(ImageryLayer imageryLayer) {
        return Main.proj.getClass() == this.proj.getClass() && imageryLayer.getInfo().getName().equals(this.layerName);
    }

    public OffsetBookmark(Projection projection, String string, String string2, double d, double d2) {
        this.proj = projection;
        this.layerName = string;
        this.name = string2;
        this.dx = d;
        this.dy = d2;
    }

    public OffsetBookmark(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        String string = arrayList.get(0);
        for (Projection projection : Projection.allProjections) {
            if (!projection.getCacheDirectoryName().equals(string)) continue;
            this.proj = projection;
            break;
        }
        if (this.proj == null) {
            throw new IllegalStateException(I18n.tr("Projection ''{0}'' not found", string));
        }
        this.layerName = arrayList.get(1);
        this.name = arrayList.get(2);
        this.dx = Double.valueOf(arrayList.get(3));
        this.dy = Double.valueOf(arrayList.get(4));
    }

    public ArrayList<String> getInfoArray() {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        arrayList.add(this.proj.getCacheDirectoryName());
        arrayList.add(this.layerName);
        arrayList.add(this.name);
        arrayList.add(String.valueOf(this.dx));
        arrayList.add(String.valueOf(this.dy));
        return arrayList;
    }

    public static void loadBookmarks() {
        for (Collection<String> collection : Main.pref.getArray("imagery.offsets", Collections.<Collection<String>>emptySet())) {
            allBookmarks.add(new OffsetBookmark(collection));
        }
    }

    public static void saveBookmarks() {
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            linkedList.add(offsetBookmark.getInfoArray());
        }
        Main.pref.putArray("imagery.offsets", linkedList);
    }

    public static OffsetBookmark getBookmarkByName(ImageryLayer imageryLayer, String string) {
        for (OffsetBookmark offsetBookmark : allBookmarks) {
            if (!offsetBookmark.isUsable(imageryLayer) || !string.equals(offsetBookmark.name)) continue;
            return offsetBookmark;
        }
        return null;
    }

    public static void bookmarkOffset(String string, ImageryLayer imageryLayer) {
        OffsetBookmark offsetBookmark = new OffsetBookmark(Main.proj, imageryLayer.getInfo().getName(), string, imageryLayer.getDx(), imageryLayer.getDy());
        ListIterator<OffsetBookmark> listIterator = allBookmarks.listIterator();
        while (listIterator.hasNext()) {
            OffsetBookmark offsetBookmark2 = listIterator.next();
            if (!offsetBookmark2.isUsable(imageryLayer) || !string.equals(offsetBookmark2.name)) continue;
            listIterator.set(offsetBookmark);
            OffsetBookmark.saveBookmarks();
            return;
        }
        allBookmarks.add(offsetBookmark);
        OffsetBookmark.saveBookmarks();
    }
}

