/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.TransverseMercator;
import org.openstreetmap.josm.tools.I18n;

public class Epsg3008
extends TransverseMercator {
    private static final double UTMScaleFactor = 1.0;
    private double UTMCentralMeridianRad = Math.toRadians(13.5);
    private double offsetEastMeters = 150000.0;
    private double offsetNorthMeters = 0.0;

    public String toString() {
        return I18n.tr("SWEREF99 13 30 / EPSG:3008 (Sweden)");
    }

    private int epsgCode() {
        return 3008;
    }

    public String toCode() {
        return "EPSG:" + this.epsgCode();
    }

    public int hashCode() {
        return this.toCode().hashCode();
    }

    public String getCacheDirectoryName() {
        return "epsg" + this.epsgCode();
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(55.2, 12.1), new LatLon(62.26, 14.65));
    }

    public EastNorth latlon2eastNorth(LatLon latLon) {
        EastNorth eastNorth = this.mapLatLonToXY(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon()), this.UTMCentralMeridianRad);
        return new EastNorth(eastNorth.east() * 1.0 + this.offsetEastMeters, eastNorth.north() * 1.0 + this.offsetNorthMeters);
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        return this.mapXYToLatLon((eastNorth.east() - this.offsetEastMeters) / 1.0, (eastNorth.north() - this.offsetNorthMeters) / 1.0, this.UTMCentralMeridianRad);
    }
}

