/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class TurnrestrictionTest
extends Test {
    protected static final int NO_VIA = 1801;
    protected static final int NO_FROM = 1802;
    protected static final int NO_TO = 1803;
    protected static final int MORE_VIA = 1804;
    protected static final int MORE_FROM = 1805;
    protected static final int MORE_TO = 1806;
    protected static final int UNKNOWN_ROLE = 1807;
    protected static final int UNKNOWN_TYPE = 1808;
    protected static final int FROM_VIA_NODE = 1809;
    protected static final int TO_VIA_NODE = 1810;
    protected static final int FROM_VIA_WAY = 1811;
    protected static final int TO_VIA_WAY = 1812;

    public TurnrestrictionTest() {
        super(I18n.tr("Turnrestriction"), I18n.tr("This test checks if turnrestrictions are valid"));
    }

    public void visit(Relation relation) {
        Object object;
        Object object2;
        Object object3;
        if (!"restriction".equals(relation.get("type"))) {
            return;
        }
        OsmPrimitive osmPrimitive = null;
        OsmPrimitive osmPrimitive2 = null;
        Object object4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (RelationMember primitiveId : relation.getMembers()) {
            if (primitiveId.getMember().isIncomplete()) {
                return;
            }
            object3 = new ArrayList<OsmPrimitive>();
            ((ArrayList)object3).add(relation);
            ((ArrayList)object3).add(primitiveId.getMember());
            if (primitiveId.isWay()) {
                object2 = primitiveId.getWay();
                if (((Way)object2).getNodesCount() < 2) continue;
                if ("from".equals(primitiveId.getRole())) {
                    if (osmPrimitive != null) {
                        bl = true;
                        continue;
                    }
                    osmPrimitive = object2;
                    continue;
                }
                if ("to".equals(primitiveId.getRole())) {
                    if (osmPrimitive2 != null) {
                        bl2 = true;
                        continue;
                    }
                    osmPrimitive2 = object2;
                    continue;
                }
                if ("via".equals(primitiveId.getRole())) {
                    if (object4 != null) {
                        bl3 = true;
                        continue;
                    }
                    object4 = object2;
                    continue;
                }
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown role"), 1807, (Collection<? extends OsmPrimitive>)object3, Collections.singletonList(primitiveId)));
                continue;
            }
            if (primitiveId.isNode()) {
                object2 = primitiveId.getNode();
                if ("via".equals(primitiveId.getRole())) {
                    if (object4 != null) {
                        bl3 = true;
                        continue;
                    }
                    object4 = object2;
                    continue;
                }
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown role"), 1807, (Collection<? extends OsmPrimitive>)object3, Collections.singletonList(primitiveId)));
                continue;
            }
            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Unknown member type"), 1808, (Collection<? extends OsmPrimitive>)object3, Collections.singletonList(primitiveId)));
        }
        if (bl) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"from\" way found"), 1805, relation));
        }
        if (bl2) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"to\" way found"), 1806, relation));
        }
        if (bl3) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("More than one \"via\" way found"), 1804, relation));
        }
        if (osmPrimitive == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"from\" way found"), 1802, relation));
            return;
        }
        if (osmPrimitive2 == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"to\" way found"), 1803, relation));
            return;
        }
        if (object4 == null) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("No \"via\" node or way found"), 1801, relation));
            return;
        }
        if (object4 instanceof Node) {
            object = (Node)object4;
            if (!((Way)osmPrimitive).isFirstLastNode((Node)object)) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("The \"from\" way does not start or end at a \"via\" node"), 1809, relation));
                return;
            }
            if (!osmPrimitive2.isFirstLastNode((Node)object)) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("The \"to\" way does not start or end at a \"via\" node"), 1810, relation));
                return;
            }
        } else {
            Way way = (Way)object4;
            object3 = way.firstNode();
            object2 = way.lastNode();
            Boolean bl4 = false;
            String string = way.get("oneway");
            if (string != null) {
                if ("-1".equals(string)) {
                    bl4 = true;
                    Object object5 = object3;
                    object3 = object2;
                    object2 = object5;
                } else {
                    bl4 = OsmUtils.getOsmBoolean(string);
                    if (bl4 == null) {
                        bl4 = false;
                    }
                }
            }
            if (((Way)osmPrimitive).isFirstLastNode((Node)object3)) {
                object = object3;
            } else if (!bl4.booleanValue() && ((Way)osmPrimitive).isFirstLastNode((Node)object2)) {
                object = object2;
            } else {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("The \"from\" way does not start or end at a \"via\" way."), 1811, relation));
                return;
            }
            if (!osmPrimitive2.isFirstLastNode((Node)(object == object3 ? object2 : object3))) {
                this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("The \"to\" way does not start or end at a \"via\" way."), 1812, relation));
            }
        }
    }
}

