/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.Authenticator;
import java.net.ProxySelector;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.AutosaveTask;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.SplashScreen;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.DefaultProxySelector;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainApplication
extends Main {
    public MainApplication() {
    }

    public MainApplication(JFrame jFrame) {
        jFrame.setContentPane(contentPanePrivate);
        jFrame.setJMenuBar(this.menu);
        jFrame.setBounds(bounds);
        jFrame.setIconImage(ImageProvider.get("logo.png").getImage());
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Main.exitJosm(true);
            }
        });
        jFrame.setDefaultCloseOperation(0);
    }

    public static void showHelp() {
        System.out.println(I18n.tr("Java OpenStreetMap Editor") + "\n\n" + I18n.tr("usage") + ":\n" + "\tjava -jar josm.jar <options>...\n\n" + I18n.tr("options") + ":\n" + "\t--help|-?|-h                              " + I18n.tr("Show this help") + "\n" + "\t--geometry=widthxheight(+|-)x(+|-)y       " + I18n.tr("Standard unix geometry argument") + "\n" + "\t[--download=]minlat,minlon,maxlat,maxlon  " + I18n.tr("Download the bounding box") + "\n" + "\t[--download=]<url>                        " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z)") + "\n" + "\t[--download=]<filename>                   " + I18n.tr("Open a file (any file type that can be opened with File/Open)") + "\n" + "\t--downloadgps=minlat,minlon,maxlat,maxlon " + I18n.tr("Download the bounding box as raw gps") + "\n" + "\t--downloadgps=<url>                       " + I18n.tr("Download the location at the url (with lat=x&lon=y&zoom=z) as raw gps") + "\n" + "\t--selection=<searchstring>                " + I18n.tr("Select with the given search") + "\n" + "\t--[no-]maximize                           " + I18n.tr("Launch in maximized mode") + "\n" + "\t--reset-preferences                       " + I18n.tr("Reset the preferences to default") + "\n\n" + "\t--language=<language>                     " + I18n.tr("Set the language") + "\n\n" + I18n.tr("options provided as Java system properties") + ":\n" + "\t-Djosm.home=" + I18n.tr("/PATH/TO/JOSM/FOLDER/         ") + I18n.tr("Change the folder for all user settings") + "\n\n" + I18n.tr("note: For some tasks, JOSM needs a lot of memory. It can be necessary to add the following\n      Java option to specify the maximum size of allocated memory in megabytes") + ":\n" + "\t-Xmx...m\n\n" + I18n.tr("examples") + ":\n" + "\tjava -jar josm.jar track1.gpx track2.gpx london.osm\n" + "\tjava -jar josm.jar http://www.openstreetmap.org/index.html?lat=43.2&lon=11.1&zoom=13\n" + "\tjava -jar josm.jar london.osm --selection=http://www.ostertag.name/osm/OSM_errors_node-duplicate.xml\n" + "\tjava -jar josm.jar 43.2,11.1,43.4,11.4\n" + "\tjava -Djosm.home=/home/user/.josm_dev -jar josm.jar\n" + "\tjava -Xmx400m -jar josm.jar\n\n" + I18n.tr("Parameters --download, --downloadgps, and --selection are processed in this order.") + "\n" + I18n.tr("Make sure you load some data if you use --selection.") + "\n");
    }

    private static Map<String, Collection<String>> buildCommandLineArgumentMap(String[] stringArray) {
        HashMap<String, Collection<String>> hashMap = new HashMap<String, Collection<String>>();
        for (String string : stringArray) {
            int n;
            if ("-h".equals(string) || "-?".equals(string)) {
                string = "--help";
            }
            if (!string.startsWith("--")) {
                string = "--download=" + string;
            }
            String string2 = (n = string.indexOf(61)) == -1 ? string.substring(2) : string.substring(2, n);
            String string3 = n == -1 ? "" : string.substring(n + 1);
            LinkedList<String> linkedList = (LinkedList<String>)hashMap.get(string2);
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
            }
            linkedList.add(string3);
            hashMap.put(string2, linkedList);
        }
        return hashMap;
    }

    public static void main(String[] stringArray) {
        I18n.init();
        MainApplication.checkJava6();
        Main.pref = new Preferences();
        Policy.setPolicy(new Policy(){
            private PermissionCollection pc = new Permissions();
            {
                this.pc.add(new AllPermission());
            }

            public void refresh() {
            }

            public PermissionCollection getPermissions(CodeSource codeSource) {
                return this.pc;
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(new BugReportExceptionHandler());
        System.setProperty("sun.awt.exception.handler", BugReportExceptionHandler.class.getName());
        Main.determinePlatformHook();
        Main.platform.preStartupHook();
        final Map<String, Collection<String>> map = MainApplication.buildCommandLineArgumentMap(stringArray);
        Main.pref.init(map.containsKey("reset-preferences"));
        if (map.containsKey("language")) {
            I18n.set((String)map.get("language").toArray()[0]);
        } else {
            I18n.set(Main.pref.get("language", null));
        }
        Main.pref.updateSystemProperties();
        DefaultAuthenticator.createInstance(CredentialsManagerFactory.getCredentialManager());
        Authenticator.setDefault(DefaultAuthenticator.getInstance());
        ProxySelector.setDefault(new DefaultProxySelector(ProxySelector.getDefault()));
        OAuthAccessTokenHolder.getInstance().init(Main.pref, CredentialsManagerFactory.getCredentialManager());
        if (map.containsKey("help")) {
            MainApplication.showHelp();
            System.exit(0);
        }
        SplashScreen splashScreen = new SplashScreen();
        ProgressMonitor progressMonitor = splashScreen.getProgressMonitor();
        progressMonitor.beginTask(I18n.tr("Initializing"));
        progressMonitor.setTicksCount(7);
        splashScreen.setVisible(Main.pref.getBoolean("draw.splashscreen", true));
        List<PluginInformation> list = PluginHandler.buildListOfPluginsToLoad(splashScreen, progressMonitor.createSubTaskMonitor(1, false));
        if (!list.isEmpty() && PluginHandler.checkAndConfirmPluginUpdate(splashScreen)) {
            progressMonitor.subTask(I18n.tr("Updating plugins..."));
            list = PluginHandler.updatePlugins(splashScreen, list, progressMonitor.createSubTaskMonitor(1, false));
        }
        progressMonitor.worked(1);
        progressMonitor.subTask(I18n.tr("Installing updated plugins"));
        PluginHandler.installDownloadedPlugins(true);
        progressMonitor.worked(1);
        progressMonitor.subTask(I18n.tr("Loading early plugins"));
        PluginHandler.loadEarlyPlugins(splashScreen, list, progressMonitor.createSubTaskMonitor(1, false));
        progressMonitor.worked(1);
        progressMonitor.subTask(I18n.tr("Setting defaults"));
        MainApplication.preConstructorInit(map);
        MainApplication.removeObsoletePreferences();
        progressMonitor.worked(1);
        if (RemoteControl.PROP_REMOTECONTROL_ENABLED.get()) {
            RemoteControl.start();
        }
        progressMonitor.indeterminateSubTask(I18n.tr("Creating main GUI"));
        JFrame jFrame = new JFrame(I18n.tr("Java OpenStreetMap Editor"));
        Main.parent = jFrame;
        Main.addListener();
        final MainApplication mainApplication = new MainApplication(jFrame);
        progressMonitor.worked(1);
        progressMonitor.subTask(I18n.tr("Loading plugins"));
        PluginHandler.loadLatePlugins(splashScreen, list, progressMonitor.createSubTaskMonitor(1, false));
        progressMonitor.worked(1);
        toolbar.refreshToolbarControl();
        splashScreen.setVisible(false);
        splashScreen.dispose();
        jFrame.setVisible(true);
        boolean bl = Boolean.parseBoolean(Main.pref.get("gui.maximized"));
        if (!map.containsKey("no-maximize") && bl || map.containsKey("maximize")) {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
                Main.windowState = 6;
                jFrame.setExtendedState(Main.windowState);
            } else {
                Main.debug("Main window: maximizing not supported");
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (AutosaveTask.PROP_AUTOSAVE_ENABLED.get()) {
                    AutosaveTask autosaveTask = new AutosaveTask();
                    List<File> list = autosaveTask.getUnsavedLayersFiles();
                    if (!list.isEmpty()) {
                        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Unsaved osm data"), new String[]{I18n.tr("Restore"), I18n.tr("Cancel"), I18n.tr("Discard")});
                        extendedDialog.setContent(I18n.trn("JOSM found {0} unsaved osm data layer. ", "JOSM found {0} unsaved osm data layers. ", list.size(), list.size()) + I18n.tr("It looks like JOSM crashed last time. Do you like to restore the data?"));
                        extendedDialog.setButtonIcons(new String[]{"ok", "cancel", "dialogs/remove"});
                        int n = extendedDialog.showDialog().getValue();
                        if (n == 1) {
                            autosaveTask.recoverUnsavedLayers();
                        } else if (n == 3) {
                            autosaveTask.dicardUnsavedLayers();
                        }
                    }
                    autosaveTask.schedule();
                }
                mainApplication.postConstructorProcessCmdLine(map);
            }
        });
    }

    public static void removeObsoletePreferences() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"proxy.anonymous", "proxy.enable"}) {
            if (!Main.pref.hasKey(string)) continue;
            Main.pref.removeFromCollection(string, Main.pref.get(string));
            System.out.println(I18n.tr("Preference setting {0} has been removed since it is no longer used.", string));
        }
    }

    private static void checkJava6() {
        String string = System.getProperty("java.version");
        if (string != null) {
            if (string.startsWith("1.6") || string.startsWith("6") || string.startsWith("1.7") || string.startsWith("7")) {
                return;
            }
            if (string.startsWith("1.5") || string.startsWith("5")) {
                JLabel jLabel = new JLabel("<html>" + I18n.tr("<h2>JOSM requires Java version 6.</h2>Detected Java version: {0}.<br>You can <ul><li>update your Java (JRE) or</li><li>use an earlier (Java 5 compatible) version of JOSM.</li></ul>More Info:", string) + "</html>");
                JTextArea jTextArea = new JTextArea("http://josm.openstreetmap.de/wiki/Help/SystemRequirements");
                jTextArea.setEditable(false);
                jTextArea.setBackground(panel.getBackground());
                JPanel jPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                jPanel.add((Component)jLabel, gridBagConstraints);
                jPanel.add((Component)jTextArea, gridBagConstraints);
                String string2 = I18n.tr("Exit JOSM");
                String string3 = I18n.tr("Continue, try anyway");
                int n = JOptionPane.showOptionDialog(null, jPanel, I18n.tr("Error"), 0, 0, null, new String[]{string2, string3}, string2);
                if (n == 0) {
                    System.exit(0);
                }
                return;
            }
        }
        System.err.println("Error: Could not recognize Java Version: " + string);
    }
}

