/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PleaseWaitDialog
extends JDialog {
    private final JProgressBar progressBar = new JProgressBar();
    public final JLabel currentAction = new JLabel("");
    private final JLabel customText = new JLabel("");
    public final BoundedRangeModel progress = this.progressBar.getModel();
    private JButton btnCancel;
    private JTextArea taLog = new JTextArea(5, 50);
    private JScrollPane spLog;

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.currentAction, GBC.eol().fill(2));
        jPanel.add((Component)this.customText, GBC.eol().fill(2));
        jPanel.add((Component)this.progressBar, GBC.eop().fill(2));
        this.btnCancel = new JButton(I18n.tr("Cancel"));
        this.btnCancel.setIcon(ImageProvider.get("cancel"));
        this.btnCancel.setToolTipText(I18n.tr("Click to cancel the current operation"));
        jPanel.add((Component)this.btnCancel, GBC.eol().anchor(10));
        GBC gBC = GBC.eol().fill(1);
        gBC.weighty = 1.0;
        gBC.weightx = 1.0;
        this.spLog = new JScrollPane(this.taLog);
        jPanel.add((Component)this.spLog, gBC);
        this.spLog.setVisible(false);
        this.setContentPane(jPanel);
        this.setCustomText("");
        this.setLocationRelativeTo(this.getParent());
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                int n = PleaseWaitDialog.this.getWidth();
                if (n > 200) {
                    Main.pref.putInteger("progressdialog.size", n);
                }
            }
        });
    }

    public PleaseWaitDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.initDialog();
    }

    public void setIndeterminate(boolean bl) {
        UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
        this.progressBar.setIndeterminate(bl);
    }

    protected void adjustLayout() {
        this.invalidate();
        this.pack();
        this.setSize(Main.pref.getInteger("progressdialog.size", 600), this.getSize().height);
    }

    public void setCustomText(String string) {
        if (string == null || string.trim().length() == 0) {
            this.customText.setVisible(false);
            this.adjustLayout();
            return;
        }
        this.customText.setText(string);
        if (!this.customText.isVisible()) {
            this.customText.setVisible(true);
            this.adjustLayout();
        }
    }

    public void appendLogMessage(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        if (!this.spLog.isVisible()) {
            this.spLog.setVisible(true);
            this.taLog.setVisible(true);
            this.adjustLayout();
        }
        this.taLog.append(string);
        this.taLog.append("\n");
        this.spLog.getVerticalScrollBar().setValue(this.spLog.getVerticalScrollBar().getMaximum());
    }

    public void setCancelEnabled(boolean bl) {
        this.btnCancel.setEnabled(bl);
    }

    public void setCancelCallback(ActionListener actionListener) {
        if (actionListener == null) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener2 : actionListenerArray = this.btnCancel.getActionListeners()) {
                this.btnCancel.removeActionListener(actionListener2);
            }
        } else {
            this.btnCancel.addActionListener(actionListener);
        }
    }
}

