/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import org.openstreetmap.josm.tools.I18n;

public class QuadStateCheckBox
extends JCheckBox {
    private final QuadStateDecorator model;
    private State[] allowed;

    public QuadStateCheckBox(String string, Icon icon, State state, State[] stateArray) {
        super(string, icon);
        this.allowed = stateArray;
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                QuadStateCheckBox.this.grabFocus();
                QuadStateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("pressed", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                QuadStateCheckBox.this.grabFocus();
                QuadStateCheckBox.this.model.nextState();
            }
        });
        actionMapUIResource.put("released", null);
        SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
        this.model = new QuadStateDecorator(this.getModel());
        this.setModel(this.model);
        this.setState(state);
    }

    public QuadStateCheckBox(String string, State state, State[] stateArray) {
        this(string, null, state, stateArray);
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public void setState(State state) {
        this.model.setState(state);
    }

    public State getState() {
        return this.model.getState();
    }

    public void setSelected(boolean bl) {
        if (bl) {
            this.setState(State.SELECTED);
        } else {
            this.setState(State.NOT_SELECTED);
        }
    }

    private class QuadStateDecorator
    implements ButtonModel {
        private final ButtonModel other;

        private QuadStateDecorator(ButtonModel buttonModel) {
            this.other = buttonModel;
        }

        private void setState(State state) {
            if (state == State.NOT_SELECTED) {
                this.other.setArmed(false);
                this.other.setPressed(false);
                this.other.setSelected(false);
                QuadStateCheckBox.this.setToolTipText(I18n.tr("false: the property is explicitly switched off"));
            } else if (state == State.SELECTED) {
                this.other.setArmed(false);
                this.other.setPressed(false);
                this.other.setSelected(true);
                QuadStateCheckBox.this.setToolTipText(I18n.tr("true: the property is explicitly switched on"));
            } else if (state == State.PARTIAL) {
                this.other.setArmed(true);
                this.other.setPressed(true);
                this.other.setSelected(true);
                QuadStateCheckBox.this.setToolTipText(I18n.tr("partial: different selected objects have different values, do not change"));
            } else {
                this.other.setArmed(true);
                this.other.setPressed(true);
                this.other.setSelected(false);
                QuadStateCheckBox.this.setToolTipText(I18n.tr("unset: do not set this property on the selected objects"));
            }
        }

        private State getState() {
            if (this.isSelected() && !this.isArmed()) {
                return State.SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return State.PARTIAL;
            }
            if (!this.isSelected() && !this.isArmed()) {
                return State.NOT_SELECTED;
            }
            return State.UNSET;
        }

        private void nextState() {
            State state = this.getState();
            for (int i = 0; i < QuadStateCheckBox.this.allowed.length; ++i) {
                if (QuadStateCheckBox.this.allowed[i] != state) continue;
                this.setState(i == QuadStateCheckBox.this.allowed.length - 1 ? QuadStateCheckBox.this.allowed[0] : QuadStateCheckBox.this.allowed[i + 1]);
                break;
            }
        }

        public void setArmed(boolean bl) {
        }

        public void setSelected(boolean bl) {
        }

        public void setPressed(boolean bl) {
        }

        public void setEnabled(boolean bl) {
            QuadStateCheckBox.this.setFocusable(bl);
            this.other.setEnabled(bl);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setRollover(boolean bl) {
            this.other.setRollover(bl);
        }

        public void setMnemonic(int n) {
            this.other.setMnemonic(n);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String string) {
            this.other.setActionCommand(string);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup buttonGroup) {
            this.other.setGroup(buttonGroup);
        }

        public void addActionListener(ActionListener actionListener) {
            this.other.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.other.removeActionListener(actionListener);
        }

        public void addItemListener(ItemListener itemListener) {
            this.other.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.other.removeItemListener(itemListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.other.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.other.removeChangeListener(changeListener);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_SELECTED,
        SELECTED,
        UNSET,
        PARTIAL;

    }
}

