/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagTable;

public class ChangesetTagsPanel
extends JPanel
implements PropertyChangeListener {
    private TagTable tblTags;
    private TagEditorModel model;

    protected void build() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.model = new TagEditorModel();
        this.tblTags = new TagTable(this.model);
        this.tblTags.setEnabled(false);
        this.add((Component)new JScrollPane(this.tblTags), "Center");
    }

    public ChangesetTagsPanel() {
        this.build();
    }

    protected void init(Changeset changeset) {
        if (changeset == null) {
            this.model.clear();
            return;
        }
        this.model.initFromTags(changeset.getKeys());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        Changeset changeset = (Changeset)propertyChangeEvent.getNewValue();
        if (changeset == null) {
            this.model.clear();
        } else {
            this.model.initFromPrimitive(changeset);
        }
    }
}

