/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Dialog;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadRelationMemberTask
extends PleaseWaitRunnable {
    private boolean cancelled;
    private Exception lastException;
    private final Set<Relation> parents = new HashSet<Relation>();
    private Collection<OsmPrimitive> children;
    private OsmDataLayer curLayer;
    private MultiFetchServerObjectReader objectReader;

    public DownloadRelationMemberTask(Relation relation, Collection<OsmPrimitive> collection, OsmDataLayer osmDataLayer, Dialog dialog) {
        super(I18n.tr("Download relation members"), new PleaseWaitProgressMonitor(dialog), false);
        this.parents.add(relation);
        this.children = collection;
        this.curLayer = osmDataLayer;
    }

    public DownloadRelationMemberTask(Relation relation, Collection<OsmPrimitive> collection, OsmDataLayer osmDataLayer) {
        super(I18n.tr("Download relation members"), false);
        this.parents.add(relation);
        this.children = collection;
        this.curLayer = osmDataLayer;
    }

    public DownloadRelationMemberTask(Collection<Relation> collection, Collection<OsmPrimitive> collection2, OsmDataLayer osmDataLayer) {
        super(I18n.tr("Download relation members"), false);
        this.parents.addAll(collection);
        this.children = collection2;
        this.curLayer = osmDataLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.cancelled = true;
        DownloadRelationMemberTask downloadRelationMemberTask = this;
        synchronized (downloadRelationMemberTask) {
            if (this.objectReader != null) {
                this.objectReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        Main.map.repaint();
        if (this.cancelled) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
        }
    }

    protected String buildDownloadFeedbackMessage() {
        if (this.parents.size() == 1) {
            Relation relation = this.parents.iterator().next();
            return I18n.trn("Downloading {0} incomplete child of relation ''{1}''", "Downloading {0} incomplete children of relation ''{1}''", this.children.size(), this.children.size(), relation.getDisplayName(DefaultNameFormatter.getInstance()));
        }
        return I18n.trn("Downloading {0} incomplete child of {1} parent relations", "Downloading {0} incomplete children of  {1} parent relations", this.children.size(), this.children.size(), this.parents.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            Object object = this;
            synchronized (object) {
                if (this.cancelled) {
                    return;
                }
                this.objectReader = new MultiFetchServerObjectReader();
            }
            this.objectReader.append(this.children);
            this.progressMonitor.indeterminateSubTask(this.buildDownloadFeedbackMessage());
            object = this.objectReader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            if (object == null) {
                return;
            }
            ((DataSet)object).deleteInvisible();
            DownloadRelationMemberTask downloadRelationMemberTask = this;
            synchronized (downloadRelationMemberTask) {
                if (this.cancelled) {
                    return;
                }
                this.objectReader = null;
            }
            SwingUtilities.invokeLater(new Runnable((DataSet)object){
                final /* synthetic */ DataSet val$dataSet;
                {
                    this.val$dataSet = dataSet;
                }

                public void run() {
                    DownloadRelationMemberTask.this.curLayer.mergeFrom(this.val$dataSet);
                    DownloadRelationMemberTask.this.curLayer.onPostDownloadFromServer();
                }
            });
        }
        catch (Exception exception) {
            if (this.cancelled) {
                System.out.println(I18n.tr("Warning: ignoring exception because task is cancelled. Exception: {0}", exception.toString()));
                return;
            }
            this.lastException = exception;
        }
    }
}

