/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableCellRenderer;
import org.openstreetmap.josm.gui.dialogs.relation.WayConnectionType;
import org.openstreetmap.josm.tools.ImageProvider;

public class MemberTableLinkedCellRenderer
extends MemberTableCellRenderer {
    static final Image arrowUp = ImageProvider.get("dialogs/relation", "arrowup").getImage();
    static final Image arrowDown = ImageProvider.get("dialogs/relation", "arrowdown").getImage();
    static final Image corners = ImageProvider.get("dialogs/relation", "roundedcorners").getImage();
    static final Image roundabout_right = ImageProvider.get("dialogs/relation", "roundabout_right_tiny").getImage();
    static final Image roundabout_left = ImageProvider.get("dialogs/relation", "roundabout_left_tiny").getImage();
    private WayConnectionType value = new WayConnectionType();

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        this.value = (WayConnectionType)object;
        this.renderForeground(bl);
        this.setToolTipText(((WayConnectionType)object).getToolTip());
        this.renderBackground(this.getModel(jTable), null, bl);
        return this;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.value == null || !this.value.isValid()) {
            return;
        }
        int n = this.getSize().height - 1;
        int n2 = 8;
        int n3 = this.getSize().width / 2;
        if (this.value.isLoop) {
            n3 -= n2 / 2 - 1;
        }
        int n4 = 2;
        int n5 = 2 + n4 + 1;
        int n6 = 0;
        int n7 = 0;
        if (this.value.linkPrev) {
            graphics.setColor(Color.black);
            graphics.fillRect(n3 - 1, 0, 3, 1);
            n6 = 0;
        } else if (this.value.isLoop) {
            graphics.setColor(Color.black);
            n6 = 5;
            graphics.drawImage(corners, n3, n6 - 3, n3 + 3, n6, 0, 0, 3, 3, new Color(0, 0, 0, 0), null);
            graphics.drawImage(corners, n3 + n2 - 2, n6 - 3, n3 + n2 + 1, n6, 2, 0, 5, 3, new Color(0, 0, 0, 0), null);
            graphics.drawLine(n3 + 3, n6 - 3, n3 + n2 - 3, n6 - 3);
        } else {
            graphics.setColor(Color.red);
            graphics.drawRect(n3 - 1, n5 - 1 - n4, n4, n4);
            n6 = n5;
        }
        if (this.value.linkNext) {
            graphics.setColor(Color.black);
            graphics.fillRect(n3 - 1, n, 3, 1);
            n7 = n;
        } else if (this.value.isLoop) {
            graphics.setColor(Color.black);
            n7 = n - 5;
            graphics.fillRect(n3 - 1, n7 + 2, 3, 3);
            graphics.drawLine(n3, n7, n3, n7 + 2);
            graphics.drawImage(corners, n3 + n2 - 2, n7 + 1, n3 + n2 + 1, n7 + 4, 2, 2, 5, 5, new Color(0, 0, 0, 0), null);
            graphics.drawLine(n3 + 3 - 1, n7 + 3, n3 + n2 - 3, n7 + 3);
        } else {
            graphics.setColor(Color.red);
            graphics.drawRect(n3 - 1, n - n5 + 1, n4, n4);
            n7 = n - n5;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n3, n6, n3, n7);
        if (this.value.isLoop) {
            graphics.drawLine(n3 + n2, n6, n3 + n2, n7);
        }
        Image image = null;
        switch (this.value.direction) {
            case FORWARD: {
                image = arrowDown;
                break;
            }
            case BACKWARD: {
                image = arrowUp;
            }
        }
        if (image != null && (this.value.linkPrev || this.value.linkNext)) {
            graphics.drawImage(image, n3 - 3, (n6 + n7) / 2 - 2, null);
        } else if (this.value.direction == WayConnectionType.Direction.ROUNDABOUT_LEFT) {
            graphics.drawImage(roundabout_left, n3 - 6, 1, null);
        } else if (this.value.direction == WayConnectionType.Direction.ROUNDABOUT_RIGHT) {
            graphics.drawImage(roundabout_right, n3 - 6, 1, null);
        }
    }
}

