/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmServerHistoryReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryLoadTask
extends PleaseWaitRunnable {
    private boolean cancelled = false;
    private Exception lastException = null;
    private HashSet<PrimitiveId> toLoad;
    private HistoryDataSet loadedData;

    public HistoryLoadTask() {
        super(I18n.tr("Load history"), true);
        this.toLoad = new HashSet();
    }

    public HistoryLoadTask(Component component) {
        super(component, I18n.tr("Load history"), true);
        CheckParameterUtil.ensureParameterNotNull(component, "parent");
        this.toLoad = new HashSet();
    }

    public HistoryLoadTask add(long l, OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got {1}.", "id", l));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        SimplePrimitiveId simplePrimitiveId = new SimplePrimitiveId(l, osmPrimitiveType);
        this.toLoad.add(simplePrimitiveId);
        return this;
    }

    public HistoryLoadTask add(PrimitiveId primitiveId) {
        CheckParameterUtil.ensureValidPrimitiveId(primitiveId, "pid");
        this.toLoad.add(primitiveId);
        return this;
    }

    public HistoryLoadTask add(HistoryOsmPrimitive historyOsmPrimitive) {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "primitive");
        this.toLoad.add(historyOsmPrimitive.getPrimitiveId());
        return this;
    }

    public HistoryLoadTask add(History history) {
        CheckParameterUtil.ensureParameterNotNull(history, "history");
        this.toLoad.add(history.getPrimitmiveId());
        return this;
    }

    public HistoryLoadTask add(OsmPrimitive osmPrimitive) {
        CheckParameterUtil.ensureValidPrimitiveId(osmPrimitive, "primitive");
        this.toLoad.add(osmPrimitive.getPrimitiveId());
        return this;
    }

    public HistoryLoadTask add(Collection<? extends OsmPrimitive> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "primitives");
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive == null) continue;
            this.add(osmPrimitive);
        }
        return this;
    }

    @Override
    protected void cancel() {
        OsmApi.getOsmApi().cancel();
        this.cancelled = true;
    }

    @Override
    protected void finish() {
        if (this.isCancelled()) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        HistoryDataSet.getInstance().mergeInto(this.loadedData);
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.loadedData = new HistoryDataSet();
        try {
            for (PrimitiveId primitiveId : this.toLoad) {
                if (this.cancelled) break;
                String string = "";
                switch (primitiveId.getType()) {
                    case NODE: {
                        string = I18n.marktr("Loading history for node {0}");
                        break;
                    }
                    case WAY: {
                        string = I18n.marktr("Loading history for way {0}");
                        break;
                    }
                    case RELATION: {
                        string = I18n.marktr("Loading history for relation {0}");
                    }
                }
                this.progressMonitor.indeterminateSubTask(I18n.tr(string, Long.toString(primitiveId.getUniqueId())));
                OsmServerHistoryReader osmServerHistoryReader = null;
                HistoryDataSet historyDataSet = null;
                try {
                    osmServerHistoryReader = new OsmServerHistoryReader(primitiveId.getType(), primitiveId.getUniqueId());
                    historyDataSet = osmServerHistoryReader.parseHistory(this.progressMonitor.createSubTaskMonitor(1, false));
                }
                catch (OsmTransferException osmTransferException) {
                    if (this.cancelled) {
                        return;
                    }
                    throw osmTransferException;
                }
                this.loadedData.mergeInto(historyDataSet);
            }
        }
        catch (OsmTransferException osmTransferException) {
            this.lastException = osmTransferException;
            return;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Exception getLastException() {
        return this.lastException;
    }
}

