/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openstreetmap.gui.jmapviewer.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JobDispatcher;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.TemplatedTMSTileSource;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TMSLayer
extends ImageryLayer
implements ImageObserver,
TileLoaderListener {
    public static final String PREFERENCE_PREFIX = "imagery.tms";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    public static final int DEFAULT_MAX_ZOOM = 18;
    public static final int DEFAULT_MIN_ZOOM = 2;
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.tms.default_autozoom", true);
    public static final BooleanProperty PROP_DEFAULT_AUTOLOAD = new BooleanProperty("imagery.tms.default_autoload", true);
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.tms.min_zoom_lvl", 2);
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.tms.max_zoom_lvl", 18);
    public static final BooleanProperty PROP_DRAW_DEBUG = new BooleanProperty("imagery.tms.draw_debug", false);
    public static final BooleanProperty PROP_ADD_TO_SLIPPYMAP_CHOOSER = new BooleanProperty("imagery.tms.add_to_slippymap_chooser", true);
    boolean debug = false;
    protected MemoryTileCache tileCache;
    protected TileSource tileSource;
    protected TileLoader tileLoader;
    JobDispatcher jobDispatcher = JobDispatcher.getInstance();
    HashSet<Tile> tileRequestsOutstanding = new HashSet();
    public int currentZoomLevel;
    private Tile clickedTile;
    private boolean needRedraw;
    private JPopupMenu tileOptionMenu;
    JCheckBoxMenuItem autoZoomPopup;
    JCheckBoxMenuItem autoLoadPopup;
    Tile showMetadataTile;
    private Image attrImage;
    private String attrTermsUrl;
    private Rectangle attrImageBounds;
    private Rectangle attrToUBounds;
    private static final Font InfoFont = new Font("sansserif", 1, 13);
    private static final Font ATTR_FONT = new Font("Arial", 0, 10);
    private static final Font ATTR_LINK_FONT;
    protected boolean autoZoom;
    protected boolean autoLoad;
    Image lastScaledImage = null;
    Double lastImageScale = null;
    boolean az_disable = false;

    void out(String string) {
        Main.debug(string);
    }

    @Override
    public synchronized void tileLoadingFinished(Tile tile, boolean bl) {
        if (!bl) {
            BufferedImage bufferedImage = new BufferedImage(this.tileSource.getTileSize(), this.tileSource.getTileSize(), 1);
            this.drawErrorTile(bufferedImage);
            tile.setImage(bufferedImage);
        }
        tile.setLoaded(true);
        this.needRedraw = true;
        Main.map.repaint(100L);
        this.tileRequestsOutstanding.remove(tile);
        if (this.sharpenLevel != 0 && bl) {
            tile.setImage(this.sharpenImage(tile.getImage()));
        }
        if (this.debug) {
            this.out("tileLoadingFinished() tile: " + tile + " success: " + bl);
        }
    }

    @Override
    public TileCache getTileCache() {
        return this.tileCache;
    }

    void clearTileCache() {
        if (this.debug) {
            this.out("clearing tile storage");
        }
        this.tileCache = new MemoryTileCache();
        this.tileCache.setCacheSize(200);
    }

    void redraw() {
        this.needRedraw = true;
        Main.map.repaint();
    }

    static int checkMaxZoomLvl(int n, TileSource tileSource) {
        if (n > 30) {
            System.err.println("MaxZoomLvl shouldnt be more than 30! Setting to 30.");
            n = 30;
        }
        if (n < PROP_MIN_ZOOM_LVL.get()) {
            System.err.println("maxZoomLvl shouldnt be more than minZoomLvl! Setting to minZoomLvl.");
            n = PROP_MIN_ZOOM_LVL.get();
        }
        if (tileSource != null && tileSource.getMaxZoom() != 0 && tileSource.getMaxZoom() < n) {
            n = tileSource.getMaxZoom();
        }
        return n;
    }

    public static int getMaxZoomLvl(TileSource tileSource) {
        return TMSLayer.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), tileSource);
    }

    public static void setMaxZoomLvl(int n) {
        n = TMSLayer.checkMaxZoomLvl(n, null);
        PROP_MAX_ZOOM_LVL.put(n);
    }

    static int checkMinZoomLvl(int n, TileSource tileSource) {
        if (n < 2) {
            System.err.println("minZoomLvl shouldnt be lees than 2! Setting to that.");
            n = 2;
        }
        if (n > PROP_MAX_ZOOM_LVL.get()) {
            System.err.println("minZoomLvl shouldnt be more than maxZoomLvl! Setting to maxZoomLvl.");
            n = TMSLayer.getMaxZoomLvl(tileSource);
        }
        if (tileSource != null && tileSource.getMinZoom() > n) {
            System.err.println("increasomg minZoomLvl to match tile source");
            n = tileSource.getMinZoom();
        }
        return n;
    }

    public static int getMinZoomLvl(TileSource tileSource) {
        return TMSLayer.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), tileSource);
    }

    public static void setMinZoomLvl(int n) {
        n = TMSLayer.checkMinZoomLvl(n, null);
        PROP_MIN_ZOOM_LVL.put(n);
    }

    public static TileSource getTileSource(ImageryInfo imageryInfo) {
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.TMS) {
            if (ImageryInfo.isUrlWithPatterns(imageryInfo.getURL())) {
                return new TemplatedTMSTileSource(imageryInfo.getName(), imageryInfo.getURL(), imageryInfo.getMaxZoom());
            }
            return new TMSTileSource(imageryInfo.getName(), imageryInfo.getURL(), imageryInfo.getMaxZoom());
        }
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.BING) {
            return new BingAerialTileSource();
        }
        return null;
    }

    private void initTileSource(TileSource tileSource) {
        this.tileSource = tileSource;
        boolean bl = tileSource.requiresAttribution();
        if (bl) {
            this.attrImage = tileSource.getAttributionImage();
            if (this.attrImage == null) {
                System.out.println("Attribution image was null.");
            } else {
                System.out.println("Got an attribution image " + this.attrImage.getHeight(this) + "x" + this.attrImage.getWidth(this));
            }
            this.attrTermsUrl = tileSource.getTermsOfUseURL();
        }
        this.currentZoomLevel = this.getBestZoom();
        if (this.currentZoomLevel > this.getMaxZoomLvl()) {
            this.currentZoomLevel = this.getMaxZoomLvl();
        }
        if (this.currentZoomLevel < this.getMinZoomLvl()) {
            this.currentZoomLevel = this.getMinZoomLvl();
        }
        this.clearTileCache();
        this.tileLoader = new OsmFileCacheTileLoader(this);
    }

    @Override
    public void setOffset(double d, double d2) {
        super.setOffset(d, d2);
        this.needRedraw = true;
    }

    private double getPPDeg() {
        MapView mapView = Main.map.mapView;
        return (double)mapView.getWidth() / (mapView.getLatLon(mapView.getWidth(), mapView.getHeight() / 2).lon() - mapView.getLatLon(0, mapView.getHeight() / 2).lon());
    }

    private int getBestZoom() {
        if (Main.map == null || Main.map.mapView == null) {
            return 3;
        }
        double d = Math.log(this.getPPDeg() * 360.0 / (double)this.tileSource.getTileSize()) / Math.log(2.0);
        return (int)Math.round(d);
    }

    public TMSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.setBackgroundLayer(true);
        this.setVisible(true);
        TileSource tileSource = TMSLayer.getTileSource(imageryInfo);
        if (tileSource == null) {
            throw new IllegalStateException("cannot create TMSLayer with non-TMS ImageryInfo");
        }
        this.initTileSource(tileSource);
        this.tileOptionMenu = new JPopupMenu();
        this.autoZoom = PROP_DEFAULT_AUTOZOOM.get();
        this.autoZoomPopup = new JCheckBoxMenuItem();
        this.autoZoomPopup.setAction(new AbstractAction(I18n.tr("Auto Zoom")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.autoZoom = !TMSLayer.this.autoZoom;
            }
        });
        this.autoZoomPopup.setSelected(this.autoZoom);
        this.tileOptionMenu.add(this.autoZoomPopup);
        this.autoLoad = PROP_DEFAULT_AUTOLOAD.get();
        this.autoLoadPopup = new JCheckBoxMenuItem();
        this.autoLoadPopup.setAction(new AbstractAction(I18n.tr("Auto load tiles")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.autoLoad = !TMSLayer.this.autoLoad;
            }
        });
        this.autoLoadPopup.setSelected(this.autoLoad);
        this.tileOptionMenu.add(this.autoLoadPopup);
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load Tile")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.loadTile(TMSLayer.this.clickedTile);
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Show Tile Info")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.out("info tile: " + TMSLayer.this.clickedTile);
                if (TMSLayer.this.clickedTile != null) {
                    TMSLayer.this.showMetadataTile = TMSLayer.this.clickedTile;
                    TMSLayer.this.redraw();
                }
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load All Tiles")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.loadAllTiles(true);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Increase zoom")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.increaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Decrease zoom")){

            public void actionPerformed(ActionEvent actionEvent) {
                TMSLayer.this.decreaseZoomLevel();
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Snap to tile size")){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TMSLayer.this.lastImageScale == null) {
                    TMSLayer.this.out("please wait for a tile to be loaded before snapping");
                    return;
                }
                double d = Math.sqrt(TMSLayer.this.lastImageScale);
                if (TMSLayer.this.debug) {
                    TMSLayer.this.out("tile snap: scale was: " + TMSLayer.this.lastImageScale + ", new factor: " + d);
                }
                Main.map.mapView.zoomToFactor(d);
                TMSLayer.this.redraw();
            }
        }));
        this.tileOptionMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Flush Tile Cache")){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.print("flushing all tiles...");
                TMSLayer.this.clearTileCache();
                System.out.println("done");
            }
        }));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Main.map.mapView.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getButton() == 3) {
                            TMSLayer.this.clickedTile = TMSLayer.this.getTileForPixelpos(mouseEvent.getX(), mouseEvent.getY());
                            TMSLayer.this.tileOptionMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        } else if (mouseEvent.getButton() == 1) {
                            if (!TMSLayer.this.tileSource.requiresAttribution()) {
                                return;
                            }
                            if (TMSLayer.this.attrImageBounds.contains(mouseEvent.getPoint())) {
                                try {
                                    Desktop desktop = Desktop.getDesktop();
                                    desktop.browse(new URI(TMSLayer.this.tileSource.getAttributionLinkURL()));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    uRISyntaxException.printStackTrace();
                                }
                            } else if (TMSLayer.this.attrToUBounds.contains(mouseEvent.getPoint())) {
                                try {
                                    Desktop desktop = Desktop.getDesktop();
                                    desktop.browse(new URI(TMSLayer.this.tileSource.getTermsOfUseURL()));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    uRISyntaxException.printStackTrace();
                                }
                            }
                        }
                    }
                });
                MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

                    public void activeLayerChange(Layer layer, Layer layer2) {
                    }

                    public void layerAdded(Layer layer) {
                    }

                    public void layerRemoved(Layer layer) {
                        MapView.removeLayerChangeListener(this);
                    }
                });
            }
        });
    }

    void zoomChanged() {
        if (this.debug) {
            this.out("zoomChanged(): " + this.currentZoomLevel);
        }
        this.needRedraw = true;
        this.jobDispatcher.cancelOutstandingJobs();
        this.tileRequestsOutstanding.clear();
    }

    int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return TMSLayer.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return TMSLayer.getMaxZoomLvl(this.tileSource);
    }

    int getMinZoomLvl() {
        return TMSLayer.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean bl;
        boolean bl2 = bl = this.currentZoomLevel < this.getMaxZoomLvl();
        if (this.debug) {
            this.out("zoomIncreaseAllowed(): " + bl + " " + this.currentZoomLevel + " vs. " + this.getMaxZoomLvl());
        }
        return bl;
    }

    public boolean increaseZoomLevel() {
        this.lastImageScale = null;
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
            if (this.debug) {
                this.out("increasing zoom level to: " + this.currentZoomLevel);
            }
        } else {
            System.err.println("current zoom lvl (" + this.currentZoomLevel + ") couldnt be increased. " + "MaxZoomLvl (" + this.getMaxZoomLvl() + ") reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        return this.currentZoomLevel > this.getMinZoomLvl();
    }

    public boolean decreaseZoomLevel() {
        int n = this.getMinZoomLvl();
        this.lastImageScale = null;
        if (this.zoomDecreaseAllowed()) {
            if (this.debug) {
                this.out("decreasing zoom level to: " + this.currentZoomLevel);
            }
            --this.currentZoomLevel;
        } else {
            System.err.println("current zoom lvl couldnt be decreased. MinZoomLvl(" + n + ") reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    synchronized Tile tempCornerTile(Tile tile) {
        int n;
        int n2;
        int n3 = tile.getXtile() + 1;
        Tile tile2 = this.getTile(n3, n2 = tile.getYtile() + 1, n = tile.getZoom());
        if (tile2 != null) {
            return tile2;
        }
        return new Tile(this.tileSource, n3, n2, n);
    }

    synchronized Tile getOrCreateTile(int n, int n2, int n3) {
        Tile tile = this.getTile(n, n2, n3);
        if (tile == null) {
            tile = new Tile(this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        return tile;
    }

    synchronized Tile getTile(int n, int n2, int n3) {
        int n4 = 1 << n3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4) {
            return null;
        }
        Tile tile = this.tileCache.getTile(this.tileSource, n, n2, n3);
        return tile;
    }

    synchronized boolean loadTile(Tile tile) {
        if (tile == null) {
            return false;
        }
        if (tile.hasError()) {
            return false;
        }
        if (tile.isLoaded()) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        if (this.tileRequestsOutstanding.contains(tile)) {
            return false;
        }
        this.tileRequestsOutstanding.add(tile);
        this.jobDispatcher.addJob(this.tileLoader.createTileLoaderJob(this.tileSource, tile.getXtile(), tile.getYtile(), tile.getZoom()));
        return true;
    }

    void loadAllTiles(boolean bl) {
        EastNorth eastNorth;
        MapView mapView = Main.map.mapView;
        EastNorth eastNorth2 = mapView.getEastNorth(0, 0);
        TileSet tileSet = new TileSet(eastNorth2, eastNorth = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight()), this.currentZoomLevel);
        if (tileSet.tooLarge()) {
            System.out.println("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        tileSet.loadAllTiles(bl);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = (n & 0x70) != 0;
        this.needRedraw = true;
        if (this.debug) {
            this.out("imageUpdate() done: " + bl + " calling repaint");
        }
        Main.map.repaint(bl ? 0L : 100L);
        return !bl;
    }

    boolean imageLoaded(Image image) {
        if (image == null) {
            return false;
        }
        int n = Toolkit.getDefaultToolkit().checkImage(image, -1, -1, this);
        return (n & 0x20) != 0;
    }

    Image getLoadedTileImage(Tile tile) {
        if (!tile.isLoaded()) {
            return null;
        }
        BufferedImage bufferedImage = tile.getImage();
        if (!this.imageLoaded(bufferedImage)) {
            return null;
        }
        return bufferedImage;
    }

    double getImageScaling(Image image, Rectangle rectangle) {
        int n = -1;
        int n2 = -1;
        if (image != null) {
            n = image.getHeight(this);
            n = image.getWidth(this);
        }
        if (n == -1 || n2 == -1) {
            if (this.lastScaledImage != null) {
                return this.getImageScaling(this.lastScaledImage, rectangle);
            }
            n = 256;
            n2 = 256;
        } else {
            this.lastScaledImage = image;
        }
        double d = rectangle.width;
        double d2 = rectangle.height;
        double d3 = d * d2;
        double d4 = n * n2;
        return d3 / d4;
    }

    LatLon tileLatLon(Tile tile) {
        int n = tile.getZoom();
        return new LatLon(this.tileYToLat(tile.getYtile(), n), this.tileXToLon(tile.getXtile(), n));
    }

    int paintFromOtherZooms(Graphics graphics, Tile tile, Tile tile2) {
        LatLon latLon = this.tileLatLon(tile);
        LatLon latLon2 = this.tileLatLon(tile2);
        int[] nArray = new int[]{-1, 1, -2, 2, -3, -4, -5};
        int n = 0;
        this.debug = true;
        for (int n2 : nArray) {
            int n3 = this.currentZoomLevel + n2;
            if (n3 < this.getMinZoomLvl() || n3 > this.getMaxZoomLvl()) continue;
            TileSet tileSet = new TileSet(latLon, latLon2, n3);
            int n4 = 0;
            this.paintTileImages(graphics, tileSet, n3, null);
            if (this.debug && n4 > 0) {
                this.out("painted " + n4 + "/" + tileSet.size() + " tiles from zoom(" + n2 + "): " + n3);
            }
            n += n4;
            if (!((double)n4 >= tileSet.size())) continue;
            if (!this.debug) break;
            this.out("broke after drawing " + n4 + "/" + tileSet.size() + " at zoomOff: " + n2);
            break;
        }
        this.debug = false;
        return n;
    }

    Rectangle tileToRect(Tile tile) {
        Tile tile2 = this.tempCornerTile(tile);
        Rectangle rectangle = new Rectangle(this.pixelPos(tile));
        rectangle.add(this.pixelPos(tile2));
        return rectangle;
    }

    void drawImageInside(Graphics graphics, Image image, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangle;
        if (rectangle2 != null) {
            rectangle3 = rectangle.intersection(rectangle2);
            if (this.debug) {
                this.out("source: " + rectangle + "\nborder: " + rectangle2 + "\nintersection: " + rectangle3);
            }
        }
        double d = (double)image.getHeight(this) / rectangle.getHeight();
        double d2 = (double)image.getWidth(this) / rectangle.getWidth();
        int n = rectangle3.x - rectangle.x;
        int n2 = rectangle3.y - rectangle.y;
        int n3 = (int)((double)n * d2);
        int n4 = (int)((double)n2 * d);
        int n5 = n3 + (int)(rectangle3.getWidth() * d2);
        int n6 = n4 + (int)(rectangle3.getHeight() * d);
        if (this.debug) {
            this.out("drawing image into target rect: " + rectangle3);
        }
        graphics.drawImage(image, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height, n3, n4, n5, n6, this);
        if (PROP_FADE_AMOUNT.get() != 0) {
            graphics.setColor(TMSLayer.getFadeColorWithAlpha());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    List<Tile> paintTileImages(Graphics graphics, TileSet tileSet, int n, Tile tile) {
        Rectangle rectangle = null;
        if (tile != null) {
            rectangle = this.tileToRect(tile);
        }
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        boolean bl = false;
        for (Tile tile2 : tileSet.allTiles()) {
            Image image = this.getLoadedTileImage(tile2);
            if (image == null) {
                if (this.debug) {
                    this.out("missed tile: " + tile2);
                }
                linkedList.add(tile2);
                continue;
            }
            Rectangle rectangle2 = this.tileToRect(tile2);
            if (rectangle != null && !rectangle2.intersects(rectangle)) continue;
            this.drawImageInside(graphics, image, rectangle2, rectangle);
            if (bl || n != this.currentZoomLevel) continue;
            this.lastImageScale = new Double(this.getImageScaling(image, rectangle2));
            bl = true;
        }
        return linkedList;
    }

    void myDrawString(Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawString(string, n + 1, n2 + 1);
        graphics.setColor(color);
        graphics.drawString(string, n, n2);
    }

    void paintTileText(TileSet tileSet, Tile tile, Graphics graphics, MapView mapView, int n, Tile tile2) {
        String string;
        int n2 = graphics.getFontMetrics().getHeight();
        if (tile == null) {
            return;
        }
        Point point = this.pixelPos(tile2);
        int n3 = point.y + 2 + n2;
        if (PROP_DRAW_DEBUG.get()) {
            this.myDrawString(graphics, "x=" + tile2.getXtile() + " y=" + tile2.getYtile() + " z=" + n + "", point.x + 2, n3);
            n3 += 1 + n2;
            if (tile2.getXtile() % 32 == 0 && tile2.getYtile() % 32 == 0) {
                this.myDrawString(graphics, "x=" + tile2.getXtile() / 32 + " y=" + tile2.getYtile() / 32 + " z=7", point.x + 2, n3);
                n3 += 1 + n2;
            }
        }
        if (tile == this.showMetadataTile) {
            Map<String, String> map;
            string = tile.toString();
            if (string != null) {
                this.myDrawString(graphics, string, point.x + 2, n3);
                n3 += 1 + n2;
            }
            if ((map = tile.getMetadata()) != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.myDrawString(graphics, entry.getKey() + ": " + entry.getValue(), point.x + 2, n3);
                    n3 += 1 + n2;
                }
            }
        }
        string = tile.getStatus();
        if (!tile.isLoaded() && PROP_DRAW_DEBUG.get()) {
            this.myDrawString(graphics, I18n.tr("image " + string), point.x + 2, n3);
            n3 += 1 + n2;
        }
        int n4 = -1;
        int n5 = -1;
        if (PROP_DRAW_DEBUG.get()) {
            if (n5 < tile2.getYtile()) {
                if (tile2.getYtile() % 32 == 31) {
                    graphics.fillRect(0, point.y - 1, mapView.getWidth(), 3);
                } else {
                    graphics.drawLine(0, point.y, mapView.getWidth(), point.y);
                }
                n5 = tile2.getYtile();
            }
            if (n4 < tile2.getXtile()) {
                if (tile2.getXtile() % 32 == 0) {
                    graphics.fillRect(point.x - 1, 0, 3, mapView.getHeight());
                } else {
                    graphics.drawLine(point.x, 0, point.x, mapView.getHeight());
                }
                n4 = tile2.getXtile();
            }
        }
    }

    private Point pixelPos(LatLon latLon) {
        return Main.map.mapView.getPoint(Main.proj.latlon2eastNorth(latLon).add(this.getDx(), this.getDy()));
    }

    private Point pixelPos(Tile tile) {
        double d = this.tileXToLon(tile.getXtile(), tile.getZoom());
        LatLon latLon = new LatLon(this.tileYToLat(tile.getYtile(), tile.getZoom()), d);
        return this.pixelPos(latLon);
    }

    private LatLon getShiftedLatLon(EastNorth eastNorth) {
        return Main.proj.eastNorth2latlon(eastNorth.add(-this.getDx(), -this.getDy()));
    }

    private Coordinate getShiftedCoord(EastNorth eastNorth) {
        LatLon latLon = this.getShiftedLatLon(eastNorth);
        return new Coordinate(latLon.lat(), latLon.lon());
    }

    boolean autoZoomEnabled() {
        if (this.az_disable) {
            return false;
        }
        return this.autoZoom;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        int n;
        EastNorth eastNorth = mapView.getEastNorth(0, 0);
        EastNorth eastNorth2 = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight());
        if (eastNorth2.east() == 0.0 || eastNorth2.north() == 0.0) {
            Main.debug("still initializing??");
            return;
        }
        this.needRedraw = false;
        int n2 = this.currentZoomLevel;
        TileSet tileSet = new TileSet(eastNorth, eastNorth2, n2);
        if (this.autoZoomEnabled()) {
            if (this.zoomDecreaseAllowed() && tileSet.tooLarge()) {
                if (this.debug) {
                    this.out("too many tiles, decreasing zoom from " + this.currentZoomLevel);
                }
                if (this.decreaseZoomLevel()) {
                    this.paint(graphics2D, mapView, bounds);
                }
                return;
            }
            if (this.zoomIncreaseAllowed() && tileSet.tooSmall()) {
                if (this.debug) {
                    this.out("too zoomed in, (" + tileSet.tilesSpanned() + "), increasing zoom from " + this.currentZoomLevel);
                }
                boolean bl = this.az_disable;
                this.az_disable = true;
                if (this.increaseZoomLevel()) {
                    this.paint(graphics2D, mapView, bounds);
                }
                this.az_disable = bl;
                return;
            }
        }
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        graphics2D.setColor(Color.DARK_GRAY);
        List<Tile> list = this.paintTileImages(graphics2D, tileSet, this.currentZoomLevel, null);
        int[] nArray = new int[]{-1, 1, -2, 2, -3, -4, -5};
        for (int n3 : nArray) {
            if (!this.autoZoomEnabled() || !this.autoLoad) break;
            n = this.currentZoomLevel + n3;
            if (list.size() <= 0) break;
            LinkedList<Tile> linkedList = new LinkedList<Tile>();
            for (Tile tile : list) {
                LatLon latLon;
                Tile tile2 = this.tempCornerTile(tile);
                LatLon latLon2 = this.tileLatLon(tile);
                TileSet tileSet2 = new TileSet(latLon2, latLon = this.tileLatLon(tile2), n);
                if (tileSet2.tooLarge()) continue;
                linkedList.addAll(this.paintTileImages(graphics2D, tileSet2, n, tile));
            }
            list = linkedList;
        }
        if (this.debug && list.size() > 0) {
            this.out("still missed " + list.size() + " in the end");
        }
        graphics2D.setColor(Color.red);
        graphics2D.setFont(InfoFont);
        Object object = tileSet.allTiles().iterator();
        while (object.hasNext()) {
            Tile tile = (Tile)object.next();
            this.paintTileText(tileSet, tile, graphics2D, mapView, this.currentZoomLevel, tile);
        }
        if (this.tileSource.requiresAttribution()) {
            int n3;
            object = graphics2D.getFont();
            graphics2D.setFont(ATTR_LINK_FONT);
            graphics2D.setColor(Color.white);
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds("Background Terms of Use", graphics2D);
            int n4 = (int)rectangle2D.getHeight() - 5;
            n3 = (int)rectangle2D.getWidth();
            n = mapView.getHeight() - n4;
            if (this.attrTermsUrl != null) {
                int n5 = 2;
                int n6 = mapView.getHeight() - n4;
                this.attrToUBounds = new Rectangle(n5, n6, n3, n4);
                this.myDrawString(graphics2D, "Background Terms of Use", n5, n6);
            }
            int n7 = this.attrImage.getWidth(this);
            if (this.attrImage != null) {
                int n8 = 2;
                int n9 = this.attrImage.getHeight(this);
                int n10 = n - n9 - n4 - 5;
                this.attrImageBounds = new Rectangle(n8, n10, n7, n9);
                graphics2D.drawImage(this.attrImage, n8, n10, this);
            }
            graphics2D.setFont(ATTR_FONT);
            String string = this.tileSource.getAttributionText(this.currentZoomLevel, this.getShiftedCoord(eastNorth), this.getShiftedCoord(eastNorth2));
            Rectangle2D rectangle2D2 = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            int n11 = mapView.getWidth() - (int)rectangle2D2.getWidth();
            int n12 = mapView.getHeight() - n4;
            this.myDrawString(graphics2D, string, n11, n12);
            graphics2D.setFont((Font)object);
        }
        if (this.autoZoomEnabled() && this.lastImageScale != null) {
            if (this.lastImageScale > 3.0 && this.zoomIncreaseAllowed()) {
                if (this.debug) {
                    this.out("autozoom increase: scale: " + this.lastImageScale);
                }
                this.increaseZoomLevel();
                this.paint(graphics2D, mapView, bounds);
            } else if (this.lastImageScale < 0.45 && this.lastImageScale > 0.0 && this.zoomDecreaseAllowed()) {
                if (this.debug) {
                    this.out("autozoom decrease: scale: " + this.lastImageScale);
                }
                this.decreaseZoomLevel();
                this.paint(graphics2D, mapView, bounds);
            }
        }
        graphics2D.setColor(Color.black);
        if (tileSet.insane()) {
            this.myDrawString(graphics2D, "zoom in to load any tiles", 120, 120);
        } else if (tileSet.tooLarge()) {
            this.myDrawString(graphics2D, "zoom in to load more tiles", 120, 120);
        } else if (tileSet.tooSmall()) {
            this.myDrawString(graphics2D, "increase zoom level to see more detail", 120, 120);
        }
    }

    Tile getTileForPixelpos(int n, int n2) {
        int n3;
        EastNorth eastNorth;
        if (this.debug) {
            this.out("getTileForPixelpos(" + n + ", " + n2 + ")");
        }
        MapView mapView = Main.map.mapView;
        Point point = new Point(n, n2);
        EastNorth eastNorth2 = mapView.getEastNorth(0, 0);
        TileSet tileSet = new TileSet(eastNorth2, eastNorth = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight()), n3 = this.currentZoomLevel);
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        Tile tile = null;
        for (Tile tile2 : tileSet.allTiles()) {
            Tile tile3 = this.tempCornerTile(tile2);
            Rectangle rectangle = new Rectangle(this.pixelPos(tile2));
            rectangle.add(this.pixelPos(tile3));
            if (this.debug) {
                this.out("r: " + rectangle + " clicked: " + point);
            }
            if (!rectangle.contains(point)) continue;
            tile = tile2;
            break;
        }
        if (tile == null) {
            return null;
        }
        System.out.println("clicked on tile: " + tile.getXtile() + " " + tile.getYtile() + " scale: " + this.lastImageScale + " currentZoomLevel: " + this.currentZoomLevel);
        return tile;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    @Override
    public boolean isChanged() {
        return this.needRedraw;
    }

    private int latToTileY(double d, int n) {
        double d2 = d / 180.0 * Math.PI;
        double d3 = Math.log(Math.tan(d2) + 1.0 / Math.cos(d2));
        return (int)(Math.pow(2.0, n - 1) * (Math.PI - d3) / Math.PI);
    }

    private int lonToTileX(double d, int n) {
        return (int)(Math.pow(2.0, n - 3) * (d + 180.0) / 45.0);
    }

    private double tileYToLat(int n, int n2) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)n / Math.pow(2.0, n2 - 1))) * 180.0 / Math.PI;
    }

    private double tileXToLon(int n, int n2) {
        return (double)n * 45.0 / Math.pow(2.0, n2 - 3) - 180.0;
    }

    static {
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
        hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        ATTR_LINK_FONT = ATTR_FONT.deriveFont(hashMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TileSet {
        int z12x0;
        int z12x1;
        int z12y0;
        int z12y1;
        int zoom;
        int tileMax = -1;

        TileSet(EastNorth eastNorth, EastNorth eastNorth2, int n) {
            this(tMSLayer.getShiftedLatLon(eastNorth), tMSLayer.getShiftedLatLon(eastNorth2), n);
        }

        TileSet(LatLon latLon, LatLon latLon2, int n) {
            int n2;
            this.zoom = n;
            this.z12x0 = TMSLayer.this.lonToTileX(latLon.lon(), n);
            this.z12y0 = TMSLayer.this.latToTileY(latLon.lat(), n);
            this.z12x1 = TMSLayer.this.lonToTileX(latLon2.lon(), n);
            this.z12y1 = TMSLayer.this.latToTileY(latLon2.lat(), n);
            if (this.z12x0 > this.z12x1) {
                n2 = this.z12x0;
                this.z12x0 = this.z12x1;
                this.z12x1 = n2;
            }
            if (this.z12y0 > this.z12y1) {
                n2 = this.z12y0;
                this.z12y0 = this.z12y1;
                this.z12y1 = n2;
            }
            this.tileMax = (int)Math.pow(2.0, n);
            if (this.z12x0 < 0) {
                this.z12x0 = 0;
            }
            if (this.z12y0 < 0) {
                this.z12y0 = 0;
            }
            if (this.z12x1 > this.tileMax) {
                this.z12x1 = this.tileMax;
            }
            if (this.z12y1 > this.tileMax) {
                this.z12y1 = this.tileMax;
            }
        }

        boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        boolean tooLarge() {
            return this.tilesSpanned() > 10.0;
        }

        boolean insane() {
            return this.tilesSpanned() > 100.0;
        }

        double tilesSpanned() {
            return Math.sqrt(1.0 * this.size());
        }

        double size() {
            double d = (double)(this.z12x1 - this.z12x0) + 1.0;
            double d2 = (double)(this.z12y1 - this.z12y0) + 1.0;
            return d * d2;
        }

        List<Tile> allTiles() {
            return this.allTiles(false);
        }

        private List<Tile> allTiles(boolean bl) {
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            if (this.insane()) {
                return arrayList;
            }
            for (int i = this.z12x0; i <= this.z12x1; ++i) {
                for (int j = this.z12y0; j <= this.z12y1; ++j) {
                    Tile tile = bl ? TMSLayer.this.getOrCreateTile(i % this.tileMax, j % this.tileMax, this.zoom) : TMSLayer.this.getTile(i % this.tileMax, j % this.tileMax, this.zoom);
                    if (tile == null) continue;
                    arrayList.add(tile);
                }
            }
            return arrayList;
        }

        void loadAllTiles(boolean bl) {
            List<Tile> list = this.allTiles(true);
            if (!TMSLayer.this.autoLoad && !bl) {
                return;
            }
            int n = 0;
            for (Tile tile : list) {
                if (!TMSLayer.this.loadTile(tile)) continue;
                ++n;
            }
            if (TMSLayer.this.debug && n > 0) {
                TMSLayer.this.out("queued to load: " + n + "/" + list.size() + " tiles at zoom: " + this.zoom);
            }
        }
    }
}

