/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.QuadStateCheckBox;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggingPreset
extends AbstractAction
implements MapView.LayerChangeListener {
    public static final int DIALOG_ANSWER_APPLY = 1;
    public static final int DIALOG_ANSWER_NEW_RELATION = 2;
    public static final int DIALOG_ANSWER_CANCEL = 3;
    public TaggingPresetMenu group = null;
    public String name;
    public String name_context;
    public String locale_name;
    public static final String OPTIONAL_TOOLTIP_TEXT = "Optional tooltip text";
    private static File zipIcons = null;
    public static final String DIFFERENT = I18n.tr("<different>");
    public EnumSet<PresetType> types;
    public List<Item> data = new LinkedList<Item>();
    private static HashMap<String, String> lastValue = new HashMap();
    private boolean originalSelectionEmpty = false;

    static Usage determineTextUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new TreeSet();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = osmPrimitive.get(string);
            if (string2 != null) {
                usage.values.add(string2);
            } else {
                usage.hadEmpty = true;
            }
            if (!osmPrimitive.hasKeys()) continue;
            usage.hadKeys = true;
        }
        return usage;
    }

    static Usage determineBooleanUsage(Collection<OsmPrimitive> collection, String string) {
        Usage usage = new Usage();
        usage.values = new TreeSet();
        for (OsmPrimitive osmPrimitive : collection) {
            String string2 = OsmUtils.getNamedOsmBoolean(osmPrimitive.get(string));
            if (string2 == null) continue;
            usage.values.add(string2);
        }
        return usage;
    }

    public TaggingPreset() {
        MapView.addLayerChangeListener(this);
        this.updateEnabledState();
    }

    public void setDisplayName() {
        this.putValue("Name", this.getName());
        this.putValue("toolbar", "tagging_" + this.getRawName());
    }

    public String getLocaleName() {
        if (this.locale_name == null) {
            this.locale_name = this.name_context != null ? I18n.trc(this.name_context, this.name) : I18n.tr(this.name);
        }
        return this.locale_name;
    }

    public String getName() {
        return this.group != null ? this.group.getName() + "/" + this.getLocaleName() : this.getLocaleName();
    }

    public String getRawName() {
        return this.group != null ? this.group.getRawName() + "/" + this.name : this.name;
    }

    public void setIcon(String string) {
        Collection<String> collection = Main.pref.getCollection("taggingpreset.icon.sources", null);
        ImageIcon imageIcon = ImageProvider.getIfAvailable(collection, "presets", null, string, zipIcons);
        if (imageIcon == null) {
            System.out.println("Could not get presets icon " + string);
            imageIcon = new ImageIcon(string);
        }
        if (Math.max(imageIcon.getIconHeight(), imageIcon.getIconWidth()) != 16) {
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
        }
        this.putValue("SmallIcon", imageIcon);
    }

    public static EnumSet<PresetType> getType(String string) throws SAXException {
        EnumSet<PresetType> enumSet = EnumSet.noneOf(PresetType.class);
        for (String string2 : Arrays.asList(string.split(","))) {
            try {
                PresetType presetType = PresetType.valueOf(string2.toUpperCase());
                enumSet.add(presetType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException(I18n.tr("Unknown type: {0}", string2));
            }
        }
        return enumSet;
    }

    public void setType(String string) throws SAXException {
        this.types = TaggingPreset.getType(string);
    }

    public static List<TaggingPreset> readAll(Reader reader, boolean bl) throws SAXException {
        XmlObjectParser xmlObjectParser = new XmlObjectParser();
        xmlObjectParser.mapOnStart("item", TaggingPreset.class);
        xmlObjectParser.mapOnStart("separator", TaggingPresetSeparator.class);
        xmlObjectParser.mapBoth("group", TaggingPresetMenu.class);
        xmlObjectParser.map("text", Text.class);
        xmlObjectParser.map("link", Link.class);
        xmlObjectParser.mapOnStart("optional", Optional.class);
        xmlObjectParser.mapOnStart("roles", Roles.class);
        xmlObjectParser.map("role", Role.class);
        xmlObjectParser.map("check", Check.class);
        xmlObjectParser.map("combo", Combo.class);
        xmlObjectParser.map("label", Label.class);
        xmlObjectParser.map("space", Space.class);
        xmlObjectParser.map("key", Key.class);
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        TaggingPreset taggingPreset = null;
        Roles roles = null;
        if (bl) {
            xmlObjectParser.startWithValidation(reader, "http://josm.openstreetmap.de/tagging-preset-1.0", "resource://data/tagging-preset.xsd");
        } else {
            xmlObjectParser.start(reader);
        }
        while (xmlObjectParser.hasNext()) {
            TaggingPreset taggingPreset2;
            Object object = xmlObjectParser.next();
            if (object instanceof TaggingPresetMenu) {
                taggingPreset2 = (TaggingPresetMenu)object;
                if (taggingPreset2 == taggingPreset) {
                    taggingPreset = ((TaggingPresetMenu)taggingPreset2).group;
                } else {
                    ((TaggingPresetMenu)taggingPreset2).group = taggingPreset;
                    ((TaggingPresetMenu)taggingPreset2).setDisplayName();
                    taggingPreset = taggingPreset2;
                    linkedList.add(taggingPreset2);
                }
                roles = null;
                continue;
            }
            if (object instanceof TaggingPresetSeparator) {
                taggingPreset2 = (TaggingPresetSeparator)object;
                ((TaggingPresetSeparator)taggingPreset2).group = taggingPreset;
                linkedList.add(taggingPreset2);
                roles = null;
                continue;
            }
            if (object instanceof TaggingPreset) {
                taggingPreset2 = (TaggingPreset)object;
                taggingPreset2.group = taggingPreset;
                taggingPreset2.setDisplayName();
                linkedList.add(taggingPreset2);
                roles = null;
                continue;
            }
            if (linkedList.size() != 0) {
                if (object instanceof Roles) {
                    linkedList.getLast().data.add((Item)object);
                    roles = (Roles)object;
                    continue;
                }
                if (object instanceof Role) {
                    if (roles == null) {
                        throw new SAXException(I18n.tr("Preset role element without parent"));
                    }
                    roles.roles.add((Role)object);
                    continue;
                }
                linkedList.getLast().data.add((Item)object);
                roles = null;
                continue;
            }
            throw new SAXException(I18n.tr("Preset sub element without parent"));
        }
        return linkedList;
    }

    public static Collection<TaggingPreset> readAll(String string, boolean bl) throws SAXException, IOException {
        InputStreamReader inputStreamReader;
        MirroredInputStream mirroredInputStream = new MirroredInputStream(string);
        InputStream inputStream = mirroredInputStream.getZipEntry("xml", "preset");
        if (inputStream != null) {
            zipIcons = mirroredInputStream.getFile();
        }
        try {
            inputStreamReader = new InputStreamReader(inputStream == null ? mirroredInputStream : inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = new InputStreamReader(inputStream == null ? mirroredInputStream : inputStream);
        }
        return TaggingPreset.readAll(new BufferedReader(inputStreamReader), bl);
    }

    public static Collection<TaggingPreset> readAll(Collection<String> collection, boolean bl) {
        LinkedList<TaggingPreset> linkedList = new LinkedList<TaggingPreset>();
        for (String string : collection) {
            try {
                linkedList.addAll(TaggingPreset.readAll(string, bl));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", string), I18n.tr("Error"), 0);
            }
            catch (SAXException sAXException) {
                System.err.println(sAXException.getMessage());
                System.err.println(string);
                sAXException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error parsing {0}: ", string) + sAXException.getMessage(), I18n.tr("Error"), 0);
            }
            zipIcons = null;
        }
        return linkedList;
    }

    public static LinkedList<String> getPresetSources() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (Main.pref.getBoolean("taggingpreset.enable-defaults", true)) {
            linkedList.add("resource://data/defaultpresets.xml");
        }
        linkedList.addAll(Main.pref.getCollection("taggingpreset.sources", new LinkedList<String>()));
        return linkedList;
    }

    public static Collection<TaggingPreset> readFromPreferences(boolean bl) {
        return TaggingPreset.readAll(TaggingPreset.getPresetSources(), bl);
    }

    public PresetPanel createPanel(Collection<OsmPrimitive> collection) {
        JPanel jPanel;
        if (this.data == null) {
            return null;
        }
        PresetPanel presetPanel = new PresetPanel();
        LinkedList<Item> linkedList = new LinkedList<Item>();
        if (this.types != null) {
            jPanel = new JPanel();
            for (PresetType object : this.types) {
                JLabel jLabel = new JLabel(ImageProvider.get(object.getIconName()));
                jLabel.setToolTipText(I18n.tr("Elements of type {0} are supported.", I18n.tr(object.getName())));
                jPanel.add(jLabel);
            }
            presetPanel.add((Component)jPanel, GBC.eol());
        }
        jPanel = new JPanel(new GridBagLayout());
        for (Item item : this.data) {
            if (item instanceof Link) {
                linkedList.add(item);
                continue;
            }
            if (!item.addToPanel(jPanel, collection)) continue;
            presetPanel.hasElements = true;
        }
        presetPanel.add((Component)jPanel, GBC.eol().fill());
        if (collection.size() == 0 && !this.supportsRelation()) {
            GuiHelper.setEnabledRec(jPanel, false);
        }
        for (Item item : linkedList) {
            item.addToPanel(presetPanel, collection);
        }
        return presetPanel;
    }

    public boolean isShowable() {
        for (Item item : this.data) {
            if (item instanceof Optional || item instanceof Space || item instanceof Key) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.main == null) {
            return;
        }
        if (Main.main.getCurrentDataSet() == null) {
            return;
        }
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        int n = this.showDialog(collection, this.supportsRelation());
        if (collection.size() != 0 && n == 1) {
            Command command = TaggingPreset.createCommand(collection, this.getChangedTags());
            if (command != null) {
                Main.main.undoRedo.add(command);
            }
        } else if (n == 2) {
            ArrayList arrayList = new ArrayList(2);
            final Relation relation = new Relation();
            final HashSet<RelationMember> hashSet = new HashSet<RelationMember>();
            for (Tag object : this.getChangedTags()) {
                relation.put(object.getKey(), object.getValue());
            }
            for (OsmPrimitive osmPrimitive : collection) {
                RelationMember relationMember = new RelationMember("", osmPrimitive);
                relation.addMember(relationMember);
                hashSet.add(relationMember);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RelationEditor.getEditor(Main.main.getEditLayer(), relation, hashSet).setVisible(true);
                }
            });
        }
        Main.main.getCurrentDataSet().setSelected(Main.main.getCurrentDataSet().getSelected());
    }

    public int showDialog(Collection<OsmPrimitive> collection, final boolean bl) {
        Collection<OsmPrimitive> collection2 = this.createSelection(collection);
        PresetPanel presetPanel = this.createPanel(collection2);
        if (presetPanel == null) {
            return 3;
        }
        int n = 1;
        if (presetPanel.getComponentCount() != 0 && (collection2.size() == 0 || presetPanel.hasElements)) {
            String string = I18n.trn("Change {0} object", "Change {0} objects", collection2.size(), collection2.size());
            if (collection2.size() == 0) {
                string = this.originalSelectionEmpty ? I18n.tr("Nothing selected!") : I18n.tr("Selection unsuitable!");
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class PresetDialog
            extends ExtendedDialog {
                public PresetDialog(Component component, String string, boolean bl3) {
                    String[] stringArray;
                    if (bl2) {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = I18n.tr("Apply Preset");
                        stringArray2[1] = I18n.tr("New relation");
                        stringArray = stringArray2;
                        stringArray2[2] = I18n.tr("Cancel");
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = I18n.tr("Apply Preset");
                        stringArray = stringArray3;
                        stringArray3[1] = I18n.tr("Cancel");
                    }
                    super(Main.parent, string, stringArray, true);
                    this.contentInsets = new Insets(10, 5, 0, 5);
                    if (bl) {
                        this.setButtonIcons(new String[]{"ok.png", "dialogs/addrelation.png", "cancel.png"});
                    } else {
                        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
                    }
                    this.setContent(component);
                    this.setDefaultButton(1);
                    this.setupDialog();
                    ((JButton)this.buttons.get(0)).setEnabled(!bl3);
                    ((JButton)this.buttons.get(0)).setToolTipText(string);
                    this.showDialog();
                }
            }
            n = new PresetDialog(presetPanel, string, collection2.size() == 0).getValue();
        }
        if (!bl && n == 2) {
            return 3;
        }
        return n;
    }

    private Collection<OsmPrimitive> createSelection(Collection<OsmPrimitive> collection) {
        this.originalSelectionEmpty = collection.size() == 0;
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (this.types != null && (osmPrimitive instanceof Relation ? !this.types.contains((Object)PresetType.RELATION) : (osmPrimitive instanceof Node ? !this.types.contains((Object)PresetType.NODE) : osmPrimitive instanceof Way && !this.types.contains((Object)PresetType.WAY) && (!this.types.contains((Object)PresetType.CLOSEDWAY) || !((Way)osmPrimitive).isClosed())))) continue;
            linkedList.add(osmPrimitive);
        }
        return linkedList;
    }

    public List<Tag> getChangedTags() {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        for (Item item : this.data) {
            item.addCommands(arrayList);
        }
        return arrayList;
    }

    public static Command createCommand(Collection<OsmPrimitive> collection, List<Tag> list) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        for (Tag tag : list) {
            if (tag.getValue().isEmpty()) continue;
            arrayList.add(new ChangePropertyCommand(collection, tag.getKey(), tag.getValue()));
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (Command)arrayList.get(0);
        }
        return new SequenceCommand(I18n.tr("Change Properties"), arrayList);
    }

    private boolean supportsRelation() {
        return this.types == null || this.types.contains((Object)PresetType.RELATION);
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.main != null && Main.main.getCurrentDataSet() != null);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(Layer layer) {
        this.updateEnabledState();
    }

    @Override
    public void layerRemoved(Layer layer) {
        this.updateEnabledState();
    }

    public String toString() {
        return (this.types == null ? "" : this.types) + " " + this.name;
    }

    private static class PresetPanel
    extends JPanel {
        boolean hasElements = false;

        PresetPanel() {
            super(new GridBagLayout());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Key
    extends Item {
        public String key;
        public String value;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
            list.add(new Tag(this.key, this.value != null && !this.value.equals("") ? this.value : null));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Space
    extends Item {
        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Optional
    extends Item {
        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            jPanel.add((Component)new JLabel(I18n.tr("Optional Attributes:")), GBC.eol());
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Roles
    extends Item {
        public List<Role> roles = new LinkedList<Role>();

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            jPanel.add((Component)new JLabel(" "), GBC.eol());
            if (this.roles.size() > 0) {
                JPanel jPanel2 = new JPanel(new GridBagLayout());
                jPanel2.add((Component)new JLabel(I18n.tr("Available roles")), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("role")), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("count")), GBC.std().insets(0, 0, 10, 0));
                jPanel2.add((Component)new JLabel(I18n.tr("elements")), GBC.eol());
                for (Role role : this.roles) {
                    role.addToPanel(jPanel2, collection);
                }
                jPanel.add((Component)jPanel2, GBC.eol());
            }
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Role {
        public EnumSet<PresetType> types;
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public boolean required = false;
        public long count = 0L;

        public void setType(String string) throws SAXException {
            this.types = TaggingPreset.getType(string);
        }

        public void setRequisite(String string) throws SAXException {
            if ("required".equals(string)) {
                this.required = true;
            } else if (!"optional".equals(string)) {
                throw new SAXException(I18n.tr("Unknown requisite: {0}", string));
            }
        }

        public long getValidCount(long l) {
            if (this.count > 0L && !this.required) {
                return l != 0L ? this.count : 0L;
            }
            if (this.count > 0L) {
                return this.count;
            }
            if (!this.required) {
                return l != 0L ? l : 0L;
            }
            return l != 0L ? l : 1L;
        }

        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            String string = this.count > 0L && !this.required ? "0," + String.valueOf(this.count) : (this.count > 0L ? String.valueOf(this.count) : (!this.required ? "0-..." : "1-..."));
            if (this.locale_text == null && this.text != null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)new JLabel(this.key), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)new JLabel(string), this.types == null ? GBC.eol() : GBC.std().insets(0, 0, 10, 0));
            if (this.types != null) {
                JPanel jPanel2 = new JPanel();
                for (PresetType presetType : this.types) {
                    jPanel2.add(new JLabel(ImageProvider.get(presetType.getIconName())));
                }
                jPanel.add((Component)jPanel2, GBC.eol());
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Link
    extends Item {
        public String href;
        public String text;
        public String text_context;
        public String locale_text;
        public String locale_href;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            String string;
            if (this.locale_text == null) {
                this.locale_text = this.text == null ? I18n.tr("More information about this feature") : (this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text));
            }
            if ((string = this.locale_href) == null) {
                string = this.href;
            }
            if (string != null) {
                jPanel.add((Component)new UrlLabel(string, this.locale_text), GBC.eol().anchor(17));
            }
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Label
    extends Item {
        public String text;
        public String text_context;
        public String locale_text;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            jPanel.add((Component)new JLabel(this.locale_text), GBC.eol());
            return false;
        }

        @Override
        public void addCommands(List<Tag> list) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Combo
    extends Item {
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public String values;
        public String values_context;
        public String display_values;
        public String locale_display_values;
        public String short_descriptions;
        public String locale_short_descriptions;
        public String default_;
        public boolean delete_if_empty = false;
        public boolean editable = true;
        public boolean use_last_as_default = false;
        public boolean required = false;
        private List<String> short_description_list;
        private JComboBox combo;
        private Map<String, PresetListEnty> lhm;
        private Usage usage;
        private PresetListEnty originalValue;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            this.usage = TaggingPreset.determineTextUsage(collection, this.key);
            String string = this.default_;
            String[] stringArray = this.values.split(",");
            String[] stringArray2 = null;
            String[] stringArray3 = this.locale_display_values != null ? Combo.splitEscaped(this.locale_display_values) : (this.display_values != null ? Combo.splitEscaped(this.display_values) : stringArray);
            if (this.locale_short_descriptions != null) {
                stringArray2 = Combo.splitEscaped(this.locale_short_descriptions);
            } else if (this.short_descriptions != null) {
                stringArray2 = Combo.splitEscaped(this.short_descriptions);
            } else if (this.short_description_list != null) {
                stringArray2 = this.short_description_list.toArray(new String[0]);
            }
            if (this.use_last_as_default && string == null && lastValue.containsKey(this.key)) {
                string = (String)lastValue.get(this.key);
            }
            if (stringArray3.length != stringArray.length) {
                System.err.println(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''display_values'' must be the same as in ''values''", this.key, this.text));
                stringArray3 = stringArray;
            }
            if (stringArray2 != null && stringArray2.length != stringArray.length) {
                System.err.println(I18n.tr("Broken tagging preset \"{0}-{1}\" - number of items in ''short_descriptions'' must be the same as in ''values''", this.key, this.text));
                stringArray2 = null;
            }
            this.lhm = new LinkedHashMap<String, PresetListEnty>();
            if (!this.usage.hasUniqueValue() && !this.usage.unused()) {
                this.lhm.put(DIFFERENT, new PresetListEnty(DIFFERENT));
            }
            for (int i = 0; i < stringArray.length; ++i) {
                PresetListEnty object = new PresetListEnty(stringArray[i]);
                String string2 = this.locale_display_values == null ? (this.values_context == null ? I18n.tr(stringArray3[i]) : I18n.trc(this.values_context, stringArray3[i])) : (object.display_value = stringArray3[i]);
                if (stringArray2 != null) {
                    object.short_description = this.locale_short_descriptions == null ? I18n.tr(stringArray2[i]) : stringArray2[i];
                }
                this.lhm.put(stringArray[i], object);
            }
            if (!this.usage.unused()) {
                for (String string3 : this.usage.values) {
                    if (this.lhm.containsKey(string3)) continue;
                    this.lhm.put(string3, new PresetListEnty(string3));
                }
            }
            if (string != null && !this.lhm.containsKey(string)) {
                this.lhm.put(string, new PresetListEnty(string));
            }
            this.lhm.put("", new PresetListEnty(""));
            this.combo = new JComboBox<Object>(this.lhm.values().toArray());
            this.combo.setRenderer(new PresetComboListCellRenderer());
            this.combo.setEditable(this.editable);
            this.combo.setMaximumRowCount(13);
            AutoCompletingTextField autoCompletingTextField = new AutoCompletingTextField();
            this.initAutoCompletionField(autoCompletingTextField, this.key);
            autoCompletingTextField.getAutoCompletionList().add(Arrays.asList(stringArray3), AutoCompletionItemPritority.IS_IN_STANDARD);
            this.combo.setEditor(autoCompletingTextField);
            this.originalValue = this.usage.hasUniqueValue() && !this.usage.unused() ? this.lhm.get(this.usage.getFirst()) : (string != null && !this.usage.hadKeys() ? this.lhm.get(DIFFERENT) : (this.usage.unused() ? this.lhm.get("") : this.lhm.get(DIFFERENT)));
            this.combo.setSelectedItem(this.originalValue);
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)this.combo, GBC.eol().fill(2));
            return true;
        }

        private static String[] splitEscaped(String string) {
            String[] stringArray = string.replaceAll("\\\\,", "\u0091").split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].replaceAll("\u0091", ",");
            }
            return stringArray;
        }

        @Override
        public void addCommands(List<Tag> list) {
            Object object = this.combo.getSelectedItem();
            String string = object == null ? null : object.toString();
            String string2 = null;
            if (string == null && this.combo.isEditable()) {
                string = this.combo.getEditor().getItem().toString();
            }
            if (string != null) {
                for (String string3 : this.lhm.keySet()) {
                    String string4 = this.lhm.get(string3).toString();
                    if (string4 == null || !string4.equals(string)) continue;
                    string2 = string3;
                }
                if (string2 == null) {
                    string2 = string;
                }
            } else {
                string2 = "";
            }
            if (this.originalValue == null ? string2.length() == 0 : string2.equals(this.originalValue.toString())) {
                return;
            }
            if (this.delete_if_empty && string2.length() == 0) {
                string2 = null;
            }
            if (this.use_last_as_default) {
                lastValue.put(this.key, string2);
            }
            System.err.print("change: " + this.key + " " + string2);
            list.add(new Tag(this.key, string2));
        }

        public void setShort_description(String string) {
            if (this.short_description_list == null) {
                this.short_description_list = new ArrayList<String>();
            }
            this.short_description_list.add(I18n.tr(string));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.combo.requestFocusInWindow();
        }

        private static class PresetComboListCellRenderer
        implements ListCellRenderer {
            HtmlPanel lbl;
            JComponent dummy = new JComponent(){};

            public PresetComboListCellRenderer() {
                this.lbl = new HtmlPanel();
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (bl) {
                    this.lbl.setBackground(jList.getSelectionBackground());
                    this.lbl.setForeground(jList.getSelectionForeground());
                } else {
                    this.lbl.setBackground(jList.getBackground());
                    this.lbl.setForeground(jList.getForeground());
                }
                PresetListEnty presetListEnty = (PresetListEnty)object;
                String string = presetListEnty.getListDisplay();
                this.lbl.setText(string);
                if (n == -1) {
                    this.dummy.setPreferredSize(new Dimension(this.lbl.getPreferredSize().width, 10));
                    return this.dummy;
                }
                return this.lbl;
            }
        }

        private static class PresetListEnty {
            String value;
            String display_value;
            String short_description;

            public String getListDisplay() {
                if (this.value.equals(DIFFERENT)) {
                    return "<b>" + DIFFERENT.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</b>";
                }
                if (this.value.equals("")) {
                    return "&nbsp;";
                }
                StringBuilder stringBuilder = new StringBuilder("<b>");
                if (this.display_value != null) {
                    stringBuilder.append(this.display_value);
                } else {
                    stringBuilder.append(this.value);
                }
                stringBuilder.append("</b>");
                if (this.short_description != null) {
                    stringBuilder.append("<br><table><td width='232'>(").append(this.short_description).append(")</td></table>");
                }
                return stringBuilder.toString();
            }

            public PresetListEnty(String string) {
                this.value = string;
                this.display_value = string;
            }

            public PresetListEnty(String string, String string2) {
                this.value = string;
                this.display_value = string2;
            }

            public String toString() {
                if (this.value.equals(DIFFERENT)) {
                    return DIFFERENT;
                }
                return this.display_value.replaceAll("<.*>", "");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Check
    extends Item {
        public String key;
        public String text;
        public String text_context;
        public String locale_text;
        public String value_on = "yes";
        public String value_off = "no";
        public boolean default_ = false;
        public boolean use_last_as_default = false;
        public boolean required = false;
        private QuadStateCheckBox check;
        private QuadStateCheckBox.State initialState;
        private boolean def;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            Usage usage = TaggingPreset.determineBooleanUsage(collection, this.key);
            this.def = this.default_;
            if (this.locale_text == null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            String string = null;
            Iterator<Object> iterator = usage.values.iterator();
            while (iterator.hasNext()) {
                String object;
                string = object = iterator.next();
            }
            if (usage.values.size() < 2 && (string == null || this.value_on.equals(string) || this.value_off.equals(string))) {
                if (this.def) {
                    for (OsmPrimitive osmPrimitive : collection) {
                        if (!osmPrimitive.hasKeys()) continue;
                        this.def = false;
                    }
                }
                this.initialState = this.value_on.equals(string) ? QuadStateCheckBox.State.SELECTED : (this.value_off.equals(string) ? QuadStateCheckBox.State.NOT_SELECTED : (this.def ? QuadStateCheckBox.State.SELECTED : QuadStateCheckBox.State.UNSET));
                this.check = new QuadStateCheckBox(this.locale_text, this.initialState, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            } else {
                this.def = false;
                this.initialState = QuadStateCheckBox.State.PARTIAL;
                this.check = new QuadStateCheckBox(this.locale_text, QuadStateCheckBox.State.PARTIAL, new QuadStateCheckBox.State[]{QuadStateCheckBox.State.PARTIAL, QuadStateCheckBox.State.SELECTED, QuadStateCheckBox.State.NOT_SELECTED, QuadStateCheckBox.State.UNSET});
            }
            jPanel.add((Component)this.check, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(List<Tag> list) {
            if (this.check.getState() == this.initialState && !this.def) {
                return;
            }
            list.add(new Tag(this.key, this.check.getState() == QuadStateCheckBox.State.SELECTED ? this.value_on : (this.check.getState() == QuadStateCheckBox.State.NOT_SELECTED ? this.value_off : null)));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.check.requestFocusInWindow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Text
    extends Item {
        public String key;
        public String text;
        public String locale_text;
        public String text_context;
        public String default_;
        public String originalValue;
        public boolean use_last_as_default = false;
        public boolean delete_if_empty = false;
        public boolean required = false;
        private JComponent value;

        @Override
        public boolean addToPanel(JPanel jPanel, Collection<OsmPrimitive> collection) {
            Usage usage = TaggingPreset.determineTextUsage(collection, this.key);
            AutoCompletingTextField autoCompletingTextField = new AutoCompletingTextField();
            this.initAutoCompletionField(autoCompletingTextField, this.key);
            if (usage.unused()) {
                if (this.use_last_as_default && lastValue.containsKey(this.key)) {
                    autoCompletingTextField.setText((String)lastValue.get(this.key));
                } else {
                    autoCompletingTextField.setText(this.default_);
                }
                this.value = autoCompletingTextField;
                this.originalValue = null;
            } else if (usage.hasUniqueValue()) {
                autoCompletingTextField.setText(usage.getFirst());
                this.value = autoCompletingTextField;
                this.originalValue = usage.getFirst();
            } else {
                JComboBox<Object> jComboBox = new JComboBox<Object>(usage.values.toArray());
                jComboBox.setEditable(true);
                jComboBox.setEditor(autoCompletingTextField);
                jComboBox.getEditor().setItem(DIFFERENT);
                this.value = jComboBox;
                this.originalValue = DIFFERENT;
            }
            if (this.locale_text == null && this.text != null) {
                this.locale_text = this.text_context != null ? I18n.trc(this.text_context, this.text) : I18n.tr(this.text);
            }
            jPanel.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            jPanel.add((Component)this.value, GBC.eol().fill(2));
            return true;
        }

        @Override
        public void addCommands(List<Tag> list) {
            String string;
            String string2 = string = this.value instanceof JComboBox ? ((JComboBox)this.value).getEditor().getItem().toString() : ((JTextField)this.value).getText();
            if (this.use_last_as_default) {
                lastValue.put(this.key, string);
            }
            if (string.equals(this.originalValue) || this.originalValue == null && string.length() == 0) {
                return;
            }
            if (this.delete_if_empty && string.length() == 0) {
                string = null;
            }
            list.add(new Tag(this.key, string));
        }

        @Override
        boolean requestFocusInWindow() {
            return this.value.requestFocusInWindow();
        }
    }

    public static class Usage {
        TreeSet<String> values;
        boolean hadKeys = false;
        boolean hadEmpty = false;

        public boolean hasUniqueValue() {
            return this.values.size() == 1 && !this.hadEmpty;
        }

        public boolean unused() {
            return this.values.size() == 0;
        }

        public String getFirst() {
            return this.values.first();
        }

        public boolean hadKeys() {
            return this.hadKeys;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Item {
        protected void initAutoCompletionField(AutoCompletingTextField autoCompletingTextField, String string) {
            OsmDataLayer osmDataLayer = Main.main.getEditLayer();
            if (osmDataLayer == null) {
                return;
            }
            AutoCompletionList autoCompletionList = new AutoCompletionList();
            Main.main.getEditLayer().data.getAutoCompletionManager().populateWithTagValues(autoCompletionList, string);
            autoCompletingTextField.setAutoCompletionList(autoCompletionList);
        }

        abstract boolean addToPanel(JPanel var1, Collection<OsmPrimitive> var2);

        abstract void addCommands(List<Tag> var1);

        boolean requestFocusInWindow() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PresetType {
        NODE("Mf_node"),
        WAY("Mf_way"),
        RELATION("Mf_relation"),
        CLOSEDWAY("Mf_closedway");

        private final String iconName;

        private PresetType(String string2) {
            this.iconName = string2;
        }

        public String getIconName() {
            return this.iconName;
        }

        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

