/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileImporter
implements Comparable<FileImporter> {
    public final ExtensionFileFilter filter;

    public FileImporter(ExtensionFileFilter extensionFileFilter) {
        this.filter = extensionFileFilter;
    }

    public boolean acceptFile(File file) {
        return this.filter.acceptName(file.getName());
    }

    public boolean isBatchImporter() {
        return false;
    }

    public void importData(File file, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import ''{0}''.", file.getName()));
    }

    public void importData(List<File> list, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        throw new IOException(I18n.tr("Could not import files."));
    }

    public boolean importDataHandleExceptions(File file, ProgressMonitor progressMonitor) {
        try {
            System.out.println("Open file: " + file.getAbsolutePath() + " (" + file.length() + " bytes)");
            this.importData(file, progressMonitor);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not read file ''{0}''.<br>Error is:<br>{1}</html>", file.getName(), exception.getMessage()), I18n.tr("Error"), 0, null);
            return false;
        }
    }

    public boolean importDataHandleExceptions(List<File> list, ProgressMonitor progressMonitor) {
        try {
            System.out.println("Open " + list.size() + " files");
            this.importData(list, progressMonitor);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not read files.<br>Error is:<br>{0}</html>", exception.getMessage()), I18n.tr("Error"), 0, null);
            return false;
        }
    }

    public double getPriority() {
        return 0.0;
    }

    @Override
    public int compareTo(FileImporter fileImporter) {
        return new Double(this.getPriority()).compareTo(fileImporter.getPriority());
    }
}

