/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.imagery.WMSGrabber;

public class HTMLGrabber
extends WMSGrabber {
    public static final StringProperty PROP_BROWSER = new StringProperty("imagery.wms.browser", "webkit-image {0}");

    public HTMLGrabber(MapView mapView, WMSLayer wMSLayer) {
        super(mapView, wMSLayer);
    }

    protected BufferedImage grab(URL uRL, int n) throws IOException {
        Process process;
        String string = uRL.toExternalForm();
        System.out.println("Grabbing HTML " + (n > 1 ? "(attempt " + n + ") " : "") + uRL);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(MessageFormat.format(PROP_BROWSER.get(), string));
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            throw new IOException("Could not start browser. Please check that the executable path is correct.\n" + iOException.getMessage());
        }
        BufferedImage bufferedImage = ImageIO.read(process.getInputStream());
        cache.saveImg(string, bufferedImage);
        return bufferedImage;
    }
}

