/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;

public class FullscreenToggleAction
extends JosmAction {
    private final List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();
    private boolean selected;
    private GraphicsDevice gd;
    private Rectangle prevBounds;

    public FullscreenToggleAction() {
        super(I18n.tr("Fullscreen View"), null, I18n.tr("Toggle fullscreen view"), Shortcut.registerShortcut("menu:view:fullscreen", I18n.tr("Toggle Fullscreen view"), 122, 5), true);
        this.putValue("help", HelpUtil.ht("/Action/FullscreenView"));
        this.gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.selected = Main.pref.getBoolean("draw.fullscreen", false);
        this.notifySelectedState();
    }

    public boolean canFullscreen() {
        return Main.platform instanceof PlatformHookUnixoid && this.gd.isFullScreenSupported();
    }

    public void addButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && !this.buttonModels.contains(buttonModel)) {
            this.buttonModels.add(buttonModel);
        }
    }

    public void removeButtonModel(ButtonModel buttonModel) {
        if (buttonModel != null && this.buttonModels.contains(buttonModel)) {
            this.buttonModels.remove(buttonModel);
        }
    }

    protected void notifySelectedState() {
        for (ButtonModel buttonModel : this.buttonModels) {
            if (buttonModel.isSelected() == this.selected) continue;
            buttonModel.setSelected(this.selected);
        }
    }

    protected void toggleSelectedState() {
        this.selected = !this.selected;
        Main.pref.put("draw.fullscreen", this.selected);
        this.notifySelectedState();
        Frame frame = (Frame)Main.parent;
        ArrayList<Window> arrayList = new ArrayList<Window>();
        arrayList.add(frame);
        Object object = Frame.getWindows();
        int n = ((Window[])object).length;
        for (int i = 0; i < n; ++i) {
            Window window = object[i];
            if (!window.isVisible() || window == frame) continue;
            arrayList.add(window);
        }
        frame.dispose();
        frame.setUndecorated(this.selected);
        if (this.selected) {
            this.prevBounds = frame.getBounds();
            frame.setBounds(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        }
        if ("true".equals(object = Main.pref.get("draw.fullscreen.exclusive-mode", "auto")) || "auto".equals(object) && !(Main.platform instanceof PlatformHookWindows)) {
            this.gd.setFullScreenWindow(this.selected ? frame : null);
        }
        if (!this.selected && this.prevBounds != null) {
            frame.setBounds(this.prevBounds);
        }
        for (Window window : arrayList) {
            window.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState();
    }
}

