/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeNodesAction
extends JosmAction {
    public MergeNodesAction() {
        super(I18n.tr("Merge Nodes"), "mergenodes", I18n.tr("Merge nodes into the oldest one."), Shortcut.registerShortcut("tools:mergenodes", I18n.tr("Tool: {0}", I18n.tr("Merge Nodes")), 77, 3), true);
        this.putValue("help", HelpUtil.ht("/Action/MergeNodes"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List<Node> list;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = MergeNodesAction.getCurrentDataSet().getSelected();
        List<Node> list2 = OsmPrimitive.getFilteredList(collection, Node.class);
        if (list2.size() == 1) {
            list = Main.map.mapView.getNearestNodes(Main.map.mapView.getPoint(list2.get(0)), list2, OsmPrimitive.isUsablePredicate);
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least two nodes to merge or node that is close to another node."), I18n.tr("Warning"), 2);
                return;
            }
            list2.addAll((Collection<Node>)list);
        }
        list = MergeNodesAction.selectTargetNode(list2);
        Node node = MergeNodesAction.selectTargetLocationNode(list2);
        Command command = MergeNodesAction.mergeNodes(Main.main.getEditLayer(), list2, (Node)((Object)list), node);
        if (command != null) {
            Main.main.undoRedo.add(command);
            Main.main.getEditLayer().data.setSelected(new PrimitiveId[]{list});
        }
    }

    public static Node selectTargetLocationNode(List<Node> list) {
        if (!Main.pref.getBoolean("merge-nodes.average-location", false)) {
            Node node = null;
            Iterator<Node> iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node2;
                node = node2 = iterator.next();
            }
            return node;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (Node node : list) {
            d += node.getCoor().lat();
            d2 += node.getCoor().lon();
        }
        return new Node(new LatLon(d / (double)list.size(), d2 / (double)list.size()));
    }

    public static Node selectTargetNode(List<Node> list) {
        Node node = null;
        Node node2 = null;
        for (Node node3 : list) {
            if (!node3.isNew()) {
                if (node == null) {
                    node = node3;
                } else if (node3.getId() < node.getId()) {
                    node = node3;
                }
            }
            node2 = node3;
        }
        if (node == null) {
            node = node2;
        }
        return node;
    }

    protected static List<Command> fixParentWays(Collection<Node> collection, Node node) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (Way way : OsmPrimitive.getFilteredList(OsmPrimitive.getReferrer(collection), Way.class)) {
            ArrayList<Node> arrayList2 = new ArrayList<Node>(way.getNodesCount());
            for (Node node2 : way.getNodes()) {
                if (!collection.contains(node2) && node2 != node) {
                    arrayList2.add(node2);
                    continue;
                }
                if (arrayList2.isEmpty()) {
                    arrayList2.add(node);
                    continue;
                }
                if (arrayList2.get(arrayList2.size() - 1) == node) continue;
                arrayList2.add(node);
            }
            if (arrayList2.size() < 2) {
                if (way.getReferrers().isEmpty()) {
                    hashSet.add(way);
                    continue;
                }
                HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Abort Merging"), ImageProvider.get("cancel"), I18n.tr("Click to abort merging nodes"), null)};
                HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("Cannot merge nodes: Would have to delete way ''{0}'' which is still used.", way.getDisplayName(DefaultNameFormatter.getInstance())), I18n.tr("Warning"), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Action/MergeNodes#WaysToDeleteStillInUse"));
                return null;
            }
            if (arrayList2.size() < 2 && way.getReferrers().isEmpty()) {
                hashSet.add(way);
                continue;
            }
            arrayList.add(new ChangeNodesCommand(way, arrayList2));
        }
        if (!hashSet.isEmpty()) {
            arrayList.add(new DeleteCommand(hashSet));
        }
        return arrayList;
    }

    public static Command mergeNodes(OsmDataLayer osmDataLayer, Collection<Node> collection, Node node) {
        return MergeNodesAction.mergeNodes(osmDataLayer, collection, node, node);
    }

    public static Command mergeNodes(OsmDataLayer osmDataLayer, Collection<Node> collection, Node node, Node node2) {
        Object object;
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        CheckParameterUtil.ensureParameterNotNull(node, "targetNode");
        if (collection == null) {
            return null;
        }
        Set<RelationToChildReference> set = RelationToChildReference.getRelationToChildReferences(collection);
        TagCollection tagCollection = TagCollection.unionOfAllPrimitives(collection);
        TagConflictResolutionUtil.combineTigerTags(tagCollection);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing(tagCollection, collection);
        TagCollection tagCollection2 = new TagCollection(tagCollection);
        TagConflictResolutionUtil.completeTagCollectionForEditing(tagCollection2);
        CombinePrimitiveResolverDialog combinePrimitiveResolverDialog = CombinePrimitiveResolverDialog.getInstance();
        combinePrimitiveResolverDialog.getTagConflictResolverModel().populate(tagCollection2, tagCollection.getKeysWithMultipleValues());
        combinePrimitiveResolverDialog.getRelationMemberConflictResolverModel().populate(set);
        combinePrimitiveResolverDialog.setTargetPrimitive(node);
        combinePrimitiveResolverDialog.prepareDefaultDecisions();
        if (!tagCollection.isApplicableToPrimitive() || set.size() > 1) {
            combinePrimitiveResolverDialog.setVisible(true);
            if (combinePrimitiveResolverDialog.isCancelled()) {
                return null;
            }
        }
        LinkedList<Command> linkedList = new LinkedList<Command>();
        HashSet<Node> hashSet = new HashSet<Node>(collection);
        hashSet.remove(node);
        HashSet hashSet2 = new HashSet();
        List<Command> list = MergeNodesAction.fixParentWays(hashSet, node);
        if (list == null) {
            return null;
        }
        linkedList.addAll(list);
        if (node != node2) {
            object = new Node(node);
            ((Node)object).setCoor(node2.getCoor());
            linkedList.add(new ChangeCommand(node, (OsmPrimitive)object));
        }
        linkedList.addAll(combinePrimitiveResolverDialog.buildResolutionCommands());
        if (!hashSet.isEmpty()) {
            linkedList.add(new DeleteCommand(hashSet));
        }
        if (!hashSet2.isEmpty()) {
            linkedList.add(new DeleteCommand(hashSet2));
        }
        object = new SequenceCommand(I18n.tr("Merge {0} nodes", collection.size()), linkedList);
        return object;
    }

    @Override
    protected void updateEnabledState() {
        if (MergeNodesAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(MergeNodesAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean bl = true;
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) continue;
            bl = false;
            break;
        }
        this.setEnabled(bl);
    }
}

