/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.AgregatePrimitivesVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class ValidateAction
extends JosmAction {
    private static final long serialVersionUID = -2304521273582574603L;
    private Collection<OsmPrimitive> lastSelection;

    public ValidateAction() {
        super(I18n.tr("Validation"), "dialogs/validator", I18n.tr("Performs the data validation"), Shortcut.registerShortcut("tools:validate", I18n.tr("Tool: {0}", I18n.tr("Validation")), 86, 3, 1), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doValidate(actionEvent, true);
    }

    public void doValidate(ActionEvent actionEvent, boolean bl) {
        Object object;
        Collection<OsmPrimitive> collection;
        if (Main.main.validator.validateAction == null || Main.map == null || !Main.map.isVisible()) {
            return;
        }
        OsmValidator.initializeErrorLayer();
        Collection<Test> collection2 = OsmValidator.getEnabledTests(false);
        if (collection2.isEmpty()) {
            return;
        }
        if (bl) {
            collection = Main.main.getCurrentDataSet().getSelected();
            if (collection.isEmpty()) {
                collection = Main.main.getCurrentDataSet().allNonDeletedPrimitives();
                this.lastSelection = null;
            } else {
                object = new AgregatePrimitivesVisitor();
                collection = ((AgregatePrimitivesVisitor)object).visit(collection);
                this.lastSelection = collection;
            }
        } else {
            collection = this.lastSelection == null ? Main.main.getCurrentDataSet().allNonDeletedPrimitives() : this.lastSelection;
        }
        object = new ValidationTask(collection2, collection, this.lastSelection);
        Main.worker.submit((Runnable)object);
    }

    public void updateEnabledState() {
        this.setEnabled(ValidateAction.getEditLayer() != null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValidationTask
    extends PleaseWaitRunnable {
        private Collection<Test> tests;
        private Collection<OsmPrimitive> validatedPrimitmives;
        private Collection<OsmPrimitive> formerValidatedPrimitives;
        private boolean canceled;
        private List<TestError> errors;

        public ValidationTask(Collection<Test> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
            super(I18n.tr("Validating"), false);
            this.validatedPrimitmives = collection2;
            this.formerValidatedPrimitives = collection3;
            this.tests = collection;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    Main.map.validatorDialog.tree.setErrors(ValidationTask.this.errors);
                    Main.map.validatorDialog.unfurlDialog();
                    Main.main.getCurrentDataSet().fireSelectionChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.tests == null || this.tests.isEmpty()) {
                return;
            }
            this.errors = new ArrayList<TestError>(200);
            this.getProgressMonitor().setTicksCount(this.tests.size() * this.validatedPrimitmives.size());
            int n = 0;
            for (Test object : this.tests) {
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().setCustomText(I18n.tr("Test {0}/{1}: Starting {2}", ++n, this.tests.size(), object.getName()));
                object.setPartialSelection(this.formerValidatedPrimitives != null);
                object.startTest(this.getProgressMonitor().createSubTaskMonitor(this.validatedPrimitmives.size(), false));
                object.visit(this.validatedPrimitmives);
                object.endTest();
                this.errors.addAll(object.getErrors());
            }
            this.tests = null;
            if (Main.pref.getBoolean("validator.ignore", true)) {
                this.getProgressMonitor().subTask(I18n.tr("Updating ignored errors ..."));
                for (TestError testError : this.errors) {
                    if (this.canceled) {
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(testError.getIgnoreState());
                    arrayList.add(testError.getIgnoreGroup());
                    arrayList.add(testError.getIgnoreSubGroup());
                    for (String string : arrayList) {
                        if (string == null || !OsmValidator.hasIgnoredError(string)) continue;
                        testError.setIgnored(true);
                    }
                }
            }
        }
    }
}

