/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.io.MirroredInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User {
    private static AtomicLong uidCounter = new AtomicLong();
    private static HashMap<Long, User> userMap = new HashMap();
    private static HashSet<Long> relicensingUsers = null;
    private final HashSet<String> names = new HashSet();
    private final long uid;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_AGREED = 1;
    public static final int STATUS_NOT_AGREED = 2;
    public static final int STATUS_AUTO_AGREED = 3;

    private static long getNextLocalUid() {
        return uidCounter.decrementAndGet();
    }

    public static User createLocalUser(String string) {
        for (long i = -1L; i >= uidCounter.get(); --i) {
            User user = User.getById(i);
            if (user == null || !user.hasName(string)) continue;
            return user;
        }
        User user = new User(User.getNextLocalUid(), string);
        userMap.put(user.getId(), user);
        return user;
    }

    public static User createOsmUser(long l, String string) {
        User user = userMap.get(l);
        if (user == null) {
            user = new User(l, string);
            userMap.put(user.getId(), user);
        }
        user.addName(string);
        return user;
    }

    public static void clearUserMap() {
        userMap.clear();
    }

    public static User getById(long l) {
        return userMap.get(l);
    }

    public static List<User> getByName(String string) {
        if (string == null) {
            string = "";
        }
        ArrayList<User> arrayList = new ArrayList<User>();
        for (User user : userMap.values()) {
            if (!user.hasName(string)) continue;
            arrayList.add(user);
        }
        return arrayList;
    }

    public static void loadRelicensingInformation() {
        relicensingUsers = new HashSet();
        try {
            String string;
            MirroredInputStream mirroredInputStream = new MirroredInputStream("http://planet.openstreetmap.org/users_agreed/users_agreed.txt", 7200L);
            InputStreamReader inputStreamReader = new InputStreamReader(mirroredInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("#")) continue;
                try {
                    relicensingUsers.add(new Long(Long.parseLong(string.trim())));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            mirroredInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getRelicensingStatus() {
        if (this.uid >= 286582L) {
            return 3;
        }
        if (relicensingUsers == null) {
            return 0;
        }
        return relicensingUsers.contains(new Long(this.uid)) ? 1 : 2;
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.names) {
            stringBuilder.append(string);
            stringBuilder.append('/');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public ArrayList<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public void addName(String string) {
        this.names.add(string);
    }

    public boolean hasName(String string) {
        return this.names.contains(string);
    }

    public long getId() {
        return this.uid;
    }

    private User(long l, String string) {
        this.uid = l;
        if (string != null) {
            this.addName(string);
        }
    }

    public boolean isOsmUser() {
        return this.uid > 0L;
    }

    public boolean isLocalUser() {
        return this.uid < 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.getName().hashCode();
        n = 31 * n + (int)(this.uid ^ this.uid >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return this.uid == user.uid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("id:" + this.uid);
        if (this.names.size() == 1) {
            stringBuffer.append(" name:" + this.getName());
        } else if (this.names.size() > 1) {
            stringBuffer.append(String.format(" %d names:%s", this.names.size(), this.getName()));
        }
        return stringBuffer.toString();
    }
}

