/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintVisitor;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.LineElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.Pair;

public class MapPaintVisitor
implements PaintVisitor {
    private Graphics2D g;
    private boolean inactive;
    private NavigatableComponent nc;
    private ElemStyles styles;
    private double circum;
    private MapPainter painter;
    private MapPaintSettings paintSettings;
    private DataSet data;
    private static final Comparator<Pair<ElemStyle, OsmPrimitive>> STYLE_COMPARATOR = new Comparator<Pair<ElemStyle, OsmPrimitive>>(){

        @Override
        public int compare(Pair<ElemStyle, OsmPrimitive> pair, Pair<ElemStyle, OsmPrimitive> pair2) {
            int n = Float.compare(((ElemStyle)pair.a).z_index, ((ElemStyle)pair2.a).z_index);
            if (n != 0) {
                return n;
            }
            if (pair.a == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && pair2.a != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return 1;
            }
            if (pair.a != NodeElemStyle.SIMPLE_NODE_ELEMSTYLE && pair2.a == NodeElemStyle.SIMPLE_NODE_ELEMSTYLE) {
                return -1;
            }
            long l = ((OsmPrimitive)pair.b).getUniqueId() - ((OsmPrimitive)pair2.b).getUniqueId();
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return Float.compare(((ElemStyle)pair.a).object_z_index, ((ElemStyle)pair2.a).object_z_index);
        }
    };

    public void visitAll(DataSet dataSet, boolean bl, Bounds bounds) {
        BBox bBox = new BBox(bounds);
        this.data = dataSet;
        this.styles = MapPaintStyles.getStyles();
        this.paintSettings = MapPaintSettings.INSTANCE;
        this.circum = this.nc.getDist100Pixel();
        boolean bl2 = this.circum <= (double)Main.pref.getInteger("mappaint.fillareas", 10000000) && !this.paintSettings.isOutlineOnly();
        boolean bl3 = bl2 && Main.pref.getBoolean("mappaint.multipolygon", true);
        this.styles.setDrawMultipolygon(bl3);
        boolean bl4 = Main.pref.getBoolean("mappaint.restriction", true);
        boolean bl5 = Main.pref.getBoolean("mappaint.lefthandtraffic", false);
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Main.pref.getBoolean("mappaint.use-antialiasing", true) ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.painter = new MapPainter(this.paintSettings, this.g, this.inactive, this.nc, bl, this.circum, bl5);
        StyleCollector styleCollector = new StyleCollector(LineElemStyle.class);
        StyleCollector styleCollector2 = new StyleCollector(LineElemStyle.class);
        StyleCollector styleCollector3 = new StyleCollector(AreaElemStyle.class);
        StyleCollector styleCollector4 = new StyleCollector(LineElemStyle.class);
        styleCollector4.setMemberSelected(true);
        StyleCollector styleCollector5 = new StyleCollector(AreaElemStyle.class);
        StyleCollector styleCollector6 = new StyleCollector(LineElemStyle.class);
        for (Way object22 : dataSet.searchWays(bBox)) {
            if (!object22.isDrawable()) continue;
            if (object22.isDisabled()) {
                styleCollector.add(object22);
                continue;
            }
            if (object22.isSelected()) {
                styleCollector2.add(object22);
                if (!bl2) continue;
                styleCollector3.add(object22);
                continue;
            }
            if (object22.isMemberOfSelected()) {
                styleCollector4.add(object22);
                if (!bl2) continue;
                styleCollector5.add(object22);
                continue;
            }
            styleCollector6.add(object22);
            if (!bl2) continue;
            styleCollector5.add(object22);
        }
        styleCollector.drawAll();
        styleCollector = null;
        Object object3 = new StyleCollector(NodeElemStyle.class);
        StyleCollector styleCollector7 = new StyleCollector(NodeElemStyle.class);
        StyleCollector styleCollector8 = new StyleCollector(NodeElemStyle.class);
        styleCollector8.setMemberSelected(true);
        StyleCollector styleCollector9 = new StyleCollector(NodeElemStyle.class);
        for (Node node : dataSet.searchNodes(bBox)) {
            if (!node.isDrawable()) continue;
            if (node.isDisabled()) {
                ((StyleCollector)object3).add(node);
                continue;
            }
            if (node.isSelected()) {
                styleCollector7.add(node);
                continue;
            }
            if (node.isMemberOfSelected()) {
                styleCollector8.add(node);
                continue;
            }
            styleCollector9.add(node);
        }
        ((StyleCollector)object3).drawAll();
        object3 = null;
        Object object = new StyleCollector(NodeElemStyle.class);
        StyleCollector styleCollector10 = new StyleCollector(NodeElemStyle.class);
        StyleCollector styleCollector11 = new StyleCollector(NodeElemStyle.class);
        for (Relation relation : dataSet.searchRelations(bBox)) {
            if (!relation.isDrawable()) continue;
            if (relation.isDisabled()) {
                if (!bl4) continue;
                ((StyleCollector)object).add(relation);
                continue;
            }
            if (relation.isSelected()) {
                if (bl3) {
                    styleCollector3.add(relation);
                }
                if (!bl4) continue;
                styleCollector11.add(relation);
                continue;
            }
            if (bl3) {
                styleCollector5.add(relation);
            }
            if (!bl4) continue;
            styleCollector10.add(relation);
        }
        ((StyleCollector)object).drawAll();
        object = null;
        styleCollector5.drawAll();
        styleCollector3.drawAll();
        styleCollector6.drawAll();
        styleCollector4.drawAll();
        styleCollector2.drawAll();
        styleCollector9.drawAll();
        styleCollector10.drawAll();
        styleCollector8.drawAll();
        styleCollector11.drawAll();
        styleCollector7.drawAll();
        this.painter.drawVirtualNodes(dataSet.searchWays(bBox));
    }

    public void setGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    public void setInactive(boolean bl) {
        this.inactive = bl;
    }

    public void setNavigatableComponent(NavigatableComponent navigatableComponent) {
        this.nc = navigatableComponent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StyleCollector {
        private List<Pair<ElemStyle, OsmPrimitive>> styleElems = new ArrayList<Pair<ElemStyle, OsmPrimitive>>();
        protected boolean memberSelected = false;
        private Class klass;

        public StyleCollector(Class<?> clazz) {
            this.klass = clazz;
        }

        public void add(OsmPrimitive osmPrimitive) {
            StyleCache.StyleList styleList = MapPaintVisitor.this.styles.get(osmPrimitive, MapPaintVisitor.this.circum, MapPaintVisitor.this.nc);
            for (ElemStyle elemStyle : styleList) {
                if (!this.klass.isInstance(elemStyle)) continue;
                this.styleElems.add(new Pair<ElemStyle, OsmPrimitive>(elemStyle, osmPrimitive));
            }
        }

        public void drawAll() {
            Collections.sort(this.styleElems, STYLE_COMPARATOR);
            for (Pair<ElemStyle, OsmPrimitive> pair : this.styleElems) {
                ((ElemStyle)pair.a).paintPrimitive((OsmPrimitive)pair.b, MapPaintVisitor.this.paintSettings, MapPaintVisitor.this.painter, MapPaintVisitor.this.data.isSelected((OsmPrimitive)pair.b), this.memberSelected);
            }
        }

        public boolean isMemberSelected() {
            return this.memberSelected;
        }

        public void setMemberSelected(boolean bl) {
            this.memberSelected = bl;
        }
    }
}

