/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;

class MapSlider
extends JSlider
implements PropertyChangeListener,
ChangeListener,
Helpful {
    private final MapView mv;
    boolean preventChange = false;

    public MapSlider(MapView mapView) {
        super(35, 150);
        this.setOpaque(false);
        this.mv = mapView;
        mapView.addPropertyChangeListener("scale", this);
        this.addChangeListener(this);
        this.propertyChange(null);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        int n;
        if (this.getModel().getValueIsAdjusting()) {
            return;
        }
        ProjectionBounds projectionBounds = this.mv.getMaxProjectionBounds();
        ProjectionBounds projectionBounds2 = this.mv.getProjectionBounds();
        double d = projectionBounds2.max.east() - projectionBounds2.min.east();
        double d2 = projectionBounds2.max.north() - projectionBounds2.min.north();
        double d3 = projectionBounds.max.east() - projectionBounds.min.east();
        double d4 = projectionBounds.max.north() - projectionBounds.min.north();
        for (n = 0; n <= 150; ++n) {
            if ((d3 /= 1.1) < d && (d4 /= 1.1) < d2) break;
        }
        this.preventChange = true;
        this.setValue(n);
        this.preventChange = false;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.preventChange) {
            return;
        }
        ProjectionBounds projectionBounds = this.mv.getMaxProjectionBounds();
        double d = Math.pow(1.1, this.getValue());
        double d2 = projectionBounds.max.east() - projectionBounds.min.east();
        double d3 = projectionBounds.max.north() - projectionBounds.min.north();
        this.mv.zoomTo(new ProjectionBounds(this.mv.getCenter(), d2 / d, d3 / d));
    }

    public String helpTopic() {
        return HelpUtil.ht("/MapView/Slider");
    }
}

