/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NodeListTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_EMPTY_ROW = new Color(234, 234, 234);
    public static final Color BGCOLOR_NOT_IN_OPPOSITE = new Color(255, 197, 197);
    public static final Color BGCOLOR_IN_OPPOSITE = new Color(255, 234, 213);
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    private ImageIcon nodeIcon;

    public NodeListTableCellRenderer() {
        this.setOpaque(true);
        this.nodeIcon = ImageProvider.get("data", "node");
        this.setIcon(this.nodeIcon);
    }

    protected void renderNode(HistoryBrowserModel.NodeListTableModel nodeListTableModel, Long l, int n, boolean bl) {
        String string = "";
        Color color = Color.WHITE;
        if (l == null) {
            string = "";
            color = BGCOLOR_EMPTY_ROW;
            this.setIcon(null);
        } else {
            string = I18n.tr("Node {0}", l.toString());
            this.setIcon(this.nodeIcon);
            color = nodeListTableModel.isSameInOppositeWay(n) ? Color.WHITE : (nodeListTableModel.isInOppositeWay(n) ? BGCOLOR_IN_OPPOSITE : BGCOLOR_NOT_IN_OPPOSITE);
        }
        if (bl) {
            color = BGCOLOR_SELECTED;
        }
        this.setText(string);
        this.setBackground(color);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        HistoryBrowserModel.NodeListTableModel nodeListTableModel = this.getNodeListTableModel(jTable);
        Long l = (Long)object;
        this.renderNode(nodeListTableModel, l, n, bl);
        return this;
    }

    protected HistoryBrowserModel.NodeListTableModel getNodeListTableModel(JTable jTable) {
        return (HistoryBrowserModel.NodeListTableModel)jTable.getModel();
    }
}

