/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.Font;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class TextElement {
    public String textKey;
    public Font font;
    public int xOffset;
    public int yOffset;
    public Color color;

    public TextElement(String string, Font font, int n, int n2, Color color) {
        CheckParameterUtil.ensureParameterNotNull(font);
        CheckParameterUtil.ensureParameterNotNull(color);
        this.textKey = string;
        this.font = font;
        this.xOffset = n;
        this.yOffset = n2;
        this.color = color;
    }

    public static TextElement create(Cascade cascade, Color color) {
        String string = cascade.get("text", null, String.class);
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (!"auto".equalsIgnoreCase(string)) {
            string2 = string;
        }
        Font font = ElemStyle.getFont(cascade);
        float f = 0.0f;
        float f2 = 0.0f;
        float[] fArray = cascade.get("text-offset", null, float[].class);
        if (fArray != null) {
            if (fArray.length == 1) {
                f2 = fArray[0];
            } else if (fArray.length >= 2) {
                f = fArray[0];
                f2 = fArray[1];
            }
        }
        f = cascade.get("text-offset-x", Float.valueOf(f), Float.class).floatValue();
        f2 = cascade.get("text-offset-y", Float.valueOf(f2), Float.class).floatValue();
        Color color2 = cascade.get("text-color", color, Color.class);
        return new TextElement(string2, font, (int)f, -((int)f2), color2);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextElement textElement = (TextElement)object;
        return Utils.equal(this.textKey, textElement.textKey) && Utils.equal(this.font, textElement.font) && this.xOffset == textElement.xOffset && this.yOffset == textElement.yOffset && Utils.equal(this.color, textElement.color);
    }

    public int hashCode() {
        int n = 3;
        n = 79 * n + (this.textKey != null ? this.textKey.hashCode() : 0);
        n = 79 * n + this.font.hashCode();
        n = 79 * n + this.xOffset;
        n = 79 * n + this.yOffset;
        n = 79 * n + this.color.hashCode();
        return n;
    }

    public String getString(OsmPrimitive osmPrimitive, MapPainter mapPainter) {
        if (this.textKey == null) {
            return mapPainter.getAreaName(osmPrimitive);
        }
        return osmPrimitive.get(this.textKey);
    }
}

