/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Capabilities {
    private HashMap<String, HashMap<String, String>> capabilities;
    private ArrayList<String> imageryBlacklist;

    public Capabilities() {
        this.clear();
    }

    public boolean isDefined(String string, String string2) {
        if (!this.capabilities.containsKey(string)) {
            return false;
        }
        HashMap<String, String> hashMap = this.capabilities.get(string);
        if (hashMap == null) {
            return false;
        }
        return hashMap.get(string2) != null;
    }

    public String get(String string, String string2) {
        if (!this.capabilities.containsKey(string)) {
            return null;
        }
        HashMap<String, String> hashMap = this.capabilities.get(string);
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(string2);
    }

    public Double getDouble(String string, String string2) throws NumberFormatException {
        String string3 = this.get(string, string2);
        if (string3 == null) {
            return null;
        }
        return Double.parseDouble(string3);
    }

    public Long getLong(String string, String string2) {
        String string3 = this.get(string, string2);
        if (string3 == null) {
            return null;
        }
        return Long.parseLong(string3);
    }

    public void put(String string, String string2, String string3) {
        if (string.equals("blacklist")) {
            if (string2.equals("regex")) {
                this.imageryBlacklist.add(string3);
            }
        } else {
            HashMap<Object, Object> hashMap;
            if (!this.capabilities.containsKey(string)) {
                hashMap = new HashMap();
                this.capabilities.put(string, hashMap);
            }
            hashMap = this.capabilities.get(string);
            hashMap.put(string2, string3);
        }
    }

    public void clear() {
        this.capabilities = new HashMap();
        this.imageryBlacklist = new ArrayList();
    }

    public boolean supportsVersion(String string) {
        return this.get("version", "minimum").compareTo(string) <= 0 && this.get("version", "maximum").compareTo(string) >= 0;
    }

    public int getMaxChangesetSize() {
        String string = this.get("changesets", "maximum_elements");
        if (string == null) {
            return -1;
        }
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                System.err.println(I18n.tr("Warning: illegal value of attribute ''{0}'' of element ''{1}'' in server capabilities. Got ''{2}''", "changesets", "maximum_elements", n));
                return -1;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(I18n.tr("Warning: illegal value of attribute ''{0}'' of element ''{1}'' in server capabilities. Got ''{2}''", "changesets", "maximum_elements", string));
            return -1;
        }
    }

    public boolean isOnImageryBlacklist(String string) {
        for (String string2 : this.imageryBlacklist) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    public List<String> getImageryBlacklist() {
        return Collections.unmodifiableList(this.imageryBlacklist);
    }
}

