/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.CredentialsManagerException;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.io.auth.CredentialsManagerResponse;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.I18n;

public class OsmConnection {
    protected boolean cancel = false;
    protected HttpURLConnection activeConnection;
    protected OAuthParameters oauthParameters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.cancel = true;
        OsmConnection osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.setConnectTimeout(100);
                this.activeConnection.setReadTimeout(100);
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        osmConnection = this;
        synchronized (osmConnection) {
            if (this.activeConnection != null) {
                this.activeConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBasicAuthorizationHeader(HttpURLConnection httpURLConnection) throws OsmTransferException {
        CredentialsManagerResponse credentialsManagerResponse;
        Object object;
        CharsetEncoder charsetEncoder = Charset.forName("UTF-8").newEncoder();
        try {
            object = CredentialsManagerFactory.getCredentialManager();
            synchronized (object) {
                credentialsManagerResponse = CredentialsManagerFactory.getCredentialManager().getCredentials(Authenticator.RequestorType.SERVER, false);
            }
        }
        catch (CredentialsManagerException credentialsManagerException) {
            throw new OsmTransferException(credentialsManagerException);
        }
        if (credentialsManagerResponse == null) {
            String string = ":";
        } else {
            if (credentialsManagerResponse.isCanceled()) {
                this.cancel = true;
                return;
            }
            object = credentialsManagerResponse.getUsername() == null ? "" : credentialsManagerResponse.getUsername();
            String string = credentialsManagerResponse.getPassword() == null ? "" : String.valueOf(credentialsManagerResponse.getPassword());
            String string2 = (String)object + ":" + string;
            try {
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string2));
                httpURLConnection.addRequestProperty("Authorization", "Basic " + Base64.encode(byteBuffer));
            }
            catch (CharacterCodingException characterCodingException) {
                throw new OsmTransferException(characterCodingException);
            }
        }
    }

    protected void addOAuthAuthorizationHeader(HttpURLConnection httpURLConnection) throws OsmTransferException {
        if (this.oauthParameters == null) {
            this.oauthParameters = OAuthParameters.createFromPreferences(Main.pref);
        }
        OAuthConsumer oAuthConsumer = this.oauthParameters.buildConsumer();
        OAuthAccessTokenHolder oAuthAccessTokenHolder = OAuthAccessTokenHolder.getInstance();
        if (!oAuthAccessTokenHolder.containsAccessToken()) {
            throw new MissingOAuthAccessTokenException();
        }
        oAuthConsumer.setTokenWithSecret(oAuthAccessTokenHolder.getAccessTokenKey(), oAuthAccessTokenHolder.getAccessTokenSecret());
        try {
            oAuthConsumer.sign(httpURLConnection);
        }
        catch (OAuthException oAuthException) {
            throw new OsmTransferException(I18n.tr("Failed to sign a HTTP connection with an OAuth Authentication header"), oAuthException);
        }
    }

    protected void addAuth(HttpURLConnection httpURLConnection) throws OsmTransferException {
        String string = Main.pref.get("osm-server.auth-method", "basic");
        if (string.equals("basic")) {
            this.addBasicAuthorizationHeader(httpURLConnection);
        } else if (string.equals("oauth")) {
            this.addOAuthAuthorizationHeader(httpURLConnection);
        } else {
            String string2 = I18n.tr("Warning: unexpected value for preference ''{0}''. Got ''{1}''.", "osm-server.auth-method", string);
            System.err.println(string2);
            throw new OsmTransferException(string2);
        }
    }

    public boolean isCanceled() {
        return this.cancel;
    }

    static {
        try {
            HttpURLConnection.setFollowRedirects(true);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }
}

