/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddPrimitivesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class PasteAction
extends JosmAction
implements PrimitiveDeepCopy.PasteBufferChangedListener {
    public PasteAction() {
        super(I18n.tr("Paste"), "paste", I18n.tr("Paste contents of paste buffer."), Shortcut.registerShortcut("system:paste", I18n.tr("Edit: {0}", I18n.tr("Paste")), 86, 2), true);
        this.putValue("help", HelpUtil.ht("/Action/Paste"));
        Main.pasteBuffer.addPasteBufferChangedListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.pasteData(Main.pasteBuffer, Main.pasteSource, actionEvent);
    }

    public void pasteData(PrimitiveDeepCopy primitiveDeepCopy, Layer layer, ActionEvent actionEvent) {
        ArrayList<Long> arrayList;
        double d;
        double d2 = -1.0E100;
        double d3 = 1.0E100;
        double d4 = -1.0E100;
        double d5 = 1.0E100;
        boolean bl = false;
        for (PrimitiveData primitiveData : primitiveDeepCopy.getAll()) {
            if (primitiveData instanceof NodeData) {
                NodeData nodeData = (NodeData)primitiveData;
                d = nodeData.getEastNorth().east();
                double d6 = nodeData.getEastNorth().north();
                if (d > d2) {
                    d2 = d;
                }
                if (d < d3) {
                    d3 = d;
                }
                if (d6 > d4) {
                    d4 = d6;
                }
                if (d6 < d5) {
                    d5 = d6;
                }
            }
            if (!primitiveData.isIncomplete()) continue;
            bl = true;
        }
        if (bl && !this.confirmDeleteIncomplete()) {
            return;
        }
        EastNorth eastNorth = (actionEvent.getModifiers() & 2) == 0 ? Main.map.mapView.getCenter() : (Main.map.mapView.lastMEvent != null ? Main.map.mapView.getEastNorth(Main.map.mapView.lastMEvent.getX(), Main.map.mapView.lastMEvent.getY()) : Main.map.mapView.getCenter());
        double d7 = eastNorth.east() - (d2 + d3) / 2.0;
        d = eastNorth.north() - (d4 + d5) / 2.0;
        ArrayList<PrimitiveData> arrayList2 = new ArrayList<PrimitiveData>();
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
        HashMap<Long, Long> hashMap2 = new HashMap<Long, Long>();
        HashMap<Long, Long> hashMap3 = new HashMap<Long, Long>();
        for (PrimitiveData primitiveData : primitiveDeepCopy.getAll()) {
            if (primitiveData.isIncomplete()) continue;
            arrayList = primitiveData.makeCopy();
            ((PrimitiveData)((Object)arrayList)).clearOsmId();
            if (primitiveData instanceof NodeData) {
                hashMap.put(primitiveData.getUniqueId(), ((PrimitiveData)((Object)arrayList)).getUniqueId());
            } else if (primitiveData instanceof WayData) {
                hashMap2.put(primitiveData.getUniqueId(), ((PrimitiveData)((Object)arrayList)).getUniqueId());
            } else if (primitiveData instanceof RelationData) {
                hashMap3.put(primitiveData.getUniqueId(), ((PrimitiveData)((Object)arrayList)).getUniqueId());
            }
            arrayList2.add((PrimitiveData)((Object)arrayList));
        }
        for (PrimitiveData primitiveData : arrayList2) {
            Object object;
            if (primitiveData instanceof NodeData) {
                arrayList = (NodeData)primitiveData;
                if (Main.map.mapView.getEditLayer() != layer) continue;
                ((NodeData)((Object)arrayList)).setEastNorth(((NodeData)((Object)arrayList)).getEastNorth().add(d7, d));
                continue;
            }
            if (primitiveData instanceof WayData) {
                arrayList = new ArrayList();
                for (Long l : ((WayData)primitiveData).getNodes()) {
                    object = (Long)hashMap.get(l);
                    if (object == null) continue;
                    arrayList.add((Long)object);
                }
                ((WayData)primitiveData).setNodes(arrayList);
                continue;
            }
            if (!(primitiveData instanceof RelationData)) continue;
            arrayList = new ArrayList<Long>();
            for (RelationMemberData relationMemberData : ((RelationData)primitiveData).getMembers()) {
                object = relationMemberData.getMemberType();
                Long l = null;
                switch (1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[((Enum)object).ordinal()]) {
                    case 1: {
                        l = (Long)hashMap.get(relationMemberData.getMemberId());
                        break;
                    }
                    case 2: {
                        l = (Long)hashMap2.get(relationMemberData.getMemberId());
                        break;
                    }
                    case 3: {
                        l = (Long)hashMap3.get(relationMemberData.getMemberId());
                    }
                }
                if (l == null) continue;
                arrayList.add((Long)((Object)new RelationMemberData(relationMemberData.getRole(), (OsmPrimitiveType)((Object)object), l)));
            }
            ((RelationData)primitiveData).setMembers(arrayList);
        }
        Main.main.undoRedo.add(new AddPrimitivesCommand(arrayList2));
        Main.map.mapView.repaint();
    }

    protected boolean confirmDeleteIncomplete() {
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Delete incomplete members?"), new String[]{I18n.tr("Paste without incomplete members"), I18n.tr("Cancel")});
        extendedDialog.setButtonIcons(new String[]{"dialogs/relation/deletemembers.png", "cancel.png"});
        extendedDialog.setContent(I18n.tr("The copied data contains incomplete primitives.  When pasting the incomplete primitives are removed.  Do you want to paste the data without the incomplete primitives?"));
        extendedDialog.showDialog();
        return extendedDialog.getValue() == 1;
    }

    protected void updateEnabledState() {
        if (PasteAction.getCurrentDataSet() == null || Main.pasteBuffer == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!Main.pasteBuffer.isEmpty());
    }

    public void pasteBufferChanged(PrimitiveDeepCopy primitiveDeepCopy) {
        this.updateEnabledState();
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType;

        static {
            $SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType = new int[OsmPrimitiveType.values().length];
            try {
                1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[OsmPrimitiveType.NODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[OsmPrimitiveType.WAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$openstreetmap$josm$data$osm$OsmPrimitiveType[OsmPrimitiveType.RELATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

