/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OsmPrimitive
implements Comparable<OsmPrimitive>,
Tagged,
PrimitiveId {
    private static final AtomicLong idCounter;
    private static final int FLAG_MODIFIED = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_DISABLED = 4;
    private static final int FLAG_DELETED = 8;
    private static final int FLAG_HIDE_IF_DISABLED = 16;
    private static final int FLAG_HAS_DIRECTIONS = 32;
    private static final int FLAG_TAGGED = 64;
    private static final int FLAG_DIRECTION_REVERSED = 128;
    private static final int FLAG_HIGHLIGHTED = 256;
    private static final int FLAG_INCOMPLETE = 512;
    public static final Predicate<OsmPrimitive> isUsablePredicate;
    public static final Predicate<OsmPrimitive> isSelectablePredicate;
    public static final Predicate<OsmPrimitive> nonDeletedPredicate;
    public static final Predicate<OsmPrimitive> nonDeletedCompletePredicate;
    public static final Predicate<OsmPrimitive> nonDeletedPhysicalPredicate;
    public static final Predicate<OsmPrimitive> modifiedPredicate;
    public static final Predicate<OsmPrimitive> nodePredicate;
    public static final Predicate<OsmPrimitive> wayPredicate;
    public static final Predicate<OsmPrimitive> relationPredicate;
    public static final Predicate<OsmPrimitive> allPredicate;
    public StyleCache mappaintStyle = null;
    public int mappaintCacheIdx;
    private DataSet dataSet;
    private long id = 0L;
    private User user = null;
    private int version = 0;
    private int changesetId;
    private int timestamp;
    private volatile short flags = (short)2;
    private static volatile Collection<String> uninteresting;
    private static volatile SearchCompiler.Match directionKeys;
    private static volatile SearchCompiler.Match reversedDirectionKeys;
    private String[] keys;
    private Object referrers;

    static long generateUniqueId() {
        return idCounter.decrementAndGet();
    }

    public static <T extends OsmPrimitive> List<T> getFilteredList(Collection<OsmPrimitive> collection, Class<T> clazz) {
        if (collection == null) {
            return Collections.emptyList();
        }
        LinkedList<T> linkedList = new LinkedList<T>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!clazz.isInstance(osmPrimitive)) continue;
            linkedList.add(clazz.cast(osmPrimitive));
        }
        return linkedList;
    }

    public static <T extends OsmPrimitive> LinkedHashSet<T> getFilteredSet(Collection<OsmPrimitive> collection, Class<T> clazz) {
        LinkedHashSet<T> linkedHashSet = new LinkedHashSet<T>();
        if (collection != null) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!clazz.isInstance(osmPrimitive)) continue;
                linkedHashSet.add(clazz.cast(osmPrimitive));
            }
        }
        return linkedHashSet;
    }

    public static Set<OsmPrimitive> getReferrer(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (collection == null || collection.isEmpty()) {
            return hashSet;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            hashSet.addAll(osmPrimitive.getReferrers());
        }
        return hashSet;
    }

    protected OsmPrimitive(long l, boolean bl) throws IllegalArgumentException {
        if (bl) {
            this.id = l;
        } else {
            if (l < 0L) {
                throw new IllegalArgumentException(MessageFormat.format("Expected ID >= 0. Got {0}.", l));
            }
            this.id = l == 0L ? OsmPrimitive.generateUniqueId() : l;
        }
        this.version = 0;
        this.setIncomplete(l > 0L);
    }

    protected OsmPrimitive(long l, int n, boolean bl) throws IllegalArgumentException {
        this(l, bl);
        this.version = l > 0L ? n : 0;
        this.setIncomplete(l > 0L && n == 0);
    }

    public void clearCachedStyle() {
        this.mappaintStyle = null;
    }

    void setDataset(DataSet dataSet) {
        if (this.dataSet != null && dataSet != null && this.dataSet != dataSet) {
            throw new DataIntegrityProblemException("Primitive cannot be included in more than one Dataset");
        }
        this.dataSet = dataSet;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void checkDataset() {
        if (this.dataSet == null) {
            throw new DataIntegrityProblemException("Primitive  must be part of the dataset: " + this.toString());
        }
    }

    protected boolean writeLock() {
        if (this.dataSet != null) {
            this.dataSet.beginUpdate();
            return true;
        }
        return false;
    }

    protected void writeUnlock(boolean bl) {
        if (bl) {
            this.dataSet.endUpdate();
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getId() {
        long l = this.id;
        return l >= 0L ? l : 0L;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    public boolean isNewOrUndeleted() {
        return this.id <= 0L || (this.flags & 0xA) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOsmId(long l, int n) {
        boolean bl = this.writeLock();
        try {
            if (l <= 0L) {
                throw new IllegalArgumentException(I18n.tr("ID > 0 expected. Got {0}.", l));
            }
            if (n <= 0) {
                throw new IllegalArgumentException(I18n.tr("Version > 0 expected. Got {0}.", n));
            }
            if (this.dataSet != null && l != this.id) {
                DataSet dataSet = this.dataSet;
                dataSet.removePrimitive(this);
                this.id = l;
                dataSet.addPrimitive(this);
            }
            this.id = l;
            this.version = n;
            this.setIncomplete(false);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public void clearOsmId() {
        if (this.dataSet != null) {
            throw new DataIntegrityProblemException("Method cannot be called after primitive was added to the dataset");
        }
        this.id = OsmPrimitive.generateUniqueId();
        this.version = 0;
        this.changesetId = 0;
        this.setIncomplete(false);
    }

    public User getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(User user) {
        boolean bl = this.writeLock();
        try {
            this.user = user;
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public int getChangesetId() {
        return this.changesetId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangesetId(int n) throws IllegalStateException, IllegalArgumentException {
        boolean bl = this.writeLock();
        try {
            if (this.changesetId == n) {
                return;
            }
            if (n < 0) {
                throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' >= 0 expected, got {1}", "changesetId", n));
            }
            if (this.isNew() && n > 0) {
                throw new IllegalStateException(I18n.tr("Cannot assign a changesetId > 0 to a new primitive. Value of changesetId is {0}", n));
            }
            int n2 = this.changesetId;
            this.changesetId = n;
            if (this.dataSet != null) {
                this.dataSet.fireChangesetIdChanged(this, n2, n);
            }
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public PrimitiveId getPrimitiveId() {
        return new SimplePrimitiveId(this.getUniqueId(), this.getType());
    }

    public OsmPrimitiveType getDisplayType() {
        return this.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(Date date) {
        boolean bl = this.writeLock();
        try {
            this.timestamp = (int)(date.getTime() / 1000L);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public Date getTimestamp() {
        return new Date((long)this.timestamp * 1000L);
    }

    public boolean isTimestampEmpty() {
        return this.timestamp == 0;
    }

    private void updateFlagsNoLock(int n, boolean bl) {
        this.flags = bl ? (short)(this.flags | n) : (short)(this.flags & ~n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlags(int n, boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            this.updateFlagsNoLock(n, bl);
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDisabledState(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            short s = this.flags;
            this.updateFlagsNoLock(4, true);
            this.updateFlagsNoLock(16, bl);
            boolean bl3 = s != this.flags;
            return bl3;
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsetDisabledState() {
        boolean bl = this.writeLock();
        try {
            short s = this.flags;
            this.updateFlagsNoLock(20, false);
            boolean bl2 = s != this.flags;
            return bl2;
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public boolean isDisabled() {
        return (this.flags & 4) != 0;
    }

    public boolean isDisabledAndHidden() {
        return (this.flags & 4) != 0 && (this.flags & 0x10) != 0;
    }

    @Deprecated
    public boolean isFiltered() {
        return this.isDisabledAndHidden();
    }

    public void setModified(boolean bl) {
        this.updateFlags(1, bl);
    }

    public boolean isModified() {
        return (this.flags & 1) != 0;
    }

    public boolean isDeleted() {
        return (this.flags & 8) != 0;
    }

    public boolean isUndeleted() {
        return (this.flags & 0xA) == 0;
    }

    public boolean isUsable() {
        return (this.flags & 0x208) == 0;
    }

    public boolean isSelectable() {
        return (this.flags & 0x21C) == 0;
    }

    public boolean isDrawable() {
        return (this.flags & 0x218) == 0;
    }

    public boolean isVisible() {
        return (this.flags & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean bl) throws IllegalStateException {
        boolean bl2 = this.writeLock();
        try {
            if (this.isNew() && !bl) {
                throw new IllegalStateException(I18n.tr("A primitive with ID = 0 cannot be invisible."));
            }
            this.updateFlagsNoLock(2, bl);
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeleted(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            this.updateFlagsNoLock(8, bl);
            this.setModified(bl ^ !this.isVisible());
            if (this.dataSet != null) {
                if (bl) {
                    this.dataSet.firePrimitivesRemoved(Collections.singleton(this), false);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singleton(this), false);
                }
            }
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIncomplete(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            if (this.dataSet != null && bl != this.isIncomplete()) {
                if (bl) {
                    this.dataSet.firePrimitivesRemoved(Collections.singletonList(this), true);
                } else {
                    this.dataSet.firePrimitivesAdded(Collections.singletonList(this), true);
                }
            }
            this.updateFlagsNoLock(512, bl);
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    public boolean isIncomplete() {
        return (this.flags & 0x200) != 0;
    }

    public boolean isSelected() {
        return this.dataSet != null && this.dataSet.isSelected(this);
    }

    public boolean isMemberOfSelected() {
        if (this.referrers == null) {
            return false;
        }
        if (this.referrers instanceof OsmPrimitive) {
            return this.referrers instanceof Relation && ((OsmPrimitive)this.referrers).isSelected();
        }
        for (OsmPrimitive osmPrimitive : (OsmPrimitive[])this.referrers) {
            if (!(osmPrimitive instanceof Relation) || !osmPrimitive.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setHighlighted(boolean bl) {
        if (this.isHighlighted() != bl) {
            this.updateFlags(256, bl);
            if (this.dataSet != null) {
                this.dataSet.fireHighlightingChanged(this);
            }
        }
    }

    public boolean isHighlighted() {
        return (this.flags & 0x100) != 0;
    }

    public static Collection<String> getUninterestingKeys() {
        if (uninteresting == null) {
            uninteresting = Main.pref.getCollection("tags.uninteresting", Arrays.asList("source", "source_ref", "source:", "note", "comment", "converted_by", "created_by", "watch", "watch:", "fixme", "FIXME", "description", "attribution"));
        }
        return uninteresting;
    }

    public static boolean isUninterestingKey(String string) {
        OsmPrimitive.getUninterestingKeys();
        if (uninteresting.contains(string)) {
            return true;
        }
        int n = string.indexOf(58);
        if (n > 0) {
            return uninteresting.contains(string.substring(0, n + 1));
        }
        return false;
    }

    private void updateTagged() {
        if (this.keys != null) {
            for (String string : this.keySet()) {
                if (OsmPrimitive.isUninterestingKey(string)) continue;
                this.updateFlagsNoLock(64, true);
                return;
            }
        }
        this.updateFlagsNoLock(64, false);
    }

    public boolean isTagged() {
        return (this.flags & 0x40) != 0;
    }

    private void updateDirectionFlags() {
        boolean bl = false;
        boolean bl2 = false;
        if (reversedDirectionKeys.match(this)) {
            bl = true;
            bl2 = true;
        }
        if (directionKeys.match(this)) {
            bl = true;
        }
        this.updateFlagsNoLock(128, bl2);
        this.updateFlagsNoLock(32, bl);
    }

    public boolean hasDirectionKeys() {
        return (this.flags & 0x20) != 0;
    }

    public boolean reversedDirection() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public Map<String, String> getKeys() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = this.keys;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                hashMap.put(stringArray[i], stringArray[i + 1]);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeys(Map<String, String> map) {
        boolean bl = this.writeLock();
        try {
            Map<String, String> map2 = this.getKeys();
            if (map == null || map.isEmpty()) {
                this.keys = null;
                this.keysChangedImpl(map2);
                return;
            }
            String[] stringArray = new String[map.size() * 2];
            int n = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringArray[n++] = entry.getKey();
                stringArray[n++] = entry.getValue();
            }
            this.keys = stringArray;
            this.keysChangedImpl(map2);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(String string, String string2) {
        boolean bl = this.writeLock();
        try {
            Map<String, String> map = this.getKeys();
            if (string == null) {
                return;
            }
            if (string2 == null) {
                this.remove(string);
            } else if (this.keys == null) {
                this.keys = new String[]{string, string2};
                this.keysChangedImpl(map);
            } else {
                for (int i = 0; i < this.keys.length; i += 2) {
                    if (!this.keys[i].equals(string)) continue;
                    this.keys[i + 1] = string2;
                    this.keysChangedImpl(map);
                    return;
                }
                String[] stringArray = new String[this.keys.length + 2];
                for (int i = 0; i < this.keys.length; i += 2) {
                    stringArray[i] = this.keys[i];
                    stringArray[i + 1] = this.keys[i + 1];
                }
                stringArray[this.keys.length] = string;
                stringArray[this.keys.length + 1] = string2;
                this.keys = stringArray;
                this.keysChangedImpl(map);
            }
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remove(String string) {
        boolean bl = this.writeLock();
        try {
            if (string == null || this.keys == null) {
                return;
            }
            if (!this.hasKey(string)) {
                return;
            }
            Map<String, String> map = this.getKeys();
            if (this.keys.length == 2) {
                this.keys = null;
                this.keysChangedImpl(map);
                return;
            }
            String[] stringArray = new String[this.keys.length - 2];
            int n = 0;
            for (int i = 0; i < this.keys.length; i += 2) {
                if (this.keys[i].equals(string)) continue;
                stringArray[n++] = this.keys[i];
                stringArray[n++] = this.keys[i + 1];
            }
            this.keys = stringArray;
            this.keysChangedImpl(map);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeAll() {
        boolean bl = this.writeLock();
        try {
            if (this.keys != null) {
                Map<String, String> map = this.getKeys();
                this.keys = null;
                this.keysChangedImpl(map);
            }
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public final String get(String string) {
        String[] stringArray = this.keys;
        if (string == null) {
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    @Override
    public final Collection<String> keySet() {
        String[] stringArray = this.keys;
        if (stringArray == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length / 2);
        for (int i = 0; i < stringArray.length; i += 2) {
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    @Override
    public final boolean hasKeys() {
        return this.keys != null;
    }

    private void keysChangedImpl(Map<String, String> map) {
        this.clearCachedStyle();
        if (this.dataSet != null) {
            for (OsmPrimitive osmPrimitive : this.getReferrers()) {
                osmPrimitive.clearCachedStyle();
            }
        }
        this.updateDirectionFlags();
        this.updateTagged();
        if (this.dataSet != null) {
            this.dataSet.fireTagsChanged(this, map);
        }
    }

    public boolean hasKey(String string) {
        String[] stringArray = this.keys;
        if (string == null) {
            return false;
        }
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSameTags(OsmPrimitive osmPrimitive) {
        return ((Object)this.getKeys()).equals(osmPrimitive.getKeys());
    }

    protected void addReferrer(OsmPrimitive osmPrimitive) {
        if (this.referrers == null) {
            this.referrers = osmPrimitive;
        } else if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers != osmPrimitive) {
                this.referrers = new OsmPrimitive[]{(OsmPrimitive)this.referrers, osmPrimitive};
            }
        } else {
            for (OsmPrimitive osmPrimitive2 : (OsmPrimitive[])this.referrers) {
                if (osmPrimitive2 != osmPrimitive) continue;
                return;
            }
            OsmPrimitive[] osmPrimitiveArray = (OsmPrimitive[])this.referrers;
            OsmPrimitive[] osmPrimitiveArray2 = new OsmPrimitive[osmPrimitiveArray.length + 1];
            System.arraycopy(osmPrimitiveArray, 0, osmPrimitiveArray2, 0, osmPrimitiveArray.length);
            osmPrimitiveArray2[osmPrimitiveArray.length] = osmPrimitive;
            this.referrers = osmPrimitiveArray2;
        }
    }

    protected void removeReferrer(OsmPrimitive osmPrimitive) {
        if (this.referrers instanceof OsmPrimitive) {
            if (this.referrers == osmPrimitive) {
                this.referrers = null;
            }
        } else if (this.referrers instanceof OsmPrimitive[]) {
            OsmPrimitive[] osmPrimitiveArray = (OsmPrimitive[])this.referrers;
            int n = -1;
            for (int i = 0; i < osmPrimitiveArray.length; ++i) {
                if (osmPrimitiveArray[i] != osmPrimitive) continue;
                n = i;
                break;
            }
            if (n == -1) {
                return;
            }
            if (osmPrimitiveArray.length == 2) {
                this.referrers = osmPrimitiveArray[1 - n];
            } else {
                OsmPrimitive[] osmPrimitiveArray2 = new OsmPrimitive[osmPrimitiveArray.length - 1];
                System.arraycopy(osmPrimitiveArray, 0, osmPrimitiveArray2, 0, n);
                System.arraycopy(osmPrimitiveArray, n + 1, osmPrimitiveArray2, n, osmPrimitiveArray2.length - n);
                this.referrers = osmPrimitiveArray2;
            }
        }
    }

    public final List<OsmPrimitive> getReferrers() {
        this.checkDataset();
        Object object = this.referrers;
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
        if (object != null) {
            if (object instanceof OsmPrimitive) {
                OsmPrimitive osmPrimitive = (OsmPrimitive)object;
                if (osmPrimitive.dataSet == this.dataSet) {
                    arrayList.add(osmPrimitive);
                }
            } else {
                for (OsmPrimitive osmPrimitive : (OsmPrimitive[])object) {
                    if (this.dataSet != osmPrimitive.dataSet) continue;
                    arrayList.add(osmPrimitive);
                }
            }
        }
        return arrayList;
    }

    public final boolean isReferredByWays(int n) {
        Object object = this.referrers;
        if (object == null) {
            return false;
        }
        this.checkDataset();
        if (object instanceof OsmPrimitive) {
            return n <= 1 && object instanceof Way && ((OsmPrimitive)object).dataSet == this.dataSet;
        }
        int n2 = 0;
        for (OsmPrimitive osmPrimitive : (OsmPrimitive[])object) {
            if (this.dataSet != osmPrimitive.dataSet || !(osmPrimitive instanceof Way) || ++n2 < n) continue;
            return true;
        }
        return false;
    }

    public abstract void visit(Visitor var1);

    public void cloneFrom(OsmPrimitive osmPrimitive) {
        if (this.id != osmPrimitive.id && this.dataSet != null) {
            throw new DataIntegrityProblemException("Osm id cannot be changed after primitive was added to the dataset");
        }
        this.setKeys(osmPrimitive.getKeys());
        this.id = osmPrimitive.id;
        if (this.id <= 0L) {
            this.version = 0;
            this.changesetId = 0;
        }
        this.timestamp = osmPrimitive.timestamp;
        if (this.id > 0L) {
            this.version = osmPrimitive.version;
        }
        this.setIncomplete(osmPrimitive.isIncomplete());
        this.flags = osmPrimitive.flags;
        this.user = osmPrimitive.user;
        if (this.id > 0L && osmPrimitive.changesetId > 0) {
            this.setChangesetId(osmPrimitive.changesetId);
        }
        this.clearCachedStyle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            CheckParameterUtil.ensureParameterNotNull(osmPrimitive, "other");
            if (osmPrimitive.isNew() ^ this.isNew()) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge because either of the participating primitives is new and the other is not"));
            }
            if (!osmPrimitive.isNew() && osmPrimitive.getId() != this.id) {
                throw new DataIntegrityProblemException(I18n.tr("Cannot merge primitives with different ids. This id is {0}, the other is {1}", this.id, osmPrimitive.getId()));
            }
            this.setKeys(osmPrimitive.getKeys());
            this.timestamp = osmPrimitive.timestamp;
            this.version = osmPrimitive.version;
            this.setIncomplete(osmPrimitive.isIncomplete());
            this.flags = osmPrimitive.flags;
            this.user = osmPrimitive.user;
            this.changesetId = osmPrimitive.changesetId;
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (!this.isNew() && this.id != osmPrimitive.id) {
            return false;
        }
        if (this.isIncomplete() && !osmPrimitive.isIncomplete() || !this.isIncomplete() && osmPrimitive.isIncomplete()) {
            return false;
        }
        return this.hasSameTags(osmPrimitive);
    }

    public boolean hasEqualTechnicalAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            return false;
        }
        return this.isDeleted() == osmPrimitive.isDeleted() && this.isModified() == osmPrimitive.isModified() && this.timestamp == osmPrimitive.timestamp && this.version == osmPrimitive.version && this.isVisible() == osmPrimitive.isVisible() && (this.user == null ? osmPrimitive.user == null : this.user == osmPrimitive.user) && this.changesetId == osmPrimitive.changesetId;
    }

    public String getName() {
        return this.get("name");
    }

    public String getLocalName() {
        String string = "name:" + Locale.getDefault().toString();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        if (this.get(string) != null) {
            return this.get(string);
        }
        string = "name:" + Locale.getDefault().getLanguage();
        if (this.get(string) != null) {
            return this.get(string);
        }
        return this.getName();
    }

    public abstract String getDisplayName(NameFormatter var1);

    public void load(PrimitiveData primitiveData) {
        this.setKeys(primitiveData.getKeys());
        this.setTimestamp(primitiveData.getTimestamp());
        this.user = primitiveData.getUser();
        this.setChangesetId(primitiveData.getChangesetId());
        this.setDeleted(primitiveData.isDeleted());
        this.setModified(primitiveData.isModified());
        this.setIncomplete(primitiveData.isIncomplete());
        this.version = primitiveData.getVersion();
    }

    public abstract PrimitiveData save();

    protected void saveCommonAttributes(PrimitiveData primitiveData) {
        primitiveData.setId(this.id);
        primitiveData.getKeys().clear();
        primitiveData.getKeys().putAll(this.getKeys());
        primitiveData.setTimestamp(this.getTimestamp());
        primitiveData.setUser(this.user);
        primitiveData.setDeleted(this.isDeleted());
        primitiveData.setModified(this.isModified());
        primitiveData.setVisible(this.isVisible());
        primitiveData.setIncomplete(this.isIncomplete());
        primitiveData.setChangesetId(this.changesetId);
        primitiveData.setVersion(this.version);
    }

    public abstract BBox getBBox();

    public abstract void updatePosition();

    protected String getFlagsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isIncomplete()) {
            stringBuilder.append("I");
        }
        if (this.isModified()) {
            stringBuilder.append("M");
        }
        if (this.isVisible()) {
            stringBuilder.append("V");
        }
        if (this.isDeleted()) {
            stringBuilder.append("D");
        }
        if (this.isDisabled()) {
            if (this.isDisabledAndHidden()) {
                stringBuilder.append("h");
            } else {
                stringBuilder.append("d");
            }
        }
        if (this.isTagged()) {
            stringBuilder.append("T");
        }
        if (this.hasDirectionKeys()) {
            if (this.reversedDirection()) {
                stringBuilder.append("<");
            } else {
                stringBuilder.append(">");
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof OsmPrimitive) {
            return ((OsmPrimitive)object).id == this.id && object.getClass() == this.getClass();
        }
        return false;
    }

    public final int hashCode() {
        return (int)this.id;
    }

    static {
        CharSequence charSequence;
        Object object;
        idCounter = new AtomicLong(0L);
        isUsablePredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive.isUsable();
            }
        };
        isSelectablePredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive.isSelectable();
            }
        };
        nonDeletedPredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return !osmPrimitive.isDeleted();
            }
        };
        nonDeletedCompletePredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return !osmPrimitive.isDeleted() && !osmPrimitive.isIncomplete();
            }
        };
        nonDeletedPhysicalPredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return !osmPrimitive.isDeleted() && !osmPrimitive.isIncomplete() && !(osmPrimitive instanceof Relation);
            }
        };
        modifiedPredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive.isModified();
            }
        };
        nodePredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive.getClass() == Node.class;
            }
        };
        wayPredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive.getClass() == Way.class;
            }
        };
        relationPredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return osmPrimitive.getClass() == Relation.class;
            }
        };
        allPredicate = new Predicate<OsmPrimitive>(){

            @Override
            public boolean evaluate(OsmPrimitive osmPrimitive) {
                return true;
            }
        };
        uninteresting = null;
        directionKeys = null;
        reversedDirectionKeys = null;
        if (Main.pref.isCollection("tags.direction", false)) {
            System.out.println("Collection of keys in tags.direction is no longer supported, value will converted to search pattern");
            object = Main.pref.getCollection("tags.direction", null);
            charSequence = new StringBuilder();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ((StringBuilder)charSequence).append(string);
                ((StringBuilder)charSequence).append("=* | ");
            }
            ((StringBuilder)charSequence).delete(((StringBuilder)charSequence).length() - 3, ((StringBuilder)charSequence).length());
            Main.pref.put("tags.direction", ((StringBuilder)charSequence).toString());
        }
        object = "oneway=\"-1\" | incline=down | incline=\"-*\"";
        charSequence = "oneway? | incline=* | aerialway=* | waterway=stream | waterway=river | waterway=canal | waterway=drain | waterway=rapids | \"piste:type\"=downhill | \"piste:type\"=sled | man_made=\"piste:halfpipe\" | junction=roundabout";
        try {
            reversedDirectionKeys = SearchCompiler.compile(Main.pref.get("tags.reversed_direction", (String)object), false, false);
        }
        catch (SearchCompiler.ParseError parseError) {
            System.err.println("Unable to compile pattern for tags.reversed_direction, trying default pattern: " + parseError.getMessage());
            try {
                reversedDirectionKeys = SearchCompiler.compile((String)object, false, false);
            }
            catch (SearchCompiler.ParseError parseError2) {
                throw new AssertionError((Object)("Unable to compile default pattern for direction keys: " + parseError2.getMessage()));
            }
        }
        try {
            directionKeys = SearchCompiler.compile(Main.pref.get("tags.direction", (String)charSequence), false, false);
        }
        catch (SearchCompiler.ParseError parseError) {
            System.err.println("Unable to compile pattern for tags.direction, trying default pattern: " + parseError.getMessage());
            try {
                directionKeys = SearchCompiler.compile((String)charSequence, false, false);
            }
            catch (SearchCompiler.ParseError parseError3) {
                throw new AssertionError((Object)("Unable to compile default pattern for direction keys: " + parseError3.getMessage()));
            }
        }
    }
}

