/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.text.MessageFormat;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OsmPrimitiveType {
    NODE(I18n.marktr("node"), Node.class, NodeData.class),
    WAY(I18n.marktr("way"), Way.class, WayData.class),
    RELATION(I18n.marktr("relation"), Relation.class, RelationData.class),
    CLOSEDWAY(I18n.marktr("closedway"), null, WayData.class),
    MULTIPOLYGON(I18n.marktr("multipolygon"), null, RelationData.class);

    private final String apiTypeName;
    private final Class<? extends OsmPrimitive> osmClass;
    private final Class<? extends PrimitiveData> dataClass;

    private OsmPrimitiveType(String string2, Class<? extends OsmPrimitive> clazz, Class<? extends PrimitiveData> clazz2) {
        this.apiTypeName = string2;
        this.osmClass = clazz;
        this.dataClass = clazz2;
    }

    public String getAPIName() {
        return this.apiTypeName;
    }

    public Class<? extends OsmPrimitive> getOsmClass() {
        return this.osmClass;
    }

    public Class<? extends PrimitiveData> getDataClass() {
        return this.dataClass;
    }

    public static OsmPrimitiveType fromApiTypeName(String string) {
        for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
            if (!osmPrimitiveType.getAPIName().equals(string)) continue;
            return osmPrimitiveType;
        }
        throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' is not a valid type name. Got ''{1}''.", "typeName", string));
    }

    public static OsmPrimitiveType from(OsmPrimitive osmPrimitive) {
        return OsmPrimitiveType.from(osmPrimitive.getClass());
    }

    public static OsmPrimitiveType from(Class<? extends OsmPrimitive> clazz) {
        if (clazz.equals(Node.class)) {
            return NODE;
        }
        if (clazz.equals(Way.class)) {
            return WAY;
        }
        if (clazz.equals(Relation.class)) {
            return RELATION;
        }
        throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' is not an acceptable class. Got ''{1}''.", "cls", clazz.toString()));
    }

    public static OsmPrimitiveType fromData(Class<? extends PrimitiveData> clazz) {
        if (clazz.equals(NodeData.class)) {
            return NODE;
        }
        if (clazz.equals(WayData.class)) {
            return WAY;
        }
        if (clazz.equals(RelationData.class)) {
            return RELATION;
        }
        throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' is not an acceptable class. Got ''{1}''.", "cls", clazz.toString()));
    }

    public static OsmPrimitiveType fromData(PrimitiveData primitiveData) {
        return OsmPrimitiveType.fromData(primitiveData.getClass());
    }

    public static OsmPrimitiveType from(String string) {
        if (string == null) {
            return null;
        }
        for (OsmPrimitiveType osmPrimitiveType : OsmPrimitiveType.values()) {
            if (!osmPrimitiveType.getAPIName().equalsIgnoreCase(string)) continue;
            return osmPrimitiveType;
        }
        return null;
    }

    public OsmPrimitive newInstance(long l, boolean bl) {
        switch (this) {
            case NODE: {
                return new Node(l, bl);
            }
            case WAY: {
                return new Way(l, bl);
            }
            case RELATION: {
                return new Relation(l, bl);
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        return I18n.tr(this.getAPIName());
    }
}

