/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DuplicateLayerAction;
import org.openstreetmap.josm.actions.MergeLayerAction;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog {
    private static LayerListDialog instance;
    private LayerListModel model;
    private DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
    private LayerList layerList;
    private SideButton opacityButton;
    ActivateLayerAction activateLayerAction;

    public static void createInstance(MapFrame mapFrame) {
        if (instance != null) {
            throw new IllegalStateException("Dialog was already created");
        }
        instance = new LayerListDialog(mapFrame);
    }

    public static LayerListDialog getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Dialog not created yet. Invoke createInstance() first");
        }
        return instance;
    }

    protected JPanel createButtonPanel() {
        JPanel jPanel = this.getButtonPanel(5);
        MoveUpAction moveUpAction = new MoveUpAction();
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.selectionModel);
        jPanel.add(new SideButton(moveUpAction));
        MoveDownAction moveDownAction = new MoveDownAction();
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.selectionModel);
        jPanel.add(new SideButton(moveDownAction));
        this.activateLayerAction = new ActivateLayerAction();
        this.adaptTo((IEnabledStateUpdating)this.activateLayerAction, this.selectionModel);
        jPanel.add(new SideButton(this.activateLayerAction));
        ShowHideLayerAction showHideLayerAction = new ShowHideLayerAction();
        this.adaptTo((IEnabledStateUpdating)showHideLayerAction, this.selectionModel);
        jPanel.add(new SideButton(showHideLayerAction));
        LayerOpacityAction layerOpacityAction = new LayerOpacityAction();
        this.adaptTo((IEnabledStateUpdating)layerOpacityAction, this.selectionModel);
        this.opacityButton = new SideButton(layerOpacityAction);
        jPanel.add(this.opacityButton);
        MergeAction mergeAction = new MergeAction();
        this.adaptTo((IEnabledStateUpdating)mergeAction, this.model);
        this.adaptTo((IEnabledStateUpdating)mergeAction, this.selectionModel);
        jPanel.add(new SideButton(mergeAction));
        DuplicateAction duplicateAction = new DuplicateAction();
        this.adaptTo((IEnabledStateUpdating)duplicateAction, this.model);
        this.adaptTo((IEnabledStateUpdating)duplicateAction, this.selectionModel);
        jPanel.add(new SideButton(duplicateAction));
        DeleteLayerAction deleteLayerAction = new DeleteLayerAction();
        this.layerList.getActionMap().put("deleteLayer", deleteLayerAction);
        this.adaptTo((IEnabledStateUpdating)deleteLayerAction, this.selectionModel);
        jPanel.add(new SideButton((Action)deleteLayerAction, false));
        return jPanel;
    }

    protected LayerListDialog(MapFrame mapFrame) {
        super(I18n.tr("Layers"), "layerlist", I18n.tr("Open a list of all loaded layers."), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Toggle: {0}", I18n.tr("Layers")), 76, 4), 100, true);
        this.selectionModel.setSelectionMode(2);
        this.model = new LayerListModel(this.selectionModel);
        this.layerList = new LayerList(this.model);
        this.layerList.setSelectionModel(this.selectionModel);
        this.layerList.addMouseListener(new PopupMenuHandler());
        this.layerList.setBackground(UIManager.getColor("Button.background"));
        this.layerList.putClientProperty("terminateEditOnFocusLost", true);
        this.layerList.setSelectionMode(2);
        this.layerList.setTableHeader(null);
        this.layerList.setShowGrid(false);
        this.layerList.setIntercellSpacing(new Dimension(0, 0));
        this.layerList.getColumnModel().getColumn(0).setCellRenderer(new ActiveLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new ActiveLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(0).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(0).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(0).setResizable(false);
        this.layerList.getColumnModel().getColumn(1).setCellRenderer(new LayerVisibleCellRenderer());
        this.layerList.getColumnModel().getColumn(1).setCellEditor(new LayerVisibleCellEditor(new LayerVisibleCheckBox()));
        this.layerList.getColumnModel().getColumn(1).setMaxWidth(16);
        this.layerList.getColumnModel().getColumn(1).setPreferredWidth(16);
        this.layerList.getColumnModel().getColumn(1).setResizable(false);
        this.layerList.getColumnModel().getColumn(2).setCellRenderer(new LayerNameCellRenderer());
        this.layerList.getColumnModel().getColumn(2).setCellEditor(new LayerNameCellEditor(new JTextField()));
        for (KeyStroke keyStroke : new KeyStroke[]{KeyStroke.getKeyStroke(67, 2), KeyStroke.getKeyStroke(86, 2), KeyStroke.getKeyStroke(40, 1), KeyStroke.getKeyStroke(38, 1), KeyStroke.getKeyStroke(37, 1), KeyStroke.getKeyStroke(39, 1), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(34, 0)}) {
            this.layerList.getInputMap(1).put(keyStroke, new Object());
        }
        this.add((Component)new JScrollPane(this.layerList), "Center");
        MapView mapView = mapFrame.mapView;
        this.model.populate();
        this.model.setSelectedLayer(mapView.getActiveLayer());
        this.model.addLayerListModelListener(new LayerListModelListener(){

            public void makeVisible(int n, Layer layer) {
                LayerListDialog.this.layerList.scrollToVisible(n, 0);
                LayerListDialog.this.layerList.repaint();
            }

            public void refresh() {
                LayerListDialog.this.layerList.repaint();
            }
        });
        this.add((Component)this.createButtonPanel(), "South");
    }

    public void showNotify() {
        MapView.addLayerChangeListener(this.activateLayerAction);
        MapView.addLayerChangeListener(this.model);
        this.model.populate();
    }

    public void hideNotify() {
        MapView.removeLayerChangeListener(this.model);
        MapView.removeLayerChangeListener(this.activateLayerAction);
    }

    public LayerListModel getModel() {
        return this.model;
    }

    protected void adaptTo(final IEnabledStateUpdating iEnabledStateUpdating, ListSelectionModel listSelectionModel) {
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    protected void adaptTo(final IEnabledStateUpdating iEnabledStateUpdating, LayerListModel layerListModel) {
        layerListModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    public void destroy() {
        super.destroy();
        instance = null;
    }

    public ShowHideLayerAction createShowHideLayerAction() {
        ShowHideLayerAction showHideLayerAction = new ShowHideLayerAction();
        showHideLayerAction.putValue("Name", I18n.tr("Show/Hide"));
        return showHideLayerAction;
    }

    public DeleteLayerAction createDeleteLayerAction() {
        return new DeleteLayerAction();
    }

    public ActivateLayerAction createActivateLayerAction(Layer layer) {
        return new ActivateLayerAction(layer);
    }

    public MergeAction createMergeLayerAction(Layer layer) {
        return new MergeAction(layer);
    }

    static class LayerList
    extends JTable {
        public LayerList(TableModel tableModel) {
            super(tableModel);
        }

        public void scrollToVisible(int n, int n2) {
            if (!(this.getParent() instanceof JViewport)) {
                return;
            }
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle = this.getCellRect(n, n2, true);
            Point point = jViewport.getViewPosition();
            rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
            jViewport.scrollRectToVisible(rectangle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LayerListModel
    extends AbstractTableModel
    implements MapView.LayerChangeListener,
    PropertyChangeListener {
        private DefaultListSelectionModel selectionModel;
        private CopyOnWriteArrayList<LayerListModelListener> listeners;

        private LayerListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.listeners = new CopyOnWriteArrayList();
        }

        public void addLayerListModelListener(LayerListModelListener layerListModelListener) {
            if (layerListModelListener != null) {
                this.listeners.addIfAbsent(layerListModelListener);
            }
        }

        public void removeLayerListModelListener(LayerListModelListener layerListModelListener) {
            this.listeners.remove(layerListModelListener);
        }

        protected void fireMakeVisible(int n, Layer layer) {
            for (LayerListModelListener layerListModelListener : this.listeners) {
                layerListModelListener.makeVisible(n, layer);
            }
        }

        protected void fireRefresh() {
            for (LayerListModelListener layerListModelListener : this.listeners) {
                layerListModelListener.refresh();
            }
        }

        public void populate() {
            for (Layer layer : this.getLayers()) {
                layer.removePropertyChangeListener(this);
                layer.addPropertyChangeListener(this);
            }
            this.fireTableDataChanged();
        }

        public void setSelectedLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            int n = this.getLayers().indexOf(layer);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
            this.ensureSelectedIsVisible();
        }

        public List<Layer> getSelectedLayers() {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.getLayers().get(i));
            }
            return arrayList;
        }

        public List<Integer> getSelectedRows() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        protected void onRemoveLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.removePropertyChangeListener(this);
            int n = this.getRowCount();
            List<Integer> list = this.getSelectedRows();
            if (list.isEmpty() && n > 0) {
                this.selectionModel.setSelectionInterval(n - 1, n - 1);
            }
            this.fireTableDataChanged();
            this.fireRefresh();
            this.ensureActiveSelected();
        }

        protected void onAddLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.addPropertyChangeListener(this);
            this.fireTableDataChanged();
            int n = this.getLayers().indexOf(layer);
            LayerListDialog.this.layerList.setRowHeight(n, Math.max(16, layer.getIcon().getIconHeight()));
            this.selectionModel.setSelectionInterval(n, n);
            this.ensureSelectedIsVisible();
        }

        public Layer getFirstLayer() {
            if (this.getRowCount() == 0) {
                return null;
            }
            return this.getLayers().get(0);
        }

        public Layer getLayer(int n) {
            if (n < 0 || n >= this.getRowCount()) {
                return null;
            }
            return this.getLayers().get(n);
        }

        public boolean canMoveUp() {
            List<Integer> list = this.getSelectedRows();
            return !list.isEmpty() && list.get(0) > 0;
        }

        public void moveUp() {
            if (!this.canMoveUp()) {
                return;
            }
            List<Integer> list = this.getSelectedRows();
            for (int n : list) {
                Layer layer = this.getLayers().get(n);
                Layer layer2 = this.getLayers().get(n - 1);
                Main.map.mapView.moveLayer(layer2, n);
                Main.map.mapView.moveLayer(layer, n - 1);
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (int n : list) {
                this.selectionModel.addSelectionInterval(n - 1, n - 1);
            }
            this.ensureSelectedIsVisible();
        }

        public boolean canMoveDown() {
            List<Integer> list = this.getSelectedRows();
            return !list.isEmpty() && list.get(list.size() - 1) < this.getLayers().size() - 1;
        }

        public void moveDown() {
            if (!this.canMoveDown()) {
                return;
            }
            List<Integer> list = this.getSelectedRows();
            Collections.reverse(list);
            for (int n : list) {
                Layer layer = this.getLayers().get(n);
                Layer layer2 = this.getLayers().get(n + 1);
                Main.map.mapView.moveLayer(layer, n + 1);
                Main.map.mapView.moveLayer(layer2, n);
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (int n : list) {
                this.selectionModel.addSelectionInterval(n + 1, n + 1);
            }
            this.ensureSelectedIsVisible();
        }

        protected void ensureSelectedIsVisible() {
            int n = this.selectionModel.getMinSelectionIndex();
            if (n < 0) {
                return;
            }
            if (n >= this.getLayers().size()) {
                return;
            }
            Layer layer = this.getLayers().get(n);
            this.fireMakeVisible(n, layer);
        }

        public List<Layer> getPossibleMergeTargets(Layer layer) {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            if (layer == null) {
                return arrayList;
            }
            for (Layer layer2 : this.getLayers()) {
                if (layer == layer2 || !layer2.isMergable(layer)) continue;
                arrayList.add(layer2);
            }
            return arrayList;
        }

        protected List<Layer> getLayers() {
            if (Main.map == null || Main.map.mapView == null) {
                return Collections.emptyList();
            }
            return Main.map.mapView.getAllLayersAsList();
        }

        protected void ensureActiveSelected() {
            if (this.getLayers().isEmpty()) {
                return;
            }
            if (this.getActiveLayer() != null) {
                int n = this.getLayers().indexOf(this.getActiveLayer());
                this.selectionModel.setSelectionInterval(n, n);
                this.ensureSelectedIsVisible();
            } else {
                this.selectionModel.setSelectionInterval(0, 0);
                this.ensureSelectedIsVisible();
            }
        }

        protected Layer getActiveLayer() {
            if (Main.map == null || Main.map.mapView == null) {
                return null;
            }
            return Main.map.mapView.getActiveLayer();
        }

        @Override
        public int getRowCount() {
            List<Layer> list = this.getLayers();
            if (list == null) {
                return 0;
            }
            return list.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getLayers().get(n) == this.getActiveLayer();
                }
                case 1: {
                    return this.getLayers().get(n);
                }
                case 2: {
                    return this.getLayers().get(n);
                }
            }
            throw new RuntimeException();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 || this.getActiveLayer() != this.getLayers().get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Layer layer = this.getLayers().get(n);
            switch (n2) {
                case 0: {
                    Main.map.mapView.setActiveLayer(layer);
                    layer.setVisible(true);
                    break;
                }
                case 1: {
                    layer.setVisible((Boolean)object);
                    break;
                }
                case 2: {
                    layer.setName((String)object);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public void activeLayerChange(Layer layer, Layer layer2) {
            int n;
            if (layer != null && (n = this.getLayers().indexOf(layer)) >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
            if (layer2 != null && (n = this.getLayers().indexOf(layer2)) >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
            this.ensureActiveSelected();
        }

        @Override
        public void layerAdded(Layer layer) {
            this.onAddLayer(layer);
        }

        @Override
        public void layerRemoved(Layer layer) {
            this.onRemoveLayer(layer);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof Layer) {
                Layer layer = (Layer)propertyChangeEvent.getSource();
                int n = this.getLayers().indexOf(layer);
                if (n < 0) {
                    return;
                }
                this.fireRefresh();
            }
        }
    }

    public static interface LayerListModelListener {
        public void makeVisible(int var1, Layer var2);

        public void refresh();
    }

    class MoveDownAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveDownAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "down"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row down."));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveDown());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LayerListDialog.this.model.moveDown();
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveUpAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row up."));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveUp());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LayerListDialog.this.model.moveUp();
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        public void launch(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = LayerListDialog.this.layerList.rowAtPoint(point);
            if (n < 0) {
                return;
            }
            if (!LayerListDialog.this.layerList.getCellRect(n, 2, false).contains(mouseEvent.getPoint())) {
                return;
            }
            if (!LayerListDialog.this.layerList.isRowSelected(n)) {
                LayerListDialog.this.layerList.setRowSelectionInterval(n, n);
            }
            Layer layer = LayerListDialog.this.model.getLayer(n);
            LayerListPopup layerListPopup = new LayerListPopup(LayerListDialog.this.getModel().getSelectedLayers(), layer);
            layerListPopup.show(LayerListDialog.this.layerList, point.x, point.y - 3);
        }
    }

    private static class LayerNameCellEditor
    extends DefaultCellEditor {
        public LayerNameCellEditor(JTextField jTextField) {
            super(jTextField);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JTextField jTextField = (JTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            jTextField.setText(object == null ? "" : ((Layer)object).getName());
            return jTextField;
        }
    }

    private static class LayerNameCellRenderer
    extends DefaultTableCellRenderer {
        private LayerNameCellRenderer() {
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Layer layer = (Layer)object;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, layer.getName(), bl, bl2, n, n2);
            if (this.isActiveLayer(layer)) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            jLabel.setIcon(layer.getIcon());
            jLabel.setToolTipText(layer.getToolTipText());
            return jLabel;
        }
    }

    private static class LayerVisibleCellEditor
    extends DefaultCellEditor {
        LayerVisibleCheckBox cb;

        public LayerVisibleCellEditor(LayerVisibleCheckBox layerVisibleCheckBox) {
            super(layerVisibleCheckBox);
            this.cb = layerVisibleCheckBox;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cb.updateStatus((Layer)object);
            return this.cb;
        }
    }

    private static class LayerVisibleCellRenderer
    implements TableCellRenderer {
        LayerVisibleCheckBox cb = new LayerVisibleCheckBox();

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.cb.updateStatus((Layer)object);
            return this.cb;
        }
    }

    private static class ActiveLayerCellRenderer
    implements TableCellRenderer {
        JCheckBox cb = new ActiveLayerCheckBox();

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = (Boolean)object;
            this.cb.setSelected(bl3);
            this.cb.setToolTipText(bl3 ? I18n.tr("this layer is the active layer") : I18n.tr("this layer is not currently active (click to activate)"));
            return this.cb;
        }
    }

    private static class LayerVisibleCheckBox
    extends JCheckBox {
        private final ImageIcon icon_eye;
        private final ImageIcon icon_eye_translucent;
        private boolean isTranslucent;

        public LayerVisibleCheckBox() {
            this.setHorizontalAlignment(4);
            this.icon_eye = ImageProvider.get("dialogs/layerlist", "eye");
            this.icon_eye_translucent = ImageProvider.get("dialogs/layerlist", "eye-translucent");
            this.setIcon(ImageProvider.get("dialogs/layerlist", "eye-off"));
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "eye-pressed"));
            this.setSelectedIcon(this.icon_eye);
            this.isTranslucent = false;
        }

        public void setTranslucent(boolean bl) {
            if (this.isTranslucent == bl) {
                return;
            }
            if (bl) {
                this.setSelectedIcon(this.icon_eye_translucent);
            } else {
                this.setSelectedIcon(this.icon_eye);
            }
            this.isTranslucent = bl;
        }

        public void updateStatus(Layer layer) {
            boolean bl = layer.isVisible();
            this.setSelected(bl);
            this.setTranslucent(layer.getOpacity() < 1.0);
            this.setToolTipText(bl ? I18n.tr("layer is currently visible (click to hide layer)") : I18n.tr("layer is currently hidden (click to show layer)"));
        }
    }

    private static class ActiveLayerCheckBox
    extends JCheckBox {
        public ActiveLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon imageIcon = ImageProvider.get("dialogs/layerlist", "blank");
            ImageIcon imageIcon2 = ImageProvider.get("dialogs/layerlist", "active");
            this.setIcon(imageIcon);
            this.setSelectedIcon(imageIcon2);
            this.setRolloverIcon(imageIcon);
            this.setRolloverSelectedIcon(imageIcon2);
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "active-pressed"));
        }
    }

    public final class DuplicateAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public DuplicateAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Duplicate"));
            this.updateEnabledState();
        }

        public DuplicateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "duplicatelayer"));
            this.putValue("ShortDescription", I18n.tr("Duplicate this layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DuplicateLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.layer != null) {
                new DuplicateLayerAction().duplicate(this.layer);
            } else {
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                new DuplicateLayerAction().duplicate(layer);
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() == 1) {
                    this.setEnabled(DuplicateLayerAction.canDuplicate(LayerListDialog.this.getModel().getSelectedLayers().get(0)));
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(DuplicateLayerAction.canDuplicate(this.layer));
            }
        }
    }

    public final class MergeAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public MergeAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Merge"));
            this.updateEnabledState();
        }

        public MergeAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "mergedown"));
            this.putValue("ShortDescription", I18n.tr("Merge this layer into another layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#MergeLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.layer != null) {
                new MergeLayerAction().merge(this.layer);
            } else {
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                new MergeLayerAction().merge(layer);
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() != 1) {
                    this.setEnabled(false);
                    return;
                }
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                List<Layer> list = LayerListDialog.this.getModel().getPossibleMergeTargets(layer);
                this.setEnabled(!list.isEmpty());
            } else {
                List<Layer> list = LayerListDialog.this.getModel().getPossibleMergeTargets(this.layer);
                this.setEnabled(!list.isEmpty());
            }
        }
    }

    public final class ActivateLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    MapView.LayerChangeListener {
        private Layer layer;

        public ActivateLayerAction(Layer layer) {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Activate"));
            this.updateEnabledState();
        }

        public ActivateLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "activate"));
            this.putValue("ShortDescription", I18n.tr("Activate the selected layer"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ActivateLayer"));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = this.layer != null ? this.layer : LayerListDialog.this.model.getSelectedLayers().get(0);
            Main.map.mapView.setActiveLayer(layer);
            layer.setVisible(true);
        }

        protected boolean isActiveLayer(Layer layer) {
            if (Main.map == null) {
                return false;
            }
            if (Main.map.mapView == null) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() != 1) {
                    this.setEnabled(false);
                    return;
                }
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                this.setEnabled(!this.isActiveLayer(layer));
            } else {
                this.setEnabled(!this.isActiveLayer(this.layer));
            }
        }

        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class LayerOpacityAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        private Layer layer;
        private JPopupMenu popup;
        private JSlider slider = new JSlider(1);

        public LayerOpacityAction(Layer layer) throws IllegalArgumentException {
            this();
            this.putValue("Name", I18n.tr("Opacity"));
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.updateEnabledState();
        }

        public LayerOpacityAction() {
            this.putValue("ShortDescription", I18n.tr("Adjust opacity of the layer."));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/layerlist", "transparency"));
            this.updateEnabledState();
            this.popup = new JPopupMenu();
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    LayerOpacityAction.this.setOpacity((double)LayerOpacityAction.this.slider.getValue() / 100.0);
                }
            });
            this.popup.add(this.slider);
        }

        private void setOpacity(double d) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.layer != null) {
                this.layer.setOpacity(d);
            } else {
                for (Layer layer : LayerListDialog.this.model.getSelectedLayers()) {
                    layer.setOpacity(d);
                }
            }
        }

        private double getOpacity() {
            if (this.layer != null) {
                return this.layer.getOpacity();
            }
            double d = 0.0;
            List<Layer> list = LayerListDialog.this.model.getSelectedLayers();
            for (Layer layer : list) {
                d += layer.getOpacity();
            }
            return d / (double)list.size();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.slider.setValue((int)Math.round(this.getOpacity() * 100.0));
            this.popup.show(LayerListDialog.this.opacityButton, 0, LayerListDialog.this.opacityButton.getHeight());
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
            } else {
                this.setEnabled(true);
            }
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof LayerOpacityAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ShowHideLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        private Layer layer;

        public ShowHideLayerAction(Layer layer) throws IllegalArgumentException {
            this();
            this.putValue("Name", I18n.tr("Show/Hide"));
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.updateEnabledState();
        }

        public ShowHideLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the selected layer."));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ShowHideLayer"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.layer != null) {
                this.layer.toggleVisible();
            } else {
                for (Layer layer : LayerListDialog.this.model.getSelectedLayers()) {
                    layer.toggleVisible();
                }
            }
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
            } else {
                this.setEnabled(true);
            }
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof ShowHideLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DeleteLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        public DeleteLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected layers."));
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DeleteLayer"));
            this.updateEnabledState();
        }

        protected boolean enforceUploadOrSaveModifiedData(List<Layer> list) {
            SaveLayersDialog saveLayersDialog = new SaveLayersDialog(Main.parent);
            ArrayList<OsmDataLayer> arrayList = new ArrayList<OsmDataLayer>();
            for (Layer layer : list) {
                OsmDataLayer osmDataLayer;
                if (!(layer instanceof OsmDataLayer) || !(osmDataLayer = (OsmDataLayer)layer).requiresSaveToFile() && !osmDataLayer.requiresUploadToServer() || !osmDataLayer.data.isModified()) continue;
                arrayList.add(osmDataLayer);
            }
            saveLayersDialog.prepareForSavingAndUpdatingLayersBeforeDelete();
            if (!arrayList.isEmpty()) {
                saveLayersDialog.getModel().populate(arrayList);
                saveLayersDialog.setVisible(true);
                switch (saveLayersDialog.getUserAction()) {
                    case CANCEL: {
                        return false;
                    }
                    case PROCEED: {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<Layer> list = LayerListDialog.this.getModel().getSelectedLayers();
            if (list.isEmpty()) {
                return;
            }
            if (!this.enforceUploadOrSaveModifiedData(list)) {
                return;
            }
            for (Layer layer : list) {
                Main.main.removeLayer(layer);
            }
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof DeleteLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    protected static interface IEnabledStateUpdating {
        public void updateEnabledState();
    }
}

