/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import org.openstreetmap.josm.tools.I18n;

public class WayConnectionType {
    private final boolean invalid;
    public boolean linkPrev;
    public boolean linkNext;
    public Direction direction;
    public boolean isLoop;
    public boolean isOnewayLoopForwardPart = false;
    public boolean isOnewayLoopBackwardPart = false;
    public boolean isOnewayHead = false;
    public boolean isOnewayTail = false;

    public WayConnectionType(boolean bl, boolean bl2, Direction direction) {
        this.linkPrev = bl;
        this.linkNext = bl2;
        this.isLoop = false;
        this.direction = direction;
        this.invalid = false;
    }

    public WayConnectionType(boolean bl) {
        this.invalid = bl;
    }

    public WayConnectionType() {
        this.linkPrev = false;
        this.linkNext = false;
        this.isLoop = false;
        this.direction = Direction.NONE;
        this.invalid = true;
    }

    public boolean isValid() {
        return !this.invalid;
    }

    public String toString() {
        return "[P " + this.linkPrev + " ;N " + this.linkNext + " ;D " + (Object)((Object)this.direction) + " ;L " + this.isLoop + " ;FP " + this.isOnewayLoopForwardPart + ";BP " + this.isOnewayLoopBackwardPart + ";OH " + this.isOnewayHead + ";OT " + this.isOnewayTail + "]";
    }

    public String getToolTip() {
        if (!this.isValid()) {
            return "";
        }
        if (this.linkPrev && this.linkNext) {
            return I18n.tr("way is connected");
        }
        if (this.linkPrev) {
            return I18n.tr("way is connected to previous relation member");
        }
        if (this.linkNext) {
            return I18n.tr("way is connected to next relation member");
        }
        return I18n.tr("way is not connected to previous or next relation member");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FORWARD,
        BACKWARD,
        ROUNDABOUT_LEFT,
        ROUNDABOUT_RIGHT,
        NONE;


        public boolean isRoundabout() {
            return this == ROUNDABOUT_RIGHT || this == ROUNDABOUT_LEFT;
        }
    }
}

