/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Font;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.tools.Utils;

public abstract class ElemStyle {
    public float z_index;
    public float object_z_index;
    public boolean isModifier;

    public ElemStyle(float f, float f2, boolean bl) {
        this.z_index = f;
        this.object_z_index = f2;
        this.isModifier = bl;
    }

    protected ElemStyle(Cascade cascade) {
        this.z_index = cascade.get("z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.object_z_index = cascade.get("object-z-index", Float.valueOf(0.0f), Float.class).floatValue();
        this.isModifier = cascade.get("modifier", false, Boolean.class);
    }

    public abstract void paintPrimitive(OsmPrimitive var1, MapPaintSettings var2, MapPainter var3, boolean var4, boolean var5);

    protected static Float getWidth(Cascade cascade, String string, Float f) {
        Float f2 = cascade.get(string, null, Float.class, true);
        if (f2 != null) {
            if (f2.floatValue() > 0.0f) {
                return f2;
            }
        } else {
            Instruction.RelativeFloat relativeFloat;
            String string2 = cascade.get(string, null, String.class, true);
            if (Utils.equal(string2, "thinnest")) {
                return Float.valueOf(0.0f);
            }
            if (Utils.equal(string2, "default")) {
                return Float.valueOf(MapPaintSettings.INSTANCE.getDefaultSegmentWidth());
            }
            if (f != null && (relativeFloat = cascade.get(string, null, Instruction.RelativeFloat.class, true)) != null) {
                return Float.valueOf(f.floatValue() + relativeFloat.val);
            }
        }
        return null;
    }

    protected static Font getFont(Cascade cascade) {
        String string = cascade.get("font-family", Main.pref.get("mappaint.font", "Helvetica"), String.class);
        float f = cascade.get("font-size", Float.valueOf(Main.pref.getInteger("mappaint.fontsize", 8)), Float.class).floatValue();
        int n = 0;
        String string2 = cascade.get("font-wheight", null, String.class);
        if (Utils.equal(string2, "bold")) {
            n = 1;
        }
        int n2 = 0;
        String string3 = cascade.get("font-style", null, String.class);
        if (Utils.equal(string3, "italic")) {
            n2 = 2;
        }
        return new Font(string, n | n2, Math.round(f));
    }

    public boolean equals(Object object) {
        if (!(object instanceof ElemStyle)) {
            return false;
        }
        ElemStyle elemStyle = (ElemStyle)object;
        return this.z_index == elemStyle.z_index && this.object_z_index == elemStyle.object_z_index && this.isModifier == elemStyle.isModifier;
    }

    public int hashCode() {
        int n = 5;
        n = 41 * n + Float.floatToIntBits(this.z_index);
        n = 41 * n + Float.floatToIntBits(this.object_z_index);
        n = 41 * n + (this.isModifier ? 1 : 0);
        return n;
    }

    public String toString() {
        if (this.z_index != 0.0f || this.object_z_index != 0.0f) {
            return String.format("z_idx=%s/%s ", Float.valueOf(this.z_index), Float.valueOf(this.object_z_index)) + (this.isModifier ? "modifier " : "");
        }
        return "";
    }
}

