/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.Arrays;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.Utils;

public class LineElemStyle
extends ElemStyle {
    public static final LineElemStyle UNTAGGED_WAY = LineElemStyle.createSimpleLineStyle(null);
    private BasicStroke line;
    public Color color;
    public Color dashesBackground;
    public TextElement text;
    public float realWidth;
    private BasicStroke dashesLine;

    public static LineElemStyle createSimpleLineStyle(Color color) {
        MultiCascade multiCascade = new MultiCascade();
        Cascade cascade = multiCascade.getOrCreateCascade("default");
        cascade.put("width", "default");
        cascade.put("color", color != null ? color : PaintColors.UNTAGGED.get());
        return LineElemStyle.createLine(new Environment(null, multiCascade, "default", null));
    }

    protected LineElemStyle(Cascade cascade, BasicStroke basicStroke, Color color, BasicStroke basicStroke2, Color color2, TextElement textElement, float f) {
        super(cascade);
        this.line = basicStroke;
        this.color = color;
        this.dashesLine = basicStroke2;
        this.dashesBackground = color2;
        this.text = textElement;
        this.realWidth = f;
    }

    public static LineElemStyle createLine(Environment environment) {
        return LineElemStyle.createImpl(environment, false);
    }

    public static LineElemStyle createCasing(Environment environment) {
        LineElemStyle lineElemStyle = LineElemStyle.createImpl(environment, true);
        if (lineElemStyle != null) {
            lineElemStyle.z_index = -100.0f;
            lineElemStyle.isModifier = true;
        }
        return lineElemStyle;
    }

    private static LineElemStyle createImpl(Environment environment, boolean bl) {
        String string;
        Object object;
        String string2;
        Float f;
        Object object2;
        Float f2;
        String string3;
        Cascade cascade = environment.mc.getCascade(environment.layer);
        Cascade cascade2 = environment.mc.getCascade("default");
        String string4 = string3 = bl ? "casing-" : "";
        if (bl) {
            f2 = LineElemStyle.getWidth(cascade2, "width", null);
            object2 = LineElemStyle.getWidth(cascade, "width", f2);
            f = LineElemStyle.getWidth(cascade, "casing-width", (Float)object2);
        } else {
            f2 = LineElemStyle.getWidth(cascade2, "width", null);
            f = LineElemStyle.getWidth(cascade, "width", f2);
        }
        if (f == null) {
            return null;
        }
        float f3 = cascade.get(string3 + "real-width", Float.valueOf(0.0f), Float.class).floatValue();
        if (f3 > 0.0f && MapPaintSettings.INSTANCE.isUseRealWidth()) {
            object2 = environment.osm.get("width");
            if (object2 == null) {
                object2 = environment.osm.get("est_width");
            }
            if (object2 != null) {
                try {
                    f3 = new Float(Integer.parseInt((String)object2)).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        object2 = cascade.get(string3 + "color", null, Color.class);
        if (!bl && object2 == null) {
            object2 = cascade.get("fill-color", null, Color.class);
        }
        if (object2 == null) {
            object2 = PaintColors.UNTAGGED.get();
        }
        int n = 255;
        Integer n2 = Utils.color_float2int(cascade.get("opacity", null, Float.TYPE));
        if (n2 != null) {
            n = n2;
        }
        object2 = new Color(((Color)object2).getRed(), ((Color)object2).getGreen(), ((Color)object2).getBlue(), n);
        float[] fArray = cascade.get(string3 + "dashes", null, float[].class);
        if (fArray != null) {
            boolean bl2 = false;
            for (float f4 : fArray) {
                if (f4 > 0.0f) {
                    bl2 = true;
                }
                if (!(f4 < 0.0f)) continue;
                fArray = null;
                break;
            }
            if (!bl2 || fArray.length == 0) {
                fArray = null;
            }
        }
        float f5 = cascade.get(string3 + "dashes-offset", Float.valueOf(0.0f), Float.class).floatValue();
        Object object3 = cascade.get(string3 + "dashes-background-color", null, Color.class);
        if (object3 != null) {
            n2 = Utils.color_float2int(cascade.get(string3 + "dashes-background-opacity", null, Float.class));
            if (n2 != null) {
                n = n2;
            }
            object3 = new Color(((Color)object3).getRed(), ((Color)object3).getGreen(), ((Color)object3).getBlue(), n);
        }
        int n3 = Utils.equal(string2 = cascade.get(string3 + "linecap", null, String.class), "none") ? 0 : (Utils.equal(string2, "round") ? 1 : (Utils.equal(string2, "square") ? 2 : (fArray != null ? 0 : 1)));
        String string5 = cascade.get(string3 + "linejoin", null, String.class);
        int n4 = Utils.equal(string5, "round") ? 1 : (Utils.equal(string5, "miter") ? 0 : (Utils.equal(string5, "bevel") ? 2 : 1));
        float f6 = cascade.get(string3 + "miterlimit", Float.valueOf(10.0f), Float.class).floatValue();
        if (f6 < 1.0f) {
            f6 = 10.0f;
        }
        BasicStroke basicStroke = new BasicStroke(f.floatValue(), n3, n4, f6, fArray, f5);
        BasicStroke basicStroke2 = null;
        if (fArray != null && object3 != null) {
            object = new float[fArray.length];
            System.arraycopy(fArray, 0, object, 1, fArray.length - 1);
            object[0] = fArray[fArray.length - 1];
            basicStroke2 = new BasicStroke(f.floatValue(), n3, n4, f6, (float[])object, object[0] + f5);
        }
        object = null;
        if (!bl && ((string = cascade.get("text-position", null, String.class)) == null || Utils.equal(string, "line"))) {
            object = TextElement.create(cascade, PaintColors.TEXT.get());
        }
        return new LineElemStyle(cascade, basicStroke, (Color)object2, basicStroke2, (Color)object3, (TextElement)object, f3);
    }

    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl, boolean bl2) {
        Way way = (Way)osmPrimitive;
        boolean bl3 = !this.isModifier && bl && !mapPaintSettings.isUseRealWidth();
        boolean bl4 = !this.isModifier && !bl && !mapPaintSettings.isUseRealWidth() && mapPaintSettings.isShowDirectionArrow() && way.hasDirectionKeys();
        boolean bl5 = way.reversedDirection();
        boolean bl6 = bl3 && !bl && mapPaintSettings.isShowHeadArrowOnly();
        Color color = this.dashesBackground;
        BasicStroke basicStroke = this.line;
        BasicStroke basicStroke2 = this.dashesLine;
        if (this.realWidth > 0.0f && mapPaintSettings.isUseRealWidth() && !bl3) {
            float f = (int)(100.0f / (float)(mapPainter.getCircum() / (double)this.realWidth));
            if (f < this.line.getLineWidth()) {
                f = this.line.getLineWidth();
            }
            basicStroke = new BasicStroke(f, this.line.getEndCap(), this.line.getLineJoin(), this.line.getMiterLimit(), this.line.getDashArray(), this.line.getDashPhase());
            if (this.dashesLine != null) {
                basicStroke2 = new BasicStroke(f, this.dashesLine.getEndCap(), this.dashesLine.getLineJoin(), this.dashesLine.getMiterLimit(), this.dashesLine.getDashArray(), this.dashesLine.getDashPhase());
            }
        }
        Color color2 = this.color;
        if (way.isHighlighted()) {
            color2 = mapPaintSettings.getHighlightColor();
        } else if (bl) {
            color2 = mapPaintSettings.getSelectedColor(this.color.getAlpha());
        } else if (bl2) {
            color2 = mapPaintSettings.getRelationSelectedColor(this.color.getAlpha());
        } else if (way.isDisabled()) {
            color2 = mapPaintSettings.getInactiveColor();
            color = mapPaintSettings.getInactiveColor();
        }
        mapPainter.drawWay(way, color2, basicStroke, basicStroke2, color, this.text, bl3, bl6, bl4, bl5);
        if (mapPaintSettings.isShowOrderNumber()) {
            int n = 0;
            Node node = null;
            for (Node node2 : way.getNodes()) {
                if (node != null) {
                    mapPainter.drawOrderNumber(node, node2, ++n, color2);
                }
                node = node2;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LineElemStyle lineElemStyle = (LineElemStyle)object;
        return Utils.equal(this.line, lineElemStyle.line) && Utils.equal(this.color, lineElemStyle.color) && Utils.equal(this.dashesLine, lineElemStyle.dashesLine) && Utils.equal(this.dashesBackground, lineElemStyle.dashesBackground) && Utils.equal(this.text, lineElemStyle.text) && this.realWidth == lineElemStyle.realWidth;
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + this.line.hashCode();
        n = 29 * n + this.color.hashCode();
        n = 29 * n + (this.dashesLine != null ? this.dashesLine.hashCode() : 0);
        n = 29 * n + (this.dashesBackground != null ? this.dashesBackground.hashCode() : 0);
        n = 29 * n + (this.text != null ? this.text.hashCode() : 0);
        n = 29 * n + Float.floatToIntBits(this.realWidth);
        return n;
    }

    public String toString() {
        return "LineElemStyle{" + super.toString() + "width=" + this.line.getLineWidth() + " realWidth=" + this.realWidth + " color=" + Utils.toString(this.color) + " dashed=" + Arrays.toString(this.line.getDashArray()) + (this.line.getDashPhase() == 0.0f ? "" : " dashesOffses=" + this.line.getDashPhase()) + " dashedColor=" + Utils.toString(this.dashesBackground) + '}';
    }
}

