/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class ImagerySettingsMigration {
    static boolean wmsLayersConflict;
    static boolean wmsSettingsConflict;
    static boolean tmsSettingsConflict;
    private PropertyMerge mergeModel = PropertyMerge.THROW_ON_CONFLICT;
    JRadioButton wlKeepImagery = new JRadioButton(I18n.tr("Keep current list"));
    JRadioButton wlUseWMS = new JRadioButton(I18n.tr("Overwrite with WMSPlugin list"));
    JRadioButton wlMerge = new JRadioButton(I18n.tr("Merge"));
    JRadioButton wsKeepImagery = new JRadioButton(I18n.tr("Keep current settings"));
    JRadioButton wsUseWMS = new JRadioButton(I18n.tr("Overwrite with WMSPlugin settings"));
    JRadioButton tsKeepImagery = new JRadioButton(I18n.tr("Keep current settings"));
    JRadioButton tsUseSlippyMap = new JRadioButton(I18n.tr("Overwrite with SlippyMap settings"));

    ImagerySettingsMigration() {
    }

    private void migrateProperty(String string, String string2) throws SettingsConflictException {
        String string3;
        String string4 = Main.pref.get(string, null);
        if (string4 == null) {
            return;
        }
        if (this.mergeModel == PropertyMerge.THROW_ON_CONFLICT && (string3 = Main.pref.get(string2, null)) != null && !string4.equals(string3)) {
            System.out.println(I18n.tr("Imagery settings migration: conflict when moving property {0} -> {1}", string, string2));
            throw new SettingsConflictException();
        }
        if (this.mergeModel != PropertyMerge.USE_NEW) {
            Main.pref.put(string2, string4);
        }
        Main.pref.put(string, null);
    }

    private void migrateArray(String string, String string2) throws SettingsConflictException {
        Collection<Collection<String>> collection;
        Collection<Collection<String>> collection2 = Main.pref.getArray(string, null);
        if (collection2 == null) {
            return;
        }
        if (this.mergeModel == PropertyMerge.THROW_ON_CONFLICT && (collection = Main.pref.getArray(string2, null)) != null) {
            System.out.println(I18n.tr("Imagery settings migration: conflict when moving array {0} -> {1}", string, string2));
            throw new SettingsConflictException();
        }
        if (this.mergeModel != PropertyMerge.USE_NEW) {
            Main.pref.putArray(string2, collection2);
        }
        Main.pref.putArray(string, null);
    }

    private void migrateWMSPlugin() {
        try {
            Main.pref.put("wmslayers.default", null);
            this.migrateProperty("imagery.remotecontrol", "remotecontrol.permission.imagery");
            this.migrateProperty("wmsplugin.remotecontrol", "remotecontrol.permission.imagery");
            this.migrateProperty("wmsplugin.alpha_channel", "imagery.wms.alpha_channel");
            this.migrateProperty("wmsplugin.browser", "imagery.wms.browser");
            this.migrateProperty("wmsplugin.user_agent", "imagery.wms.user_agent");
            this.migrateProperty("wmsplugin.timeout.connect", "imagery.wms.timeout.connect");
            this.migrateProperty("wmsplugin.timeout.read", "imagery.wms.timeout.read");
            this.migrateProperty("wmsplugin.simultaneousConnections", "imagery.wms.simultaneousConnections");
            this.migrateProperty("wmsplugin.overlap", "imagery.wms.overlap");
            this.migrateProperty("wmsplugin.overlapEast", "imagery.wms.overlapEast");
            this.migrateProperty("wmsplugin.overlapNorth", "imagery.wms.overlapNorth");
            Map<String, String> map = Main.pref.getAllPrefix("wmsplugin");
            if (!map.isEmpty()) {
                System.out.println(I18n.tr("There are {0} unknown WMSPlugin settings", map.size()));
            }
        }
        catch (SettingsConflictException settingsConflictException) {
            wmsSettingsConflict = true;
        }
    }

    private void migrateSlippyMapPlugin() {
        try {
            Main.pref.put("slippymap.tile_source", null);
            Main.pref.put("slippymap.last_zoom_lvl", null);
            this.migrateProperty("slippymap.draw_debug", "imagery.tms.draw_debug");
            this.migrateProperty("slippymap.autoload_tiles", "imagery.tms.autoload");
            this.migrateProperty("slippymap.autozoom", "imagery.tms.autozoom");
            this.migrateProperty("slippymap.min_zoom_lvl", "imagery.tms.min_zoom_lvl");
            this.migrateProperty("slippymap.max_zoom_lvl", "imagery.tms.max_zoom_lvl");
            if (Main.pref.get("slippymap.fade_background_100", null) == null) {
                try {
                    Main.pref.putInteger("slippymap.fade_background_100", (int)Math.round(Double.valueOf(Main.pref.get("slippymap.fade_background", "0")) * 100.0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Main.pref.put("slippymap.fade_background", null);
            this.migrateProperty("slippymap.fade_background_100", "imagery.fade_amount");
            Map<String, String> map = Main.pref.getAllPrefix("slippymap");
            if (!map.isEmpty()) {
                System.out.println(I18n.tr("There are {0} unknown slippymap plugin settings", map.size()));
            }
        }
        catch (SettingsConflictException settingsConflictException) {
            tmsSettingsConflict = true;
        }
    }

    private void mergeWMSLayers() {
        ImageryLayerInfo imageryLayerInfo = ImageryLayerInfo.instance;
        HashSet<String> hashSet = new HashSet<String>();
        for (ImageryInfo object : imageryLayerInfo.getLayers()) {
            hashSet.add(object.getFullUrl());
        }
        for (Collection collection : Main.pref.getArray("wmslayers", Collections.<Collection<String>>emptySet())) {
            ImageryInfo imageryInfo = new ImageryInfo(collection);
            if (hashSet.contains(imageryInfo.getFullUrl())) continue;
            imageryLayerInfo.add(imageryInfo);
        }
        imageryLayerInfo.save();
        Main.pref.putArray("wmslayers", null);
    }

    public void migrateSettings() {
        this.mergeModel = PropertyMerge.THROW_ON_CONFLICT;
        try {
            this.migrateArray("wmslayers", "imagery.layers");
        }
        catch (SettingsConflictException settingsConflictException) {
            wmsLayersConflict = true;
        }
        this.migrateWMSPlugin();
        this.migrateSlippyMapPlugin();
    }

    public boolean hasConflicts() {
        return wmsLayersConflict || wmsSettingsConflict || tmsSettingsConflict;
    }

    public void settingsMigrationDialog(Component component) {
        int n;
        ButtonGroup buttonGroup;
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (wmsLayersConflict) {
            jPanel.add((Component)new JLabel(I18n.tr("WMS layer list:")), GBC.eol());
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.wlKeepImagery);
            buttonGroup.add(this.wlUseWMS);
            buttonGroup.add(this.wlMerge);
            this.wlMerge.setSelected(true);
            jPanel.add((Component)this.wlKeepImagery, GBC.eol());
            jPanel.add((Component)this.wlUseWMS, GBC.eol());
            jPanel.add((Component)this.wlMerge, GBC.eop());
        }
        if (wmsSettingsConflict) {
            jPanel.add((Component)new JLabel(I18n.tr("WMSPlugin settings:")), GBC.eol());
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.wsKeepImagery);
            buttonGroup.add(this.wsUseWMS);
            this.wsKeepImagery.setSelected(true);
            jPanel.add((Component)this.wsKeepImagery, GBC.eol());
            jPanel.add((Component)this.wsUseWMS, GBC.eop());
        }
        if (tmsSettingsConflict) {
            jPanel.add((Component)new JLabel(I18n.tr("SlippyMap settings:")), GBC.eol());
            buttonGroup = new ButtonGroup();
            buttonGroup.add(this.tsKeepImagery);
            buttonGroup.add(this.tsUseSlippyMap);
            this.tsKeepImagery.setSelected(true);
            jPanel.add((Component)this.tsKeepImagery, GBC.eol());
            jPanel.add((Component)this.tsUseSlippyMap, GBC.eop());
        }
        if ((n = JOptionPane.showConfirmDialog(component, jPanel, I18n.tr("Imagery settings migration"), 2)) != 0) {
            return;
        }
        try {
            if (this.wlMerge.isSelected()) {
                this.mergeWMSLayers();
            } else {
                this.mergeModel = this.wlKeepImagery.isSelected() ? PropertyMerge.USE_NEW : PropertyMerge.USE_OLD;
                this.migrateArray("wmslayers", "imagery.layers");
            }
            wmsLayersConflict = false;
            this.mergeModel = this.wsKeepImagery.isSelected() ? PropertyMerge.USE_NEW : PropertyMerge.USE_OLD;
            this.migrateWMSPlugin();
            wmsSettingsConflict = false;
            this.mergeModel = this.tsKeepImagery.isSelected() ? PropertyMerge.USE_NEW : PropertyMerge.USE_OLD;
            this.migrateSlippyMapPlugin();
            tmsSettingsConflict = false;
        }
        catch (SettingsConflictException settingsConflictException) {
            JOptionPane.showMessageDialog(component, I18n.tr("Warning: unexpected settings conflict"), I18n.tr("Imagery settings migration"), 0);
        }
    }

    static class SettingsConflictException
    extends Exception {
        SettingsConflictException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyMerge {
        USE_OLD,
        USE_NEW,
        THROW_ON_CONFLICT;

    }
}

