/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.CheckParameterUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryInfo
implements Comparable<ImageryInfo> {
    String name;
    private String url = null;
    String cookies = null;
    public final String eulaAcceptanceRequired;
    ImageryType imageryType = ImageryType.WMS;
    double pixelPerDegree = 0.0;
    int maxZoom = 0;

    public ImageryInfo(String string) {
        this.name = string;
        this.eulaAcceptanceRequired = null;
    }

    public ImageryInfo(String string, String string2) {
        this.name = string;
        this.setUrl(string2);
        this.eulaAcceptanceRequired = null;
    }

    public ImageryInfo(String string, String string2, String string3) {
        this.name = string;
        this.setUrl(string2);
        this.eulaAcceptanceRequired = string3;
    }

    public ImageryInfo(String string, String string2, String string3, String string4) {
        this.name = string;
        this.setUrl(string2);
        this.cookies = string4;
        this.eulaAcceptanceRequired = string3;
    }

    public ImageryInfo(String string, String string2, String string3, double d) {
        this.name = string;
        this.setUrl(string2);
        this.cookies = string3;
        this.pixelPerDegree = d;
        this.eulaAcceptanceRequired = null;
    }

    public ArrayList<String> getInfoArray() {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (this.url != null && !this.url.isEmpty()) {
            string = this.getFullUrl();
        }
        if (this.cookies != null && !this.cookies.isEmpty()) {
            string2 = this.cookies;
        }
        if (this.imageryType == ImageryType.WMS || this.imageryType == ImageryType.HTML) {
            if (this.pixelPerDegree != 0.0) {
                string3 = String.valueOf(this.pixelPerDegree);
            }
        } else if (this.maxZoom != 0) {
            string3 = String.valueOf(this.maxZoom);
        }
        if (string3 != null && string2 == null) {
            string2 = "";
        }
        if (string2 != null && string == null) {
            string = "";
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.name);
        if (string != null) {
            arrayList.add(string);
        }
        if (string2 != null) {
            arrayList.add(string2);
        }
        if (string3 != null) {
            arrayList.add(string3);
        }
        return arrayList;
    }

    public ImageryInfo(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        this.name = arrayList.get(0);
        if (arrayList.size() >= 2) {
            this.setUrl(arrayList.get(1));
        }
        if (arrayList.size() >= 3) {
            this.cookies = arrayList.get(2);
        }
        if (arrayList.size() >= 4) {
            if (this.imageryType == ImageryType.WMS || this.imageryType == ImageryType.HTML) {
                this.pixelPerDegree = Double.valueOf(arrayList.get(3));
            } else {
                this.maxZoom = Integer.valueOf(arrayList.get(3));
            }
        }
        this.eulaAcceptanceRequired = null;
    }

    public ImageryInfo(ImageryInfo imageryInfo) {
        this.name = imageryInfo.name;
        this.url = imageryInfo.url;
        this.cookies = imageryInfo.cookies;
        this.imageryType = imageryInfo.imageryType;
        this.pixelPerDegree = imageryInfo.pixelPerDegree;
        this.eulaAcceptanceRequired = null;
    }

    @Override
    public int compareTo(ImageryInfo imageryInfo) {
        int n = this.name.compareTo(imageryInfo.name);
        if (n == 0) {
            n = this.url.compareTo(imageryInfo.url);
        }
        if (n == 0) {
            n = Double.compare(this.pixelPerDegree, imageryInfo.pixelPerDegree);
        }
        return n;
    }

    public boolean equalsBaseValues(ImageryInfo imageryInfo) {
        return this.url.equals(imageryInfo.url);
    }

    public void setPixelPerDegree(double d) {
        this.pixelPerDegree = d;
    }

    public void setMaxZoom(int n) {
        this.maxZoom = n;
    }

    public void setUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string);
        for (ImageryType imageryType : ImageryType.values()) {
            if (!string.startsWith(imageryType.getUrlString() + ":")) continue;
            this.url = string.substring(imageryType.getUrlString().length() + 1);
            this.imageryType = imageryType;
            return;
        }
        this.url = string;
        this.imageryType = ImageryType.WMS;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCookies() {
        return this.cookies;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public String getFullUrl() {
        return this.imageryType.getUrlString() + ":" + this.url;
    }

    public String getToolbarName() {
        String string = this.name;
        if (this.pixelPerDegree != 0.0) {
            string = string + "#PPD=" + this.pixelPerDegree;
        }
        return string;
    }

    public String getMenuName() {
        String string = this.name;
        if (this.pixelPerDegree != 0.0) {
            string = string + " (" + this.pixelPerDegree + ")";
        } else if (this.maxZoom != 0) {
            string = string + " (z" + this.maxZoom + ")";
        }
        return string;
    }

    public ImageryType getImageryType() {
        return this.imageryType;
    }

    public static boolean isUrlWithPatterns(String string) {
        return string != null && string.contains("{") && string.contains("}");
    }

    public boolean isBlacklisted() {
        return OsmApi.getOsmApi().getCapabilities().isOnImageryBlacklist(this.url);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageryType {
        WMS("wms"),
        TMS("tms"),
        HTML("html"),
        BING("bing"),
        SCANEX("scanex");

        private String urlString;

        private ImageryType(String string2) {
            this.urlString = string2;
        }

        public String getUrlString() {
            return this.urlString;
        }
    }
}

