/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.MissingOAuthAccessTokenException;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDialogUtil {
    private ExceptionDialogUtil() {
    }

    public static void explainOsmApiInitializationException(OsmApiInitializationException osmApiInitializationException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainOsmApiInitializationException(osmApiInitializationException), I18n.tr("Error"), 0, HelpUtil.ht("/ErrorMessages#OsmApiInitializationException"));
    }

    public static void explainChangesetClosedException(ChangesetClosedException changesetClosedException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainChangesetClosedException(changesetClosedException), I18n.tr("Error"), 0, HelpUtil.ht("/Action/Upload#ChangesetClosed"));
    }

    public static void explainPreconditionFailed(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainPreconditionFailed(osmApiException), I18n.tr("Precondition violation"), 0, HelpUtil.ht("/ErrorMessages#OsmApiException"));
    }

    public static void explainGeneric(Exception exception) {
        exception.printStackTrace();
        BugReportExceptionHandler.handleException(exception);
    }

    public static void explainSecurityException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainSecurityException(osmTransferException), I18n.tr("Security exception"), 0, HelpUtil.ht("/ErrorMessages#SecurityException"));
    }

    public static void explainNestedSocketException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedSocketException(osmTransferException), I18n.tr("Network exception"), 0, HelpUtil.ht("/ErrorMessages#NestedSocketException"));
    }

    public static void explainNestedIOException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedIOException(osmTransferException), I18n.tr("IO Exception"), 0, HelpUtil.ht("/ErrorMessages#NestedIOException"));
    }

    public static void explainNestedIllegalDataException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedIllegalDataException(osmTransferException), I18n.tr("Illegal Data"), 0, HelpUtil.ht("/ErrorMessages#IllegalDataException"));
    }

    public static void explainNestedInvocationTargetException(Exception exception) {
        InvocationTargetException invocationTargetException = ExceptionDialogUtil.getNestedException(exception, InvocationTargetException.class);
        if (invocationTargetException != null) {
            BugReportExceptionHandler.handleException(invocationTargetException);
            return;
        }
    }

    public static void explainInternalServerError(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainInternalServerError(osmTransferException), I18n.tr("Internal Server Error"), 0, HelpUtil.ht("/ErrorMessages#InternalServerError"));
    }

    public static void explainBadRequest(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainBadRequest(osmApiException), I18n.tr("Bad Request"), 0, HelpUtil.ht("/ErrorMessages#BadRequest"));
    }

    public static void explainNotFound(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNotFound(osmApiException), I18n.tr("Not Found"), 0, HelpUtil.ht("/ErrorMessages#NotFound"));
    }

    public static void explainConflict(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainConflict(osmApiException), I18n.tr("Conflict"), 0, HelpUtil.ht("/ErrorMessages#Conflict"));
    }

    public static void explainAuthenticationFailed(OsmApiException osmApiException) {
        String string = Main.pref.get("osm-server.auth-method", "basic");
        String string2 = string.equals("oauth") ? ExceptionUtil.explainFailedOAuthAuthentication(osmApiException) : ExceptionUtil.explainFailedBasicAuthentication(osmApiException);
        HelpAwareOptionPane.showOptionDialog(Main.parent, string2, I18n.tr("Authentication Failed"), 0, HelpUtil.ht("/ErrorMessages#AuthenticationFailed"));
    }

    public static void explainAuthorizationFailed(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainFailedAuthorisation(osmApiException), I18n.tr("Authorisation Failed"), 0, HelpUtil.ht("/ErrorMessages#AuthenticationFailed"));
    }

    public static void explainClientTimeout(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainClientTimeout(osmApiException), I18n.tr("Client Time Out"), 0, HelpUtil.ht("/ErrorMessages#ClientTimeOut"));
    }

    public static void explainGenericHttpException(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainClientTimeout(osmApiException), I18n.tr("Communication with OSM server failed"), 0, HelpUtil.ht("/ErrorMessages#GenericCommunicationError"));
    }

    public static void explainMissingOAuthAccessTokenException(MissingOAuthAccessTokenException missingOAuthAccessTokenException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainMissingOAuthAccessTokenException(missingOAuthAccessTokenException), I18n.tr("Authentication failed"), 0, HelpUtil.ht("/ErrorMessages#MissingOAuthAccessToken"));
    }

    public static void explainNestedUnkonwnHostException(OsmTransferException osmTransferException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainNestedUnknownHostException(osmTransferException), I18n.tr("Unknown host"), 0, HelpUtil.ht("/ErrorMessages#UnknownHost"));
    }

    protected static <T> T getNestedException(Exception exception, Class<T> clazz) {
        Throwable throwable;
        for (throwable = exception; throwable != null && !clazz.isInstance(throwable); throwable = throwable.getCause()) {
        }
        if (throwable == null) {
            return null;
        }
        if (clazz.isInstance(throwable)) {
            return clazz.cast(throwable);
        }
        return null;
    }

    public static void explainOsmTransferException(OsmTransferException osmTransferException) {
        if (ExceptionDialogUtil.getNestedException(osmTransferException, SecurityException.class) != null) {
            ExceptionDialogUtil.explainSecurityException(osmTransferException);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(osmTransferException, SocketException.class) != null) {
            ExceptionDialogUtil.explainNestedSocketException(osmTransferException);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(osmTransferException, UnknownHostException.class) != null) {
            ExceptionDialogUtil.explainNestedUnkonwnHostException(osmTransferException);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(osmTransferException, IOException.class) != null) {
            ExceptionDialogUtil.explainNestedIOException(osmTransferException);
            return;
        }
        if (ExceptionDialogUtil.getNestedException(osmTransferException, IllegalDataException.class) != null) {
            ExceptionDialogUtil.explainNestedIllegalDataException(osmTransferException);
            return;
        }
        if (osmTransferException instanceof OsmApiInitializationException) {
            ExceptionDialogUtil.explainOsmApiInitializationException((OsmApiInitializationException)osmTransferException);
            return;
        }
        if (osmTransferException instanceof ChangesetClosedException) {
            ExceptionDialogUtil.explainChangesetClosedException((ChangesetClosedException)osmTransferException);
            return;
        }
        if (osmTransferException instanceof MissingOAuthAccessTokenException) {
            ExceptionDialogUtil.explainMissingOAuthAccessTokenException((MissingOAuthAccessTokenException)osmTransferException);
            return;
        }
        if (osmTransferException instanceof OsmApiException) {
            OsmApiException osmApiException = (OsmApiException)osmTransferException;
            switch (osmApiException.getResponseCode()) {
                case 412: {
                    ExceptionDialogUtil.explainPreconditionFailed(osmApiException);
                    return;
                }
                case 410: {
                    ExceptionDialogUtil.explainGoneForUnknownPrimitive(osmApiException);
                    return;
                }
                case 500: {
                    ExceptionDialogUtil.explainInternalServerError(osmApiException);
                    return;
                }
                case 400: {
                    ExceptionDialogUtil.explainBadRequest(osmApiException);
                    return;
                }
                case 404: {
                    ExceptionDialogUtil.explainNotFound(osmApiException);
                    return;
                }
                case 409: {
                    ExceptionDialogUtil.explainConflict(osmApiException);
                    return;
                }
                case 401: {
                    ExceptionDialogUtil.explainAuthenticationFailed(osmApiException);
                    return;
                }
                case 403: {
                    ExceptionDialogUtil.explainAuthorizationFailed(osmApiException);
                    return;
                }
                case 408: {
                    ExceptionDialogUtil.explainClientTimeout(osmApiException);
                    return;
                }
            }
            ExceptionDialogUtil.explainGenericHttpException(osmApiException);
            return;
        }
        ExceptionDialogUtil.explainGeneric(osmTransferException);
    }

    public static void explainGoneForUnknownPrimitive(OsmApiException osmApiException) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, ExceptionUtil.explainGoneForUnknownPrimitive(osmApiException), I18n.tr("Object deleted"), 0, HelpUtil.ht("/ErrorMessages#GoneForUnknownPrimitive"));
    }

    public static void explainException(Exception exception) {
        if (ExceptionDialogUtil.getNestedException(exception, InvocationTargetException.class) != null) {
            ExceptionDialogUtil.explainNestedInvocationTargetException(exception);
            return;
        }
        if (exception instanceof OsmTransferException) {
            ExceptionDialogUtil.explainOsmTransferException((OsmTransferException)exception);
            return;
        }
        ExceptionDialogUtil.explainGeneric(exception);
    }
}

